/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui;

import com.unisys.tde.core.OS2200FileEditorInput;
import com.unisys.tde.core.OS2200FileInterface;
import com.unisys.tde.core.RuntimeExec;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.preferences.COBOLBasePreferencePage;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.commands.ICommandService;

public class Starter
implements IStartup {
    private final ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);

    public void earlyStartup() {
        COBOLBasePreferencePage.initDefaults(CorePlugin.getDefault().getPreferenceStore());
        final IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        if (iPreferenceStore.getString("ControlChar").length() == 0) {
            iPreferenceStore.setValue("ControlChar", "~");
            try {
                ((IPersistentPreferenceStore)iPreferenceStore).save();
            }
            catch (IOException iOException) {}
        }
        iPreferenceStore.setValue("EnableControlChar", iPreferenceStore.getBoolean("EnableControlChar"));
        try {
            ((IPersistentPreferenceStore)iPreferenceStore).save();
        }
        catch (IOException iOException) {}
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                try {
                    progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            iProgressMonitor.beginTask("Finalizing Unisys plugins . . . ", -1);
                            iWorkbenchWindow.addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

                                public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                                    super.perspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
                                    Starter.this.hideOS2200Menu(iPerspectiveDescriptor);
                                }

                                public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchPartReference iWorkbenchPartReference, String string) {
                                    Starter.this.hideOS2200Menu(iPerspectiveDescriptor);
                                }
                            });
                            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                                public boolean preShutdown(IWorkbench iWorkbench, boolean bl) {
                                    if (OS2200FileInterface.forceRestart) {
                                        return true;
                                    }
                                    Starter.this.closeOpenEditorsOnExit();
                                    Starter.this.closeOFCSOpenEditors();
                                    return true;
                                }

                                public void postShutdown(IWorkbench iWorkbench) {
                                }
                            });
                        }
                    });
                }
                catch (Exception exception) {
                    CBDTUiPlugin.logError(exception);
                }
            }
        });
    }

    protected void disconnectMapDriveOnExit() {
        try {
            List<String> list;
            Command command = this.service.getCommand("com.unisys.jai.core.DisMapDriveAtExitCmd");
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            if (((Boolean)state.getValue()).booleanValue() && (list = this.getDriveList()) != null && list.size() > 0) {
                for (String string : list) {
                    if (!this.isHostPresent(string) || string == null || string.length() <= 0) continue;
                    RuntimeExec runtimeExec = RuntimeExec.getRuntimeExecInst();
                    if (runtimeExec.disConnectMapDrive(string)) {
                        CBDTUiPlugin.logTraceMessage(String.valueOf(string) + " disconnected successfully.");
                        continue;
                    }
                    CBDTUiPlugin.logTraceMessage(String.valueOf(string) + " was not disconnected. Please try manually to delete this drive.");
                    MessageDialog.openWarning((Shell)new Shell(), (String)"Issue with restarting Eclispe", (String)"Please delete the mapped drive manually and restart eclipse.");
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    protected void closeOpenEditorsOnExit() {
        try {
            List<String> list;
            State state;
            IWorkbenchPage iWorkbenchPage;
            Command command = this.service.getCommand("com.unisys.jai.core.CloseOpenEditorsOnExitCmd");
            State state2 = command.getState("org.eclipse.ui.commands.toggleState");
            if (((Boolean)state2.getValue()).booleanValue()) {
                iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                iWorkbenchPage.closeEditors(iWorkbenchPage.getEditorReferences(), true);
            }
            if (((Boolean)(state = (iWorkbenchPage = this.service.getCommand("com.unisys.jai.core.DisMapDriveAtExitCmd")).getState("org.eclipse.ui.commands.toggleState")).getValue()).booleanValue() && (list = this.getDriveList()) != null && list.size() > 0) {
                for (String string : list) {
                    if (!this.isHostPresent(string) || string == null || string.length() <= 0) continue;
                    RuntimeExec runtimeExec = RuntimeExec.getRuntimeExecInst();
                    if (runtimeExec.disConnectMapDrive(string)) {
                        CBDTUiPlugin.logTraceMessage(String.valueOf(string) + " disconnected successfully.");
                        continue;
                    }
                    CBDTUiPlugin.logTraceMessage(String.valueOf(string) + " was not disconnected. Please try manually to delete this drive.");
                    MessageDialog.openWarning((Shell)new Shell(), (String)"Issue with restarting Eclispe", (String)"Please delete the mapped drive manually and restart eclipse.");
                }
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private boolean isHostPresent(String string) {
        List list = null;
        String string2 = null;
        try {
            list = OS2200FileInterface.getHostNames();
            string2 = string.substring(string.indexOf("\\\\") + 2, string.lastIndexOf("\\"));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return list.contains(string2);
    }

    private List<String> getDriveList() {
        ArrayList<String> arrayList = null;
        try {
            RuntimeExec runtimeExec = RuntimeExec.getRuntimeExecInst();
            runtimeExec.executeCMD("net use");
            String string = runtimeExec.getOut();
            arrayList = new ArrayList<String>();
            while (string.contains("OK") || string.contains("DISCONNECTED")) {
                string = string.substring(string.indexOf("OK"));
                String string2 = string.substring(string.indexOf("OK") + 2, string.indexOf("Microsoft Windows Network")).trim();
                CBDTUiPlugin.logTraceMessage(String.valueOf(string2) + " to be disconncted.");
                arrayList.add(string2);
                string = string.substring(string.indexOf("Microsoft Windows Network"));
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
        return arrayList;
    }

    private void hideOS2200Menu(IPerspectiveDescriptor iPerspectiveDescriptor) {
        try {
            IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IActivityManager iActivityManager = iWorkbenchActivitySupport.getActivityManager();
            HashSet<String> hashSet = new HashSet<String>(iActivityManager.getEnabledActivityIds());
            if (!iPerspectiveDescriptor.getId().equalsIgnoreCase("com.unisys.tde.OS2200Perspective")) {
                if (hashSet.remove("os2200.contributions")) {
                    iWorkbenchActivitySupport.setEnabledActivityIds(hashSet);
                }
            } else if (hashSet.add("os2200.contributions")) {
                iWorkbenchActivitySupport.setEnabledActivityIds(hashSet);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private void closeOFCSOpenEditors() {
        try {
            IWorkbenchPage iWorkbenchPage;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                IEditorInput iEditorInput = null;
                ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>(50);
                int n = 0;
                while (n < iEditorReferenceArray.length) {
                    iEditorInput = iEditorReferenceArray[n].getEditorInput();
                    if (iEditorInput instanceof OS2200FileEditorInput) {
                        arrayList.add(iEditorReferenceArray[n]);
                    }
                    ++n;
                }
                IEditorReference[] iEditorReferenceArray2 = arrayList.toArray(new IEditorReference[arrayList.size()]);
                iWorkbenchPage.closeEditors(iEditorReferenceArray2, true);
            }
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }
}

