/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.views.common.ViewerPerspectiveChangeListener;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.WorkbenchWindow;

public class COBOLPerspectiveFactory
implements IPerspectiveFactory {
    private static final String COBOL_PERSPECTIVE_ID = "org.eclipse.cobol.ui.COBOLPerspective";
    private static final String TEMPLATE_VIEW_ID = "org.eclipse.cobol.ui.views.templates.COBOLTemplateViewPart";
    private static final String COBOL_SOURCE_SAMPLE_ID = "org.eclipse.cobol.projectmanagement.SimpleCOBOL.wizards.SimpleCOBOLSourceCreationWizard";
    private static final String DEBUG_PERSPECTIVE_ID = "org.eclipse.debug.ui.DebugPerspective";
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        }

        public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
            if (iPerspectiveDescriptor != null && iPerspectiveDescriptor.getId().equalsIgnoreCase(COBOLPerspectiveFactory.COBOL_PERSPECTIVE_ID)) {
                try {
                    IViewPart iViewPart = CBDTUiPlugin.getActivePage().findView("org.eclipse.cobol.ui.views.dependency.DependencyView");
                    CBDTUiPlugin.getActivePage().bringToTop((IWorkbenchPart)iViewPart);
                    CBDTUiPlugin.getActivePage().activate(CBDTUiPlugin.getActivePage().getActivePart());
                    ((WorkbenchWindow)CBDTUiPlugin.getActiveWorkbenchWindow()).removePerspectiveListener(COBOLPerspectiveFactory.this.perspectiveListener);
                }
                catch (Exception exception) {}
            }
        }
    };

    public COBOLPerspectiveFactory() {
        ((WorkbenchWindow)CBDTUiPlugin.getActiveWorkbenchWindow()).addPerspectiveListener(this.perspectiveListener);
        ((WorkbenchWindow)CBDTUiPlugin.getActiveWorkbenchWindow()).addPerspectiveListener((IPerspectiveListener)new ViewerPerspectiveChangeListener());
    }

    public void createInitialLayout(IPageLayout iPageLayout) {
        String string = iPageLayout.getEditorArea();
        ArrayList arrayList = new ArrayList();
        IFolderLayout iFolderLayout = iPageLayout.createFolder("topleft", 1, 0.25f, string);
        iFolderLayout.addView("org.eclipse.cobol.ui.views.dependency.DependencyView");
        iFolderLayout.addView("org.eclipse.cobol.ui.views.structures.StructuresView");
        iFolderLayout.addView("org.eclipse.ui.views.ResourceNavigator");
        IFolderLayout iFolderLayout2 = iPageLayout.createFolder("bottom", 4, 0.75f, string);
        iFolderLayout2.addView("org.eclipse.ui.views.ProblemView");
        iFolderLayout2.addView("org.eclipse.ui.console.ConsoleView");
        IFolderLayout iFolderLayout3 = iPageLayout.createFolder("topright", 2, 0.75f, string);
        iFolderLayout3.addView("org.eclipse.ui.views.ContentOutline");
        iFolderLayout3.addPlaceholder(TEMPLATE_VIEW_ID);
        iPageLayout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        iPageLayout.addShowViewShortcut("org.eclipse.debug.ui.ConsoleView");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        iPageLayout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        iPageLayout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        arrayList = this.getListOfCOBOLSourceCOntribution();
        int n = 0;
        while (n < arrayList.size()) {
            COBOLSourceContributor cOBOLSourceContributor = (COBOLSourceContributor)arrayList.get(n);
            iPageLayout.addNewWizardShortcut(cOBOLSourceContributor.getClassName());
            ++n;
        }
        iPageLayout.addPerspectiveShortcut(DEBUG_PERSPECTIVE_ID);
    }

    private static void disableAutoBuild() {
        try {
            IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
            if (iWorkspaceDescription.isAutoBuilding()) {
                iWorkspaceDescription.setAutoBuilding(false);
                ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
            }
        }
        catch (CoreException coreException) {
            CBDTUiPlugin.logError((Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
        }
    }

    private ArrayList getListOfCOBOLSourceCOntribution() {
        ArrayList<COBOLSourceContributor> arrayList = new ArrayList<COBOLSourceContributor>(10);
        IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.ui.newWizards");
        int n = 0;
        while (iConfigurationElementArray != null && n < iConfigurationElementArray.length) {
            String string = "";
            string = iConfigurationElementArray[n].getName();
            if (string != null && string.equalsIgnoreCase("wizard")) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren();
                int n2 = 0;
                while (iConfigurationElementArray2 != null && n2 < iConfigurationElementArray2.length) {
                    IExtension iExtension = iConfigurationElementArray2[n2].getDeclaringExtension();
                    IConfigurationElement[] iConfigurationElementArray3 = iExtension.getConfigurationElements();
                    int n3 = 0;
                    while (iConfigurationElementArray3 != null && n3 < iConfigurationElementArray3.length) {
                        string = iConfigurationElementArray3[n3].getName();
                        if (string != null && string.equalsIgnoreCase("wizard")) {
                            String string2 = iConfigurationElementArray3[n3].getAttribute("category");
                            String string3 = "";
                            String string4 = "";
                            if (string2 != null && string2.equalsIgnoreCase("org.eclipse.cobol.ui.wizards.projectmanagement.cobolProjectCategory/org.eclipse.cobol.ui.wizards.projectmanagement.cobolProjectCategory.Source")) {
                                string3 = iConfigurationElementArray3[n3].getAttribute("name");
                                string4 = iConfigurationElementArray3[n3].getAttribute("class");
                                if (!this.isExists(arrayList, string4)) {
                                    arrayList.add(new COBOLSourceContributor(string4, string3));
                                }
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Collections.sort(arrayList, new COBOLSourceContributorComparator());
        return arrayList;
    }

    private boolean isExists(ArrayList arrayList, String string) {
        int n = 0;
        while (string != null && n < arrayList.size()) {
            if (arrayList.get(n).toString().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    class COBOLSourceContributor {
        private String className;
        private String contributorName;

        public COBOLSourceContributor(String string, String string2) {
            this.className = string;
            this.contributorName = string2;
        }

        public String getClassName() {
            return this.className;
        }

        public String getContributorName() {
            return this.contributorName;
        }

        public String toString() {
            return this.contributorName;
        }
    }

    class COBOLSourceContributorComparator
    implements Comparator {
        COBOLSourceContributorComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = "";
            String string2 = "";
            if (object instanceof COBOLSourceContributor) {
                string = ((COBOLSourceContributor)object).toString().trim();
            }
            if (object2 instanceof COBOLSourceContributor) {
                string2 = ((COBOLSourceContributor)object2).toString().trim();
            }
            if (string != null && string2 != null) {
                return Collator.getInstance().compare(string, string2);
            }
            return 0;
        }
    }
}

