/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui;

import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class COBOLElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int SYNCHRONIZED = 4;
    public static final int STATIC = 8;
    public static final int RUNNABLE = 16;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    public static final int CONSTRUCTOR = 512;
    public static final int DEPRECATED = 1024;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public COBOLElementImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.fBaseImage = imageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = n;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = point;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fFlags = n;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point point) {
        Assert.isNotNull((Object)point);
        Assert.isTrue((point.x >= 0 && point.y >= 0 ? 1 : 0) != 0);
        this.fSize = point;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !COBOLElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        COBOLElementImageDescriptor cOBOLElementImageDescriptor = (COBOLElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(cOBOLElementImageDescriptor.fBaseImage) && this.fFlags == cOBOLElementImageDescriptor.fFlags && this.fSize.equals((Object)cOBOLElementImageDescriptor.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.getImageData(this.fBaseImage);
        this.drawImage(imageData, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData();
        return imageData;
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        ImageData imageData;
        Point point = this.getSize();
        int n = 0;
        if ((this.fFlags & 0x40) != 0) {
            imageData = this.getImageData(COBOLPluginImages.DESC_OVR_ERROR);
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            imageData = this.getImageData(COBOLPluginImages.DESC_OVR_WARNING);
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
    }
}

