/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.ui;

import java.net.URL;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.common.ICOBOLLanguageModel;
import org.eclipse.cobol.ui.CBDTRunnable;
import org.eclipse.cobol.ui.common.COBOLLanguageModel;
import org.eclipse.cobol.ui.common.text.COBOLTextFactory;
import org.eclipse.cobol.ui.fixedformat.COBOLFixedFormatDocumentProvider;
import org.eclipse.cobol.ui.freeformat.COBOLFreeFormatDocumentProvider;
import org.eclipse.cobol.ui.preferences.COBOLEditorPreferencePage;
import org.eclipse.cobol.ui.views.outlineview.COBOLParserRegistry;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CBDTUiPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 20;
    private boolean trace = true;
    private static CBDTUiPlugin plugin = null;
    private COBOLTextFactory fCOBOLTextFactory;
    private COBOLFixedFormatDocumentProvider fFixedFormatDocumentProvider = null;
    private COBOLFreeFormatDocumentProvider fFreeFormatDocumentProvider = null;
    private COBOLParserRegistry fParserRegistry = null;

    public CBDTUiPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
    }

    public static CBDTUiPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        super.initializeDefaultPreferences(iPreferenceStore);
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)iPreferenceStore);
        COBOLEditorPreferencePage.initDefaults(iPreferenceStore);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.fCOBOLTextFactory != null) {
            this.fCOBOLTextFactory.dispose();
            this.fCOBOLTextFactory = null;
        }
        if (this.fFixedFormatDocumentProvider != null) {
            this.fFixedFormatDocumentProvider.shutdown();
            this.fFixedFormatDocumentProvider = null;
        }
        if (this.fFreeFormatDocumentProvider != null) {
            this.fFreeFormatDocumentProvider.shutdown();
            this.fFreeFormatDocumentProvider = null;
        }
        if (this.fParserRegistry != null) {
            this.fParserRegistry.dispose();
            this.fParserRegistry = null;
        }
    }

    public void startup() throws CoreException {
        super.startup();
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor != null) {
            ICOBOLLanguageModel iCOBOLLanguageModel = iCOBOLContributor.getCOBOLLanguageModel();
            iCOBOLLanguageModel.setReservedSet(this.getPreferenceStore().getString("Reserved Word"));
        } else {
            COBOLLanguageModel cOBOLLanguageModel = new COBOLLanguageModel();
            cOBOLLanguageModel.setReservedSet(this.getPreferenceStore().getString("Reserved Word"));
        }
    }

    public COBOLParserRegistry getCOBOLParserRegistry() {
        if (this.fParserRegistry == null) {
            this.fParserRegistry = new COBOLParserRegistry();
        }
        return this.fParserRegistry;
    }

    public COBOLTextFactory getCOBOLTextFactory() {
        this.fCOBOLTextFactory = new COBOLTextFactory(this.getPreferenceStore());
        return this.fCOBOLTextFactory;
    }

    public static void logError(Exception exception) {
        try {
            Exception exception2 = exception;
            CBDTUiPlugin.log((IStatus)new Status(4, CBDTUiPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 20, "Internal error occured: ", (Throwable)exception2));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public static void logError(String string, Exception exception) {
        try {
            Exception exception2 = exception;
            CBDTUiPlugin.log((IStatus)new Status(4, CBDTUiPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 20, string, (Throwable)exception2));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public static void logError(String string, Exception exception, int n) {
        try {
            Exception exception2 = exception;
            CBDTUiPlugin.log((IStatus)new Status(n, CBDTUiPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 20, string, (Throwable)exception2));
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public static void log(IStatus iStatus) {
        try {
            CBDTUiPlugin.getDefault().getLog().log(iStatus);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private boolean isTraceMode() {
        return this.trace;
    }

    public static void logTraceMessage(String string) {
        try {
            if (CBDTUiPlugin.getDefault().isTraceMode()) {
                Status status = new Status(1, CBDTUiPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 20, string, null);
                CBDTUiPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        catch (NullPointerException nullPointerException) {
            CBDTUiPlugin.logError(nullPointerException);
        }
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public static IWorkbenchPage getActivePage() {
        CBDTRunnable cBDTRunnable = null;
        if (CBDTUiPlugin.getActiveWorkbenchWindow() == null) {
            cBDTRunnable = new CBDTRunnable(){

                @Override
                public void run() {
                    if (CBDTUiPlugin.getActiveWorkbenchWindow() != null) {
                        IWorkbenchPage iWorkbenchPage = CBDTUiPlugin.getActiveWorkbenchWindow().getActivePage();
                        this.setObjectValue(iWorkbenchPage);
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)cBDTRunnable);
            if (cBDTRunnable.getObjectValue() != null) {
                return (IWorkbenchPage)cBDTRunnable.getObjectValue();
            }
            return null;
        }
        return CBDTUiPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CBDTUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getPluginId() {
        try {
            return CBDTUiPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        }
        catch (Exception exception) {
            CBDTUiPlugin.logError(exception);
            return "";
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = CBDTUiPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getShell();
    }

    public COBOLFixedFormatDocumentProvider getFixedFormatDocumentProvider() {
        if (this.fFixedFormatDocumentProvider == null) {
            this.fFixedFormatDocumentProvider = new COBOLFixedFormatDocumentProvider();
        }
        return this.fFixedFormatDocumentProvider;
    }

    public COBOLFreeFormatDocumentProvider getFreeFormatDocumentProvider() {
        if (this.fFreeFormatDocumentProvider == null) {
            this.fFreeFormatDocumentProvider = new COBOLFreeFormatDocumentProvider();
        }
        return this.fFreeFormatDocumentProvider;
    }

    public static String getPluginLocation() {
        String string = null;
        try {
            string = Platform.resolve((URL)CBDTUiPlugin.getDefault().getDescriptor().getInstallURL()).getPath();
            if (string.startsWith("/") && Platform.getOS().equals("win32")) {
                string = string.substring(1);
                string = string.replace('/', '\\');
            }
        }
        catch (Exception exception) {}
        return string;
    }
}

