/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.projectmanagement.SimpleCOBOL.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.cobol.core.build.util.IBuildConstants;
import org.eclipse.cobol.core.ui.guiutility.GUIComponentCreationUtility;
import org.eclipse.cobol.core.ui.wizards.IProjectBrowserControl;
import org.eclipse.cobol.core.ui.wizards.IProjectBrowserValidator;
import org.eclipse.cobol.core.ui.wizards.ProjectBrowserControl;
import org.eclipse.cobol.core.util.ValidationManager;
import org.eclipse.cobol.ui.CBDTUiPlugin;
import org.eclipse.cobol.ui.COBOLPluginImages;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.cobol.ui.common.COBOLValidationManager;
import org.eclipse.cobol.ui.wizards.projectmanagement.ProjectCreationUtilClass;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class SimpleCOBOLSourceCreationPage
extends WizardNewProjectCreationPage
implements IProjectBrowserValidator {
    private static final String SIMPLE_COBOL_FILE_NAME = "SimpleCOBOLSourceCreationPage.FileName";
    private static final String SIMPLE_COBOL_PROGRAM_NAME = "SimpleCOBOLSourceCreationPage.ProgramName";
    private static final String SIMPLE_COBOL_EXPLANATION = "SimpleCOBOLSourceCreationPage.Explanation";
    private ResourceBundle fBundle = ResourceBundle.getBundle("com.unisys.os2200.i18nSupport.messages");
    private Text fCommentText;
    private static final String INVALID_FILE_PATH = "InvalidFilePath.error.msg";
    private IProjectBrowserControl fProjectBrowserControl;
    private boolean fFirstFlag = true;
    private Text fFileNameText;
    private Text fProgramIdText;
    private ModifyListener fFileNameModifyAdapter;
    private ModifyListener fProgramIdNameModifyAdapter;
    private String fFileExtension;
    private Composite fComposite;
    private boolean isProject;
    private String fProjectName;
    private Button fMainProgram;

    public SimpleCOBOLSourceCreationPage(String string, boolean bl, String string2) {
        super(string);
        this.setImageDescriptor(COBOLPluginImages.DESC_IMG_NEW_FILE);
        this.setTitle(Messages.getString((String)"SimpleCOBOLSourceCreationPage.TITLE"));
        this.setDescription(Messages.getString((String)"SimpleCOBOLSourceCreationPage.DESCRIPTION"));
        this.isProject = bl;
        this.fProjectName = string2;
        this.fFileNameModifyAdapter = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SimpleCOBOLSourceCreationPage.this.fProgramIdText.setText(SimpleCOBOLSourceCreationPage.this.fFileNameText.getText());
                SimpleCOBOLSourceCreationPage.this.setPageComplete(SimpleCOBOLSourceCreationPage.this.validateFileName());
                if (SimpleCOBOLSourceCreationPage.this.isPageComplete()) {
                    SimpleCOBOLSourceCreationPage.this.setPageComplete(SimpleCOBOLSourceCreationPage.this.validateFilePath());
                }
            }
        };
        this.fProgramIdNameModifyAdapter = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SimpleCOBOLSourceCreationPage.this.setPageComplete(SimpleCOBOLSourceCreationPage.this.validateFileName());
                if (SimpleCOBOLSourceCreationPage.this.isPageComplete()) {
                    SimpleCOBOLSourceCreationPage.this.setPageComplete(SimpleCOBOLSourceCreationPage.this.validateFilePath());
                }
            }
        };
    }

    public void createControl(Composite composite) {
        Composite composite2;
        this.fComposite = composite2 = GUIComponentCreationUtility.createComposite((Composite)composite, (int)0, null);
        this.createContents(composite2);
        this.setControl((Control)composite2);
    }

    private final void createContents(Composite composite) {
        GUIComponentCreationUtility.createGridLayout((Composite)composite, (int)1);
        GUIComponentCreationUtility.createGridLayout((Composite)composite, (int)2);
        this.createAttributeInfoGroup(composite);
    }

    private void createAttributeInfoGroup(Composite composite) {
        Composite composite2 = GUIComponentCreationUtility.createComposite((Composite)composite, (int)0, (Object)new GridData(768));
        int n = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        String string = ProjectCreationUtilClass.getProject();
        if (this.isProject) {
            string = this.fProjectName;
        }
        ProjectBrowserControl projectBrowserControl = new ProjectBrowserControl((IProjectBrowserValidator)this, this.getShell(), string);
        projectBrowserControl.createControl(composite2);
        this.fProjectBrowserControl = projectBrowserControl;
        if (this.isProject) {
            this.fProjectBrowserControl.setControlsDisabled();
        }
        GUIComponentCreationUtility.createLabel((Composite)composite2, (int)0, null, (String)SIMPLE_COBOL_FILE_NAME, (ResourceBundle)this.fBundle);
        GridData gridData = new GridData(768);
        gridData.widthHint = 325;
        this.fFileNameText = GUIComponentCreationUtility.createText((Composite)composite2, (int)2048, (Object)gridData, null);
        this.fFileNameText.addModifyListener(this.fFileNameModifyAdapter);
        GUIComponentCreationUtility.setToolTipText((Control)this.fFileNameText, (String)SIMPLE_COBOL_FILE_NAME, (ResourceBundle)this.fBundle);
        GUIComponentCreationUtility.createLabel((Composite)composite2, (int)0, null, (String)SIMPLE_COBOL_PROGRAM_NAME, (ResourceBundle)this.fBundle);
        gridData = new GridData(768);
        this.fProgramIdText = GUIComponentCreationUtility.createText((Composite)composite2, (int)2048, (Object)gridData, null);
        this.fProgramIdText.addModifyListener(this.fProgramIdNameModifyAdapter);
        GUIComponentCreationUtility.setToolTipText((Control)this.fProgramIdText, (String)SIMPLE_COBOL_PROGRAM_NAME, (ResourceBundle)this.fBundle);
        gridData = new GridData(768);
        GUIComponentCreationUtility.createLabel((Composite)composite2, (int)0, null, (String)SIMPLE_COBOL_EXPLANATION, (ResourceBundle)this.fBundle);
        gridData = new GridData(768);
        this.fCommentText = GUIComponentCreationUtility.createText((Composite)composite2, (int)2048, (Object)gridData, null);
        GUIComponentCreationUtility.setToolTipText((Control)this.fCommentText, (String)SIMPLE_COBOL_EXPLANATION, (ResourceBundle)this.fBundle);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fMainProgram = GUIComponentCreationUtility.createButton((Composite)composite2, (int)32, (Object)gridData, (String)"SimpleCOBOLSourceCreationPage.MainProgram", (ResourceBundle)this.fBundle);
        this.enableMainProgramn();
        projectBrowserControl.setTextListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SimpleCOBOLSourceCreationPage.this.enableMainProgramn();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ICOBOLHelpContextId.STANDARD_COBOL_SOURCE_CREATION);
    }

    private void enableMainProgramn() {
        IProject iProject;
        boolean bl = false;
        IWorkspace iWorkspace = CBDTUiPlugin.getWorkspace();
        String string = this.getProjectName();
        if (string != null && string.length() > 0 && this.isValidProject(iProject = iWorkspace.getRoot().getProject(string))) {
            try {
                String string2 = iProject.getPersistentProperty(IBuildConstants.EXE_LIB_MODE);
                if (string2 == null || !string2.equalsIgnoreCase("true")) {
                    bl = true;
                }
            }
            catch (Exception exception) {}
        }
        this.fMainProgram.setEnabled(bl);
    }

    public String getFileName() {
        if (this.fFileExtension == null || this.fFileExtension.equals("")) {
            return this.fFileNameText.getText().concat(".cob");
        }
        return this.fFileNameText.getText();
    }

    public String getProgramName() {
        return this.fProgramIdText.getText();
    }

    public String getExplanation() {
        return this.fCommentText.getText();
    }

    public boolean getMainProgram() {
        if (this.fMainProgram.isEnabled()) {
            return this.fMainProgram.getSelection();
        }
        return false;
    }

    public void setVisible(boolean bl) {
        this.fComposite.setVisible(bl);
        if (this.fFirstFlag) {
            this.setErrorMessage(null);
            this.fFirstFlag = false;
        }
        if (this.fProjectBrowserControl != null && !this.fProjectBrowserControl.getSelectedProject().equals("")) {
            this.fFileNameText.setFocus();
        }
    }

    private boolean validateFilePath() {
        if (this.fProjectBrowserControl.validateText().getSeverity() != 4) {
            String string = this.fProjectBrowserControl.getSelectedProject();
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IProject iProject = iWorkspace.getRoot().getProject(string);
            IPath iPath = iProject.getLocation();
            String string2 = iPath.append(File.separator).append(this.getFileName()).toString();
            if (string2.length() > 255) {
                this.setErrorMessage(this.fBundle.getString(INVALID_FILE_PATH));
                return false;
            }
        } else if (!this.fProjectBrowserControl.validateText().isOK()) {
            return false;
        }
        return true;
    }

    public boolean isValidProject(IProject iProject) {
        try {
            if (iProject.getDescription().hasNature("org.eclipse.cobol.core.COBOLNature") && iProject.isOpen()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void updatePageStatus(IStatus iStatus) {
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            this.setPageComplete(false);
        }
        if (!this.fFirstFlag && iStatus.isOK()) {
            this.setErrorMessage(null);
            this.setPageComplete(this.validateFileName());
        }
    }

    public String getProjectName() {
        return this.fProjectBrowserControl.getSelectedProject();
    }

    private boolean validateFileName() {
        String string = this.fFileNameText.getText();
        int n = string.indexOf(".");
        if (n != -1) {
            this.fFileExtension = n >= string.length() ? "" : string.substring(n + 1, string.length());
        }
        IStatus iStatus = ValidationManager.validateTargetFileName((String)string, (String)"filename");
        IStatus iStatus2 = COBOLValidationManager.getInstrance().validateCOBOLUserWord(true, false, this.fProgramIdText.getText(), Messages.getString((String)SIMPLE_COBOL_PROGRAM_NAME));
        if (this.fProjectBrowserControl.validateText().getSeverity() != 4) {
            if (!iStatus.isOK()) {
                String string2 = iStatus.getMessage();
                string2 = string2.concat(":").concat(this.fBundle.getString(SIMPLE_COBOL_FILE_NAME));
                this.setErrorMessage(string2);
                return false;
            }
            if (!iStatus2.isOK()) {
                String string3 = iStatus2.getMessage();
                this.setErrorMessage(string3);
                return false;
            }
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(this.fProjectBrowserControl.validateText().getMessage());
        this.setMessage(null);
        return true;
    }
}

