/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.lifecyclemapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingDiscoveryRequest;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.PackagingTypeMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.lifecyclemapping.ILifecycleMappingLabelProvider;
import org.eclipse.osgi.util.NLS;

public class AggregateMappingLabelProvider
implements ILifecycleMappingLabelProvider {
    private final List<ILifecycleMappingLabelProvider> content;
    private final ILifecycleMappingRequirement element;

    public AggregateMappingLabelProvider(ILifecycleMappingRequirement element, List<ILifecycleMappingLabelProvider> content) {
        this.content = content;
        this.element = element;
    }

    @Override
    public String getMavenText() {
        if (this.element instanceof PackagingTypeMappingConfiguration.LifecycleStrategyMappingRequirement) {
            return NLS.bind((String)"Connector {0}", (Object)((PackagingTypeMappingConfiguration.LifecycleStrategyMappingRequirement)this.element).getLifecycleMappingId());
        }
        if (this.element instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement) {
            MojoExecutionKey exec = ((MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)this.element).getExecution();
            return NLS.bind((String)"{0}:{1}:{2}", (Object[])new String[]{exec.getArtifactId(), exec.getVersion(), exec.getGoal(), String.valueOf(this.content.size())});
        }
        if (this.element instanceof PackagingTypeMappingConfiguration.PackagingTypeMappingRequirement) {
            return NLS.bind((String)"Packaging {0}", (Object)((PackagingTypeMappingConfiguration.PackagingTypeMappingRequirement)this.element).getPackaging());
        }
        if (this.element instanceof MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement) {
            return NLS.bind((String)"Connector {0}", (Object)((MojoExecutionMappingConfiguration.ProjectConfiguratorMappingRequirement)this.element).getProjectConfiguratorId());
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isError(LifecycleMappingDiscoveryRequest mappingConfiguration) {
        for (ILifecycleMappingLabelProvider pr : this.content) {
            if (!pr.isError(mappingConfiguration)) continue;
            return true;
        }
        return false;
    }

    public ILifecycleMappingLabelProvider[] getChildren() {
        return this.content.toArray(new ILifecycleMappingLabelProvider[this.content.size()]);
    }

    @Override
    public ILifecycleMappingRequirement getKey() {
        return this.element;
    }

    @Override
    public Collection<MavenProject> getProjects() {
        HashSet<MavenProject> projects = new HashSet<MavenProject>();
        for (ILifecycleMappingLabelProvider provider : this.content) {
            projects.addAll(provider.getProjects());
        }
        return projects;
    }

    public int hashCode() {
        return this.getMavenText().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AggregateMappingLabelProvider) {
            return other.hashCode() == this.hashCode();
        }
        return false;
    }
}

