/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportChangedProjectsCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedNodes = this.getSelectedNodes(event);
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        for (Object node : selectedNodes) {
            List<File> files = null;
            Repository repo = this.getRepository(event);
            if (repo == null || !(node instanceof PlotCommit)) {
                return null;
            }
            files = this.getChangedFiles((RevCommit)node, repo);
            Set<File> dotProjectFiles = this.findDotProjectFiles(files, repo);
            this.importProjects(dotProjectFiles);
        }
        return null;
    }

    private List<File> getChangedFiles(RevCommit commit, Repository repo) {
        try {
            ArrayList<File> files = new ArrayList<File>();
            TreeWalk tw = new TreeWalk(repo);
            tw.setRecursive(true);
            RevWalk walk = new RevWalk(repo);
            try {
                FileDiff[] diffs = FileDiff.compute(repo, tw, commit, TreeFilter.ALL);
                if (diffs != null && diffs.length > 0) {
                    String workDir = repo.getWorkTree().getAbsolutePath();
                    FileDiff[] fileDiffArray = diffs;
                    int n = diffs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileDiff d = fileDiffArray[n2];
                        String path = d.getPath();
                        File f = new File(String.valueOf(workDir) + File.separator + path);
                        files.add(f);
                        ++n2;
                    }
                }
            }
            finally {
                tw.release();
                walk.release();
            }
            return files;
        }
        catch (MissingObjectException e) {
            Activator.error(e.getMessage(), e);
        }
        catch (IncorrectObjectTypeException e) {
            Activator.error(e.getMessage(), e);
        }
        catch (CorruptObjectException e) {
            Activator.error(e.getMessage(), e);
        }
        catch (IOException e) {
            Activator.error(e.getMessage(), e);
        }
        return null;
    }

    private Repository getRepository(Object input) throws ExecutionException {
        if (input == null) {
            return null;
        }
        if (input instanceof RefNode) {
            Repository repo = ((RefNode)input).getRepository();
            return repo;
        }
        if (input instanceof ExecutionEvent) {
            ExecutionEvent event = (ExecutionEvent)input;
            IWorkbenchPart ap = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
            if (ap instanceof IHistoryView) {
                input = ((IHistoryView)ap).getHistoryPage().getInput();
                return this.getRepository(input);
            }
        } else {
            RepositoryMapping mapping;
            if (input instanceof HistoryPageInput) {
                return ((HistoryPageInput)input).getRepository();
            }
            if (input instanceof RepositoryTreeNode) {
                RepositoryTreeNode rptn = (RepositoryTreeNode)input;
                Repository repo = rptn.getRepository();
                return repo;
            }
            if (input instanceof IResource && (mapping = RepositoryMapping.getMapping((IResource)((IResource)input))) != null) {
                Repository repo = mapping.getRepository();
                return repo;
            }
        }
        return null;
    }

    private Set<File> findDotProjectFiles(List<File> files, Repository repo) {
        HashSet<File> result = new HashSet<File>();
        String workingTreeRootPath = repo.getWorkTree().toString();
        for (File changedFile : files) {
            File projectFile = this.searchEnclosingProjectInWorkDir(changedFile.getParentFile(), workingTreeRootPath);
            if (projectFile == null) continue;
            result.add(projectFile);
        }
        return result;
    }

    private File searchEnclosingProjectInWorkDir(File subFolder, String rootPath) {
        File projectFile = null;
        File currentPath = subFolder;
        while (currentPath.toString().startsWith(rootPath)) {
            projectFile = new File(String.valueOf(currentPath.toString()) + File.separator + ".project");
            if (projectFile.isFile()) break;
            projectFile = null;
            currentPath = currentPath.getParentFile();
        }
        return projectFile;
    }

    private void importProjects(final Set<File> dotProjectFiles) {
        WorkspaceJob job = new WorkspaceJob(UIText.ImportChangedProjectsCommand_ImportingChangedProjects){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (File f : dotProjectFiles) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    String ap = f.getAbsolutePath();
                    ImportChangedProjectsCommand.this.importProject(ap);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void importProject(String path) {
        try {
            IProjectDescription description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)new Path(path));
            if (description != null) {
                String projectName = description.getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project.exists()) {
                    if (!project.isOpen()) {
                        project.open(128, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    project.create(description, (IProgressMonitor)new NullProgressMonitor());
                    project.open(128, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }
}

