/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.text.NumberFormat;
import java.util.Properties;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryStatisticsPage
extends PropertyPage {
    private final NumberFormat bigFpFmt = NumberFormat.getInstance(SystemReader.getInstance().getLocale());
    private final NumberFormat bigIntFmt;

    public RepositoryStatisticsPage() {
        this.bigFpFmt.setMaximumFractionDigits(2);
        this.bigIntFmt = NumberFormat.getInstance(SystemReader.getInstance().getLocale());
    }

    protected Control createContents(Composite parent) {
        Table table = new Table(parent, 67586);
        String[] titles = new String[]{UIText.RepositoryStatistics_Description, UIText.RepositoryStatistics_LooseObjects, UIText.RepositoryStatistics_PackedObjects};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        Repository repo = (Repository)this.getElement().getAdapter(Repository.class);
        if (repo == null) {
            return table;
        }
        Git git = new Git(repo);
        GarbageCollectCommand gc = git.gc();
        try {
            Properties stats = gc.getStatistics();
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 200;
            table.setLayoutData((Object)data);
            TableItem item = new TableItem(table, 0);
            item.setText(0, UIText.RepositoryStatistics_NrOfObjects);
            item.setText(1, this.getStatsAsString(stats, "numberOfLooseObjects"));
            item.setText(2, this.getStatsAsString(stats, "numberOfPackedObjects"));
            item = new TableItem(table, 0);
            item.setText(0, UIText.RepositoryStatistics_NrOfPackfiles);
            item.setText(2, this.getStatsAsString(stats, "numberOfPackFiles"));
            item = new TableItem(table, 0);
            item.setText(0, UIText.RepositoryStatistics_NrOfRefs);
            item.setText(1, this.getStatsAsString(stats, "numberOfLooseRefs"));
            item.setText(2, this.getStatsAsString(stats, "numberOfPackedRefs"));
            item = new TableItem(table, 0);
            item.setText(0, UIText.RepositoryStatistics_SpaceNeededOnFilesystem);
            item.setText(1, this.describeSize(RepositoryStatisticsPage.getStatsAsLong(stats, "sizeOfLooseObjects")));
            item.setText(2, this.describeSize(RepositoryStatisticsPage.getStatsAsLong(stats, "sizeOfPackedObjects")));
            int i2 = 0;
            while (i2 < titles.length) {
                table.getColumn(i2).pack();
                ++i2;
            }
            parent.pack();
        }
        catch (GitAPIException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        return table;
    }

    private String getStatsAsString(Properties stats, String key) {
        return this.bigIntFmt.format(RepositoryStatisticsPage.firstNonNull(stats.get(key), ""));
    }

    private static long getStatsAsLong(Properties stats, String key) {
        Object value = stats.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return 0L;
    }

    private static <T> T firstNonNull(T first, T second) {
        return first != null ? first : second;
    }

    private String describeSize(long nrOfBytes) {
        if (nrOfBytes < 1000L) {
            return String.valueOf(this.bigIntFmt.format(nrOfBytes)) + " Bytes";
        }
        if (nrOfBytes < 1000000L) {
            return String.valueOf(this.bigFpFmt.format((double)nrOfBytes / 1000.0)) + " kB (" + this.bigIntFmt.format(nrOfBytes) + ")";
        }
        if (nrOfBytes < 1000000000L) {
            return String.valueOf(this.bigFpFmt.format((double)nrOfBytes / 1000000.0)) + " MB (" + this.bigIntFmt.format(nrOfBytes) + ")";
        }
        return String.valueOf(this.bigFpFmt.format((double)nrOfBytes / 1.0E9)) + " GB (" + this.bigIntFmt.format(nrOfBytes) + ")";
    }
}

