/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractivePreferences;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseInteractiveStepActionToolBarProvider {
    private ToolItem itemPick;
    private ToolItem itemSkip;
    private ToolItem itemEdit;
    private ToolItem itemSquash;
    private ToolItem itemFixup;
    private ToolItem itemReword;
    private ToolItem itemMoveUp;
    private ToolItem itemMoveDown;
    private final ToolItem[] rebaseActionItems = new ToolItem[6];
    private final RebaseInteractiveView view;
    private final ToolBar theToolbar;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());

    final ToolBar getTheToolbar() {
        return this.theToolbar;
    }

    public RebaseInteractiveStepActionToolBarProvider(Composite parent, int style, RebaseInteractiveView view) {
        this.theToolbar = new ToolBar(parent, style);
        this.view = view;
        this.createToolBarItems();
        this.theToolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RebaseInteractiveStepActionToolBarProvider.this.dispose();
            }
        });
    }

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    private void dispose() {
        this.resources.dispose();
    }

    private void createToolBarItems() {
        this.itemPick = new ToolItem(this.theToolbar, 16);
        this.itemPick.setImage(this.getImage(UIIcons.CHERRY_PICK));
        this.itemPick.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.PICK));
        this.itemPick.setText(UIText.RebaseInteractiveStepActionToolBarProvider_PickText);
        this.rebaseActionItems[0] = this.itemPick;
        this.itemSkip = new ToolItem(this.theToolbar, 16);
        this.itemSkip.setImage(this.getImage(UIIcons.REBASE_SKIP));
        this.itemSkip.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.SKIP));
        this.itemSkip.setText(UIText.RebaseInteractiveStepActionToolBarProvider_SkipText);
        this.rebaseActionItems[1] = this.itemSkip;
        this.itemEdit = new ToolItem(this.theToolbar, 16);
        this.itemEdit.setImage(this.getImage(UIIcons.EDITCONFIG));
        this.itemEdit.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.EDIT));
        this.itemEdit.setText(UIText.RebaseInteractiveStepActionToolBarProvider_EditText);
        this.rebaseActionItems[2] = this.itemEdit;
        this.itemSquash = new ToolItem(this.theToolbar, 16);
        this.itemSquash.setImage(this.getImage(UIIcons.SQUASH_UP));
        this.itemSquash.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.SQUASH));
        this.itemSquash.setText(UIText.RebaseInteractiveStepActionToolBarProvider_SquashText);
        this.rebaseActionItems[3] = this.itemSquash;
        this.itemFixup = new ToolItem(this.theToolbar, 16);
        this.itemFixup.setImage(this.getImage(UIIcons.FIXUP_UP));
        this.itemFixup.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.FIXUP));
        this.itemFixup.setText(UIText.RebaseInteractiveStepActionToolBarProvider_FixupText);
        this.rebaseActionItems[4] = this.itemFixup;
        this.itemReword = new ToolItem(this.theToolbar, 16);
        this.itemReword.setImage(this.getImage(UIIcons.REWORD));
        this.itemReword.addSelectionListener((SelectionListener)new ActionSelectionListener(RebaseInteractivePlan.ElementAction.REWORD));
        this.itemReword.setText(UIText.RebaseInteractiveStepActionToolBarProvider_RewordText);
        this.rebaseActionItems[5] = this.itemReword;
        new ToolItem(this.theToolbar, 2);
        this.itemMoveUp = new ToolItem(this.theToolbar, 0);
        this.itemMoveUp.setImage(this.getImage(UIIcons.ELCL16_PREVIOUS));
        this.itemMoveUp.setText(UIText.RebaseInteractiveStepActionToolBarProvider_MoveUpText);
        this.itemMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<RebaseInteractivePlan.PlanElement> selectedRebaseTodoLines = RebaseInteractiveStepActionToolBarProvider.this.getSelectedRebaseTodoLines();
                for (RebaseInteractivePlan.PlanElement planElement : selectedRebaseTodoLines) {
                    if (planElement.getElementType() != RebaseInteractivePlan.ElementType.TODO) {
                        return;
                    }
                    if (!RebaseInteractivePreferences.isOrderReversed()) {
                        RebaseInteractiveStepActionToolBarProvider.this.view.getCurrentPlan().moveTodoEntryUp(planElement);
                    } else {
                        RebaseInteractiveStepActionToolBarProvider.this.view.getCurrentPlan().moveTodoEntryDown(planElement);
                    }
                    RebaseInteractiveStepActionToolBarProvider.this.mapActionItemsToSelection(((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getSelection());
                }
            }
        });
        this.itemMoveDown = new ToolItem(this.theToolbar, 0);
        this.itemMoveDown.setImage(this.getImage(UIIcons.ELCL16_NEXT));
        this.itemMoveDown.setText(UIText.RebaseInteractiveStepActionToolBarProvider_MoveDownText);
        this.itemMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<RebaseInteractivePlan.PlanElement> selectedRebaseTodoLines = RebaseInteractiveStepActionToolBarProvider.this.getSelectedRebaseTodoLines();
                Collections.reverse(selectedRebaseTodoLines);
                for (RebaseInteractivePlan.PlanElement planElement : selectedRebaseTodoLines) {
                    if (planElement.getElementType() != RebaseInteractivePlan.ElementType.TODO) {
                        return;
                    }
                    if (!RebaseInteractivePreferences.isOrderReversed()) {
                        RebaseInteractiveStepActionToolBarProvider.this.view.getCurrentPlan().moveTodoEntryDown(planElement);
                    } else {
                        RebaseInteractiveStepActionToolBarProvider.this.view.getCurrentPlan().moveTodoEntryUp(planElement);
                    }
                    RebaseInteractiveStepActionToolBarProvider.this.mapActionItemsToSelection(((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getSelection());
                }
            }
        });
    }

    protected List<RebaseInteractivePlan.PlanElement> getSelectedRebaseTodoLines() {
        IStructuredSelection selection = (IStructuredSelection)this.view.planTreeViewer.getSelection();
        ArrayList<RebaseInteractivePlan.PlanElement> planEntries = new ArrayList<RebaseInteractivePlan.PlanElement>(selection.size());
        List candidates = selection.toList();
        for (Object candidate : candidates) {
            if (!(candidate instanceof RebaseInteractivePlan.PlanElement)) continue;
            planEntries.add((RebaseInteractivePlan.PlanElement)candidate);
        }
        return planEntries;
    }

    void mapActionItemsToSelection(ISelection selection) {
        this.setMoveItemsEnabled(false);
        if (selection == null || selection.isEmpty()) {
            if (this.theToolbar.isEnabled()) {
                this.theToolbar.setEnabled(false);
            }
            this.unselectAllActionItemsExecpt(null);
            return;
        }
        if (selection instanceof IStructuredSelection) {
            RebaseInteractivePlan.PlanElement firstSelectedEntry;
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object obj = structured.getFirstElement();
            if (!(obj instanceof RebaseInteractivePlan.PlanElement)) {
                return;
            }
            RebaseInteractivePlan.PlanElement lastSelectedEntry = firstSelectedEntry = (RebaseInteractivePlan.PlanElement)obj;
            RebaseInteractivePlan.ElementAction type = firstSelectedEntry.getPlanElementAction();
            boolean singleTypeSelected = true;
            if (!this.theToolbar.isEnabled() && !this.view.getCurrentPlan().hasRebaseBeenStartedYet()) {
                this.theToolbar.setEnabled(true);
            }
            if (structured.size() > 1) {
                for (Object selectedObj : structured.toList()) {
                    RebaseInteractivePlan.PlanElement entry;
                    if (!(selectedObj instanceof RebaseInteractivePlan.PlanElement)) continue;
                    lastSelectedEntry = entry = (RebaseInteractivePlan.PlanElement)selectedObj;
                    if (type == entry.getPlanElementAction()) continue;
                    singleTypeSelected = false;
                }
            }
            if (singleTypeSelected) {
                this.unselectAllActionItemsExecpt(this.getItemFor(type));
            } else {
                this.unselectAllActionItemsExecpt(null);
            }
            this.enableMoveButtons(firstSelectedEntry, lastSelectedEntry);
        }
    }

    private void enableMoveButtons(RebaseInteractivePlan.PlanElement firstSelectedEntry, RebaseInteractivePlan.PlanElement lastSelectedEntry) {
        List list = this.view.getCurrentPlan().getList();
        ArrayList<RebaseInteractivePlan.PlanElement> stepList = new ArrayList<RebaseInteractivePlan.PlanElement>();
        for (RebaseInteractivePlan.PlanElement planElement : list) {
            if (planElement.isComment()) continue;
            stepList.add(planElement);
        }
        int firstEntryIndex = stepList.indexOf(firstSelectedEntry);
        int lastEntryIndex = stepList.indexOf(lastSelectedEntry);
        if (!RebaseInteractivePreferences.isOrderReversed()) {
            this.itemMoveUp.setEnabled(firstEntryIndex > 0);
            this.itemMoveDown.setEnabled(lastEntryIndex < stepList.size() - 1);
        } else {
            this.itemMoveUp.setEnabled(firstEntryIndex < stepList.size() - 1);
            this.itemMoveDown.setEnabled(lastEntryIndex > 0);
        }
    }

    private ToolItem getItemFor(RebaseInteractivePlan.ElementAction type) {
        switch (type) {
            case EDIT: {
                return this.itemEdit;
            }
            case FIXUP: {
                return this.itemFixup;
            }
            case PICK: {
                return this.itemPick;
            }
            case REWORD: {
                return this.itemReword;
            }
            case SQUASH: {
                return this.itemSquash;
            }
            case SKIP: {
                return this.itemSkip;
            }
        }
        return null;
    }

    private void unselectAllActionItemsExecpt(ToolItem item) {
        int i = 0;
        while (i < this.rebaseActionItems.length) {
            ToolItem currItem = this.rebaseActionItems[i];
            if (currItem != null) {
                if (currItem == item) {
                    currItem.setSelection(true);
                } else {
                    currItem.setSelection(false);
                }
            }
            ++i;
        }
    }

    private void setMoveItemsEnabled(boolean enabled) {
        this.itemMoveDown.setEnabled(enabled);
        this.itemMoveUp.setEnabled(enabled);
    }

    private class ActionSelectionListener
    implements SelectionListener {
        private final RebaseInteractivePlan.ElementAction type;

        ActionSelectionListener(RebaseInteractivePlan.ElementAction action) {
            this.type = action;
        }

        public void widgetSelected(SelectionEvent e) {
            List<RebaseInteractivePlan.PlanElement> selected = RebaseInteractiveStepActionToolBarProvider.this.getSelectedRebaseTodoLines();
            if (selected == null || selected.isEmpty()) {
                return;
            }
            RebaseInteractivePlan.ElementAction typeToSet = this.type;
            if (this.type != RebaseInteractivePlan.ElementAction.PICK) {
                boolean allItemsHaveTargetType = true;
                for (RebaseInteractivePlan.PlanElement element : selected) {
                    allItemsHaveTargetType &= element.getPlanElementAction() == this.type;
                }
                if (allItemsHaveTargetType) {
                    typeToSet = RebaseInteractivePlan.ElementAction.PICK;
                    RebaseInteractiveStepActionToolBarProvider.this.itemPick.setSelection(true);
                    if (e.getSource() instanceof ToolItem) {
                        ((ToolItem)e.getSource()).setSelection(false);
                    }
                }
            }
            for (RebaseInteractivePlan.PlanElement element : selected) {
                element.setPlanElementAction(typeToSet);
            }
            RebaseInteractiveStepActionToolBarProvider.this.mapActionItemsToSelection(((RebaseInteractiveStepActionToolBarProvider)RebaseInteractiveStepActionToolBarProvider.this).view.planTreeViewer.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

