/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchSourcePage
extends WizardPage {
    private final Repository repository;
    private final RemoteConfig config;
    private Text sourceText;
    private List<Ref> remoteRefs;

    public FetchSourcePage(Repository repository, RemoteConfig config) {
        super(FetchSourcePage.class.getName());
        this.repository = repository;
        this.config = config;
        this.setTitle(UIText.FetchSourcePage_PageTitle);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label repositoryLabel = new Label(main, 0);
        repositoryLabel.setText(UIText.FetchSourcePage_RepositoryLabel);
        Text repositoryText = new Text(main, 2056);
        repositoryText.setText(((URIish)this.config.getURIs().get(0)).toPrivateString());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)repositoryText);
        Label sourceLabel = new Label(main, 0);
        sourceLabel.setText(UIText.FetchSourcePage_SourceLabel);
        this.sourceText = new Text(main, 2048);
        this.sourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FetchSourcePage.this.checkPage();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sourceText);
        UIUtils.addRefContentProposalToText(this.sourceText, this.repository, new UIUtils.IRefListProvider(){

            @Override
            public List<Ref> getRefList() {
                return FetchSourcePage.this.getRemoteRefs();
            }
        });
        this.checkPage();
        this.setControl((Control)main);
    }

    private void checkPage() {
        this.setMessage(null, 2);
        this.setErrorMessage(null);
        this.setMessage(UIText.FetchSourcePage_PageMessage);
        if (this.sourceText.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        boolean found = false;
        for (Ref ref : this.getRemoteRefs()) {
            if (!ref.getName().equals(this.sourceText.getText())) continue;
            found = true;
        }
        if (!found) {
            this.setMessage(NLS.bind((String)UIText.FetchSourcePage_RefNotFoundMessage, (Object)this.sourceText.getText()), 2);
        }
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.sourceText.setFocus();
        }
    }

    public String getSource() {
        return this.sourceText.getText();
    }

    private List<Ref> getRemoteRefs() {
        if (this.remoteRefs == null) {
            ArrayList<Ref> proposals = new ArrayList<Ref>();
            URIish uriToCheck = (URIish)this.config.getURIs().get(0);
            final ListRemoteOperation lop = new ListRemoteOperation(this.repository, uriToCheck, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(UIText.FetchSourcePage_GettingRemoteRefsTaskname, -1);
                        lop.run(monitor);
                        monitor.done();
                    }
                });
                for (Ref ref : lop.getRemoteRefs()) {
                    if (!ref.getName().startsWith("refs/heads/") && !ref.getName().startsWith("refs/tags/")) continue;
                    proposals.add(ref);
                }
                Collections.sort(proposals, new Comparator<Ref>(){

                    @Override
                    public int compare(Ref o1, Ref o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.remoteRefs = proposals;
            }
            catch (IllegalStateException e) {
                this.setErrorMessage(e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(e.getMessage());
            }
            catch (InterruptedException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
        return this.remoteRefs;
    }
}

