/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.util.IntList;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellcheckableMessageArea
extends Composite {
    static final int MAX_LINE_WIDTH = 72;
    private static final Cursor SYS_LINK_CURSOR = PlatformUI.getWorkbench().getDisplay().getSystemCursor(21);
    private final Cursor sys_normalCursor;
    private final SourceViewer sourceViewer;
    private TextSourceViewerConfiguration configuration;
    private BidiSegmentListener hardWrapSegmentListener;
    private int brokenBidiPlatformTextWidth;
    private ActionHandler quickFixActionHandler;
    private ActionHandler contentAssistActionHandler;

    public SpellcheckableMessageArea(Composite parent, String initialText) {
        this(parent, initialText, 2048);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, int styles) {
        this(parent, initialText, false, styles);
    }

    public SpellcheckableMessageArea(Composite parent, String initialText, boolean readOnly, int styles) {
        super(parent, styles);
        this.setLayout((Layout)new FillLayout());
        AnnotationModel annotationModel = new AnnotationModel();
        this.sourceViewer = new SourceViewer((Composite)this, null, null, true, 578);
        this.getTextWidget().setAlwaysShowScrollBars(false);
        this.getTextWidget().setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageEditorFont"));
        this.sys_normalCursor = this.sourceViewer.getTextWidget().getCursor();
        int endSpacing = 2;
        int textWidth = this.getCharWidth() * 72 + endSpacing;
        int textHeight = this.getLineHeight() * 7;
        Point size = this.getTextWidget().computeSize(textWidth, textHeight);
        this.getTextWidget().setSize(size);
        this.computeBrokenBidiPlatformTextWidth(size.x);
        this.getTextWidget().setEditable(!readOnly);
        this.createMarginPainter();
        this.configureHardWrap();
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("commit_dialog_hard_wrap_message".equals(event.getProperty())) {
                    SpellcheckableMessageArea.this.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            SpellcheckableMessageArea.this.configureHardWrap();
                            if (SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth != -1) {
                                SpellcheckableMessageArea.this.layout();
                            }
                        }
                    });
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
        final SourceViewerDecorationSupport support = this.configureAnnotationPreferences();
        if (this.isEditable((ISourceViewer)this.sourceViewer)) {
            this.quickFixActionHandler = this.createQuickFixActionHandler((ITextOperationTarget)this.sourceViewer);
        }
        Document document = new Document(initialText);
        this.configuration = new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()){

            public int getHyperlinkStateMask(ISourceViewer targetViewer) {
                return 0;
            }

            protected Map getHyperlinkDetectorTargets(ISourceViewer targetViewer) {
                return SpellcheckableMessageArea.this.getHyperlinkTargets();
            }

            public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer targetViewer) {
                return new MultipleHyperlinkPresenter(PlatformUI.getWorkbench().getDisplay().getSystemColor(9).getRGB()){

                    public void hideHyperlinks() {
                    }
                };
            }

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer targetViewer) {
                return this.getRegisteredHyperlinkDetectors((ISourceViewer)SpellcheckableMessageArea.this.sourceViewer);
            }

            public IReconciler getReconciler(ISourceViewer viewer) {
                if (!SpellcheckableMessageArea.this.isEditable(viewer)) {
                    return null;
                }
                return super.getReconciler((ISourceViewer)SpellcheckableMessageArea.this.sourceViewer);
            }

            public IContentAssistant getContentAssistant(ISourceViewer viewer) {
                if (!viewer.isEditable()) {
                    return null;
                }
                IContentAssistant assistant = SpellcheckableMessageArea.this.createContentAssistant(viewer);
                if (assistant != null) {
                    SpellcheckableMessageArea.this.contentAssistActionHandler = SpellcheckableMessageArea.this.createContentAssistActionHandler((ITextOperationTarget)SpellcheckableMessageArea.this.sourceViewer);
                }
                return assistant;
            }
        };
        this.sourceViewer.configure((SourceViewerConfiguration)this.configuration);
        this.sourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        UIUtils.applyHyperlinkDetectorStyleRanges((ITextViewer)this.sourceViewer, this.configuration.getHyperlinkDetectors((ISourceViewer)this.sourceViewer));
        this.configureContextMenu();
        this.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                support.uninstall();
                Activator.getDefault().getPreferenceStore().removePropertyChangeListener(propertyChangeListener);
            }
        });
    }

    private void computeBrokenBidiPlatformTextWidth(int textWidth) {
        class BidiSegmentListenerTester
        implements BidiSegmentListener {
            boolean called;

            BidiSegmentListenerTester() {
            }

            public void lineGetSegments(BidiSegmentEvent event) {
                this.called = true;
            }
        }
        BidiSegmentListenerTester tester = new BidiSegmentListenerTester();
        StyledText textWidget = this.getTextWidget();
        textWidget.addBidiSegmentListener((BidiSegmentListener)tester);
        textWidget.setText(" ");
        textWidget.computeSize(-1, -1);
        textWidget.removeBidiSegmentListener((BidiSegmentListener)tester);
        this.brokenBidiPlatformTextWidth = tester.called ? -1 : textWidth;
    }

    private boolean isEditable(ISourceViewer viewer) {
        return viewer != null && viewer.getTextWidget().getEditable();
    }

    private void configureHardWrap() {
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            if (this.hardWrapSegmentListener == null) {
                final StyledText textWidget = this.getTextWidget();
                this.hardWrapSegmentListener = new BidiSegmentListener(){

                    public void lineGetSegments(BidiSegmentEvent e) {
                        int[] segments = SpellcheckableMessageArea.calculateWrapOffsets(e.lineText, 72);
                        if (segments != null) {
                            char[] segmentsChars = new char[segments.length];
                            Arrays.fill(segmentsChars, '\n');
                            e.segments = segments;
                            e.segmentsChars = segmentsChars;
                        }
                    }
                };
                textWidget.addBidiSegmentListener(this.hardWrapSegmentListener);
                textWidget.setText(textWidget.getText());
                if (this.brokenBidiPlatformTextWidth != -1) {
                    Layout restrictedWidthLayout = new Layout(){

                        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                            Point size = SpellcheckableMessageArea.this.getSize();
                            Rectangle trim = SpellcheckableMessageArea.this.computeTrim(0, 0, 0, 0);
                            size.x -= trim.width;
                            size.y -= trim.height;
                            if (size.x > SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth) {
                                size.x = SpellcheckableMessageArea.this.brokenBidiPlatformTextWidth;
                            }
                            return size;
                        }

                        protected void layout(Composite composite, boolean flushCache) {
                            Point size = this.computeSize(composite, -1, -1, flushCache);
                            textWidget.setBounds(0, 0, size.x, size.y);
                        }
                    };
                    this.setLayout(restrictedWidthLayout);
                }
            }
        } else if (this.hardWrapSegmentListener != null) {
            StyledText textWidget = this.getTextWidget();
            textWidget.removeBidiSegmentListener(this.hardWrapSegmentListener);
            textWidget.setText(textWidget.getText());
            this.hardWrapSegmentListener = null;
            if (this.brokenBidiPlatformTextWidth != -1) {
                this.setLayout((Layout)new FillLayout());
            }
        }
    }

    private void configureContextMenu() {
        TextViewerAction pasteAction;
        TextViewerAction redoAction;
        TextViewerAction undoAction;
        TextViewerAction cutAction;
        boolean editable = this.isEditable((ISourceViewer)this.sourceViewer);
        if (editable) {
            cutAction = new TextViewerAction((ITextViewer)this.sourceViewer, 3);
            cutAction.setText(UIText.SpellCheckingMessageArea_cut);
            cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
            undoAction = new TextViewerAction((ITextViewer)this.sourceViewer, 1);
            undoAction.setText(UIText.SpellcheckableMessageArea_undo);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            redoAction = new TextViewerAction((ITextViewer)this.sourceViewer, 2);
            redoAction.setText(UIText.SpellcheckableMessageArea_redo);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            pasteAction = new TextViewerAction((ITextViewer)this.sourceViewer, 5);
            pasteAction.setText(UIText.SpellCheckingMessageArea_paste);
            pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            cutAction = null;
            undoAction = null;
            redoAction = null;
            pasteAction = null;
        }
        final TextViewerAction copyAction = new TextViewerAction((ITextViewer)this.sourceViewer, 4);
        copyAction.setText(UIText.SpellCheckingMessageArea_copy);
        copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        final TextViewerAction selectAllAction = new TextViewerAction((ITextViewer)this.sourceViewer, 7);
        selectAllAction.setText(UIText.SpellCheckingMessageArea_selectAll);
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        final TextEditorPropertyAction showWhitespaceAction = new TextEditorPropertyAction(UIText.SpellcheckableMessageArea_showWhitespace, this.sourceViewer, "showWhitespaceCharacters"){
            private IPainter whitespaceCharPainter;

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals(this.getPreferenceKey()) || "showLeadingSpaces".equals(property) || "showEnclosedSpaces".equals(property) || "showTrailingSpaces".equals(property) || "showLeadingIdeographicSpaces".equals(property) || "showEnclosedIdeographicSpaces".equals(property) || "showTrailingIdeographicSpaces".equals(property) || "showLeadingTabs".equals(property) || "showEnclosedTabs".equals(property) || "showTrailingTabs".equals(property) || "showCarriageReturn".equals(property) || "showLineFeed".equals(property) || "whitespaceCharacterAlphaValue".equals(property)) {
                    this.synchronizeWithPreference();
                }
            }

            protected void toggleState(boolean checked) {
                if (checked) {
                    this.installPainter();
                } else {
                    this.uninstallPainter();
                }
            }

            private void installPainter() {
                Assert.isTrue((this.whitespaceCharPainter == null ? 1 : 0) != 0);
                ITextViewer v = this.getTextViewer();
                if (v instanceof ITextViewerExtension2) {
                    IPreferenceStore store = this.getStore();
                    this.whitespaceCharPainter = new WhitespaceCharacterPainter(v, store.getBoolean("showLeadingSpaces"), store.getBoolean("showEnclosedSpaces"), store.getBoolean("showTrailingSpaces"), store.getBoolean("showLeadingIdeographicSpaces"), store.getBoolean("showEnclosedIdeographicSpaces"), store.getBoolean("showTrailingIdeographicSpaces"), store.getBoolean("showLeadingTabs"), store.getBoolean("showEnclosedTabs"), store.getBoolean("showTrailingTabs"), store.getBoolean("showCarriageReturn"), store.getBoolean("showLineFeed"), store.getInt("whitespaceCharacterAlphaValue"));
                    ((ITextViewerExtension2)v).addPainter(this.whitespaceCharPainter);
                }
            }

            private void uninstallPainter() {
                if (this.whitespaceCharPainter == null) {
                    return;
                }
                ITextViewer v = this.getTextViewer();
                if (v instanceof ITextViewerExtension2) {
                    ((ITextViewerExtension2)v).removePainter(this.whitespaceCharPainter);
                }
                this.whitespaceCharPainter.deactivate(true);
                this.whitespaceCharPainter = null;
            }
        };
        MenuManager contextMenu = new MenuManager();
        if (cutAction != null) {
            contextMenu.add((IAction)cutAction);
        }
        contextMenu.add((IAction)copyAction);
        if (pasteAction != null) {
            contextMenu.add((IAction)pasteAction);
        }
        contextMenu.add((IAction)selectAllAction);
        if (undoAction != null) {
            contextMenu.add((IAction)undoAction);
        }
        if (redoAction != null) {
            contextMenu.add((IAction)redoAction);
        }
        contextMenu.add((IContributionItem)new Separator());
        contextMenu.add((IAction)showWhitespaceAction);
        contextMenu.add((IContributionItem)new Separator());
        if (editable) {
            final SubMenuManager quickFixMenu = new SubMenuManager((IMenuManager)contextMenu);
            quickFixMenu.setVisible(true);
            quickFixMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    quickFixMenu.removeAll();
                    SpellcheckableMessageArea.this.addProposals(quickFixMenu);
                }
            });
        }
        final StyledText textWidget = this.getTextWidget();
        textWidget.setMenu(contextMenu.createContextMenu((Control)textWidget));
        textWidget.addFocusListener(new FocusListener(){
            private IHandlerActivation cutHandlerActivation;
            private IHandlerActivation copyHandlerActivation;
            private IHandlerActivation pasteHandlerActivation;
            private IHandlerActivation selectAllHandlerActivation;
            private IHandlerActivation undoHandlerActivation;
            private IHandlerActivation redoHandlerActivation;
            private IHandlerActivation quickFixHandlerActivation;
            private IHandlerActivation contentAssistHandlerActivation;

            public void focusGained(FocusEvent e) {
                IHandlerService service = SpellcheckableMessageArea.this.getHandlerService();
                if (service == null) {
                    return;
                }
                if (cutAction != null) {
                    cutAction.update();
                    this.cutHandlerActivation = service.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new ActionHandler((IAction)cutAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                }
                copyAction.update();
                this.copyHandlerActivation = service.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new ActionHandler((IAction)copyAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                if (pasteAction != null) {
                    this.pasteHandlerActivation = service.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new ActionHandler((IAction)pasteAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                }
                this.selectAllHandlerActivation = service.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new ActionHandler((IAction)selectAllAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                if (undoAction != null) {
                    this.undoHandlerActivation = service.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new ActionHandler((IAction)undoAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                }
                if (redoAction != null) {
                    this.redoHandlerActivation = service.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new ActionHandler((IAction)redoAction), (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                }
                if (SpellcheckableMessageArea.this.quickFixActionHandler != null) {
                    this.quickFixHandlerActivation = SpellcheckableMessageArea.this.getHandlerService().activateHandler(SpellcheckableMessageArea.this.quickFixActionHandler.getAction().getActionDefinitionId(), (IHandler)SpellcheckableMessageArea.this.quickFixActionHandler, (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                }
                if (SpellcheckableMessageArea.this.contentAssistActionHandler != null) {
                    this.contentAssistHandlerActivation = SpellcheckableMessageArea.this.getHandlerService().activateHandler(SpellcheckableMessageArea.this.contentAssistActionHandler.getAction().getActionDefinitionId(), (IHandler)SpellcheckableMessageArea.this.contentAssistActionHandler, (Expression)new ActiveShellExpression(SpellcheckableMessageArea.this.getParent().getShell()));
                }
            }

            public void focusLost(FocusEvent e) {
                IHandlerService service = SpellcheckableMessageArea.this.getHandlerService();
                if (service == null) {
                    return;
                }
                if (this.cutHandlerActivation != null) {
                    service.deactivateHandler(this.cutHandlerActivation);
                }
                if (this.copyHandlerActivation != null) {
                    service.deactivateHandler(this.copyHandlerActivation);
                }
                if (this.pasteHandlerActivation != null) {
                    service.deactivateHandler(this.pasteHandlerActivation);
                }
                if (this.selectAllHandlerActivation != null) {
                    service.deactivateHandler(this.selectAllHandlerActivation);
                }
                if (this.undoHandlerActivation != null) {
                    service.deactivateHandler(this.undoHandlerActivation);
                }
                if (this.redoHandlerActivation != null) {
                    service.deactivateHandler(this.redoHandlerActivation);
                }
                if (this.quickFixHandlerActivation != null) {
                    service.deactivateHandler(this.quickFixHandlerActivation);
                }
                if (this.contentAssistHandlerActivation != null) {
                    service.deactivateHandler(this.contentAssistHandlerActivation);
                }
            }
        });
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (cutAction != null) {
                    cutAction.update();
                }
                copyAction.update();
            }
        });
        if (editable) {
            this.sourceViewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    textWidget.setStyleRanges(new StyleRange[0]);
                    UIUtils.applyHyperlinkDetectorStyleRanges((ITextViewer)SpellcheckableMessageArea.this.sourceViewer, SpellcheckableMessageArea.this.configuration.getHyperlinkDetectors((ISourceViewer)SpellcheckableMessageArea.this.sourceViewer));
                    if (undoAction != null) {
                        undoAction.update();
                    }
                    if (redoAction != null) {
                        redoAction.update();
                    }
                }
            });
        }
        textWidget.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                StyleRange styleRange = SpellcheckableMessageArea.this.getStyleRange(e.x, e.y);
                if (styleRange != null && styleRange.underline) {
                    textWidget.setCursor(SYS_LINK_CURSOR);
                } else {
                    textWidget.setCursor(SpellcheckableMessageArea.this.sys_normalCursor);
                }
            }
        });
        textWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                showWhitespaceAction.dispose();
            }
        });
    }

    private StyleRange getStyleRange(int x, int y) {
        int offset;
        StyledText t = this.sourceViewer.getTextWidget();
        try {
            offset = t.getOffsetAtLocation(new Point(x, y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (offset < t.getCharCount()) {
            return t.getStyleRangeAtOffset(offset);
        }
        return null;
    }

    private void addProposals(SubMenuManager quickFixMenu) {
        IAnnotationModel sourceModel = this.sourceViewer.getAnnotationModel();
        Iterator annotationIterator = sourceModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            ICompletionProposal[] proposals;
            Annotation annotation = (Annotation)annotationIterator.next();
            boolean isDeleted = annotation.isMarkedDeleted();
            boolean isIncluded = this.includes(sourceModel.getPosition(annotation), this.getTextWidget().getCaretOffset());
            boolean isFixable = this.sourceViewer.getQuickAssistAssistant().canFix(annotation);
            if (isDeleted || !isIncluded || !isFixable) continue;
            IQuickAssistProcessor processor = this.sourceViewer.getQuickAssistAssistant().getQuickAssistProcessor();
            IQuickAssistInvocationContext context = this.sourceViewer.getQuickAssistInvocationContext();
            ICompletionProposal[] iCompletionProposalArray = proposals = processor.computeQuickAssistProposals(context);
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                quickFixMenu.add(this.createQuickFixAction(proposal));
                ++n2;
            }
        }
    }

    private boolean includes(Position position, int caretOffset) {
        return position.includes(caretOffset) || position.offset + position.length == caretOffset;
    }

    private IAction createQuickFixAction(final ICompletionProposal proposal) {
        return new Action(proposal.getDisplayString()){

            public void run() {
                proposal.apply(SpellcheckableMessageArea.this.sourceViewer.getDocument());
            }

            public ImageDescriptor getImageDescriptor() {
                Image image = proposal.getImage();
                if (image != null) {
                    return ImageDescriptor.createFromImage((Image)image);
                }
                return null;
            }
        };
    }

    protected IHandlerService getHandlerService() {
        return CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), IHandlerService.class);
    }

    private SourceViewerDecorationSupport configureAnnotationPreferences() {
        ISharedTextColors textColors = EditorsUI.getSharedTextColors();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)annotationAccess, textColors);
        List annotationPreferences = new MarkerAnnotationPreferences().getAnnotationPreferences();
        Iterator e = annotationPreferences.iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        return support;
    }

    protected void createMarginPainter() {
        MarginPainter marginPainter = new MarginPainter((ITextViewer)this.sourceViewer);
        marginPainter.setMarginRulerColumn(72);
        marginPainter.setMarginRulerColor(Display.getDefault().getSystemColor(15));
        this.sourceViewer.addPainter((IPainter)marginPainter);
    }

    private int getCharWidth() {
        GC gc = new GC((Drawable)this.getTextWidget());
        int charWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return charWidth;
    }

    private int getLineHeight() {
        return this.getTextWidget().getLineHeight();
    }

    private static boolean shouldHardWrap() {
        return Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_hard_wrap_message");
    }

    public StyledText getTextWidget() {
        return this.sourceViewer.getTextWidget();
    }

    private ActionHandler createQuickFixActionHandler(final ITextOperationTarget textOperationTarget) {
        Action quickFixAction = new Action(){

            public void run() {
                textOperationTarget.doOperation(22);
            }
        };
        quickFixAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        return new ActionHandler((IAction)quickFixAction);
    }

    private ActionHandler createContentAssistActionHandler(final ITextOperationTarget textOperationTarget) {
        Action proposalAction = new Action(){

            public void run() {
                if (textOperationTarget.canDoOperation(13) && SpellcheckableMessageArea.this.getTextWidget().isFocusControl()) {
                    textOperationTarget.doOperation(13);
                }
            }
        };
        proposalAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        return new ActionHandler((IAction)proposalAction);
    }

    public String getCommitMessage() {
        String text = this.getText();
        text = Utils.normalizeLineEndings((String)text);
        if (SpellcheckableMessageArea.shouldHardWrap()) {
            text = SpellcheckableMessageArea.hardWrap(text);
        }
        return text;
    }

    public static String hardWrap(String text) {
        int[] wrapOffsets = SpellcheckableMessageArea.calculateWrapOffsets(text, 72);
        if (wrapOffsets != null) {
            StringBuilder builder = new StringBuilder(text.length() + wrapOffsets.length);
            int prev = 0;
            int[] nArray = wrapOffsets;
            int n = wrapOffsets.length;
            int n2 = 0;
            while (n2 < n) {
                int cur = nArray[n2];
                builder.append(text.substring(prev, cur));
                int j = cur;
                while (j > prev && builder.charAt(builder.length() - 1) == ' ') {
                    builder.deleteCharAt(builder.length() - 1);
                    --j;
                }
                builder.append('\n');
                prev = cur;
                ++n2;
            }
            builder.append(text.substring(prev));
            return builder.toString();
        }
        return text;
    }

    protected Map<String, IAdaptable> getHyperlinkTargets() {
        return Collections.singletonMap("org.eclipse.ui.DefaultTextEditor", this.getDefaultTarget());
    }

    protected IContentAssistant createContentAssistant(ISourceViewer viewer) {
        return null;
    }

    protected IAdaptable getDefaultTarget() {
        return null;
    }

    public String getText() {
        return this.getTextWidget().getText();
    }

    public IDocument getDocument() {
        return this.sourceViewer.getDocument();
    }

    public void setText(String text) {
        if (text != null) {
            this.getTextWidget().setText(text);
        }
    }

    public boolean setFocus() {
        return this.getTextWidget().setFocus();
    }

    public static int[] calculateWrapOffsets(String line, int maxLineLength) {
        if (line.length() == 0) {
            return null;
        }
        IntList wrapOffsets = new IntList();
        int wordStart = 0;
        int lineStart = 0;
        boolean lastWasSpace = true;
        boolean onlySpaces = true;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == ' ') {
                lastWasSpace = true;
            } else if (ch == '\n') {
                lineStart = i + 1;
                wordStart = i + 1;
                lastWasSpace = true;
                onlySpaces = true;
            } else {
                if (lastWasSpace) {
                    lastWasSpace = false;
                    if (!onlySpaces) {
                        wordStart = i;
                    }
                } else {
                    onlySpaces = false;
                }
                if (i >= lineStart + maxLineLength && wordStart != lineStart) {
                    wrapOffsets.add(wordStart);
                    lineStart = wordStart;
                    onlySpaces = true;
                }
            }
            ++i;
        }
        int size = wrapOffsets.size();
        if (size == 0) {
            return null;
        }
        int[] result = new int[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = wrapOffsets.get(i2);
            ++i2;
        }
        return result;
    }

    private static abstract class TextEditorPropertyAction
    extends Action
    implements IPropertyChangeListener {
        private SourceViewer viewer;
        private String preferenceKey;
        private IPreferenceStore store;

        public TextEditorPropertyAction(String label, SourceViewer viewer, String preferenceKey) {
            super(label, 2);
            this.viewer = viewer;
            this.preferenceKey = preferenceKey;
            this.store = EditorsUI.getPreferenceStore();
            if (this.store != null) {
                this.store.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(this.getPreferenceKey())) {
                this.synchronizeWithPreference();
            }
        }

        protected void synchronizeWithPreference() {
            boolean checked = false;
            if (this.store != null) {
                checked = this.store.getBoolean(this.getPreferenceKey());
            }
            if (checked != this.isChecked()) {
                this.setChecked(checked);
                this.toggleState(checked);
            } else if (checked) {
                this.toggleState(false);
                this.toggleState(true);
            }
        }

        protected String getPreferenceKey() {
            return this.preferenceKey;
        }

        public void run() {
            this.toggleState(this.isChecked());
            if (this.store != null) {
                this.store.setValue(this.getPreferenceKey(), this.isChecked());
            }
        }

        public void dispose() {
            if (this.store != null) {
                this.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }

        protected abstract void toggleState(boolean var1);

        protected ITextViewer getTextViewer() {
            return this.viewer;
        }

        protected IPreferenceStore getStore() {
            return this.store;
        }
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            if (this.fOperationCode == 2) {
                return;
            }
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

