/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedCheckboxTreeViewer
extends ContainerCheckedTreeViewer {
    private final Set<Object> checkState = new HashSet<Object>();

    protected CachedCheckboxTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CachedCheckboxTreeViewer.this.updateCheckState(event.getElement(), event.getChecked());
            }
        });
        this.setUseHashlookup(true);
    }

    protected void updateCheckState(Object element, boolean state) {
        if (state) {
            ITreeContentProvider contentProvider = null;
            if (this.getContentProvider() instanceof ITreeContentProvider) {
                contentProvider = (ITreeContentProvider)this.getContentProvider();
            }
            if (contentProvider != null) {
                Object[] children = contentProvider.getChildren(element);
                if (children != null && children.length > 0) {
                    int i = 0;
                    while (i < children.length) {
                        this.updateCheckState(children[i], state);
                        ++i;
                    }
                } else {
                    this.checkState.add(element);
                }
            } else {
                this.checkState.add(element);
            }
        } else if (this.checkState != null) {
            Object[] children;
            ITreeContentProvider contentProvider = null;
            if (this.getContentProvider() instanceof ITreeContentProvider) {
                contentProvider = (ITreeContentProvider)this.getContentProvider();
            }
            if (contentProvider != null && (children = contentProvider.getChildren(element)) != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    this.updateCheckState(children[i], state);
                    ++i;
                }
            }
            this.checkState.remove(element);
        }
    }

    public void restoreLeafCheckState() {
        if (this.checkState == null) {
            return;
        }
        this.getTree().setRedraw(false);
        super.setCheckedElements(new Object[0]);
        this.setGrayedElements(new Object[0]);
        Iterator<Object> iter = this.checkState.iterator();
        Object element = null;
        if (iter.hasNext()) {
            this.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            super.setChecked(element, true);
        }
        this.getTree().setRedraw(true);
    }

    public Object[] getCheckedLeafElements() {
        if (this.checkState == null) {
            return new Object[0];
        }
        return this.checkState.toArray(new Object[this.checkState.size()]);
    }

    public int getCheckedLeafCount() {
        if (this.checkState == null) {
            return 0;
        }
        return this.checkState.size();
    }

    public boolean setChecked(Object element, boolean state) {
        this.updateCheckState(element, state);
        return super.setChecked(element, state);
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        this.checkState.clear();
        ITreeContentProvider contentProvider = null;
        if (this.getContentProvider() instanceof ITreeContentProvider) {
            contentProvider = (ITreeContentProvider)this.getContentProvider();
        }
        int i = 0;
        while (i < elements.length) {
            Object[] children;
            Object[] objectArray = children = contentProvider != null ? contentProvider.getChildren(elements[i]) : null;
            if (!(this.getGrayed(elements[i]) || children != null && children.length != 0 || this.checkState.contains(elements[i]))) {
                this.checkState.add(elements[i]);
            }
            ++i;
        }
    }

    public void setAllChecked(boolean state) {
        block8: {
            Object[] visible;
            block7: {
                TreeItem[] treeItemArray = super.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(state);
                    ++n2;
                }
                if (!state) break block7;
                visible = this.getFilteredChildren(this.getRoot());
                ITreeContentProvider contentProvider = null;
                if (this.getContentProvider() instanceof ITreeContentProvider) {
                    contentProvider = (ITreeContentProvider)this.getContentProvider();
                }
                if (contentProvider == null) {
                    int i = 0;
                    while (i < visible.length) {
                        this.checkState.add(visible[i]);
                        ++i;
                    }
                } else {
                    HashSet<Object> toCheck = new HashSet<Object>();
                    int i = 0;
                    while (i < visible.length) {
                        this.addFilteredChildren(visible[i], contentProvider, toCheck);
                        ++i;
                    }
                    this.checkState.addAll(toCheck);
                }
                break block8;
            }
            if (this.checkState == null) break block8;
            visible = this.filter(this.checkState.toArray());
            int i = 0;
            while (i < visible.length) {
                this.checkState.remove(visible[i]);
                ++i;
            }
        }
    }

    private void addFilteredChildren(Object element, ITreeContentProvider contentProvider, Collection<Object> result) {
        if (!contentProvider.hasChildren(element)) {
            result.add(element);
        } else {
            Object[] visibleChildren = this.getFilteredChildren(element);
            int i = 0;
            while (i < visibleChildren.length) {
                this.addFilteredChildren(visibleChildren[i], contentProvider, result);
                ++i;
            }
        }
    }

    public void remove(Object[] elementsOrTreePaths) {
        int i = 0;
        while (i < elementsOrTreePaths.length) {
            this.updateCheckState(elementsOrTreePaths[i], false);
            ++i;
        }
        super.remove(elementsOrTreePaths);
    }

    public void remove(Object elementsOrTreePaths) {
        this.updateCheckState(elementsOrTreePaths, false);
        super.remove(elementsOrTreePaths);
    }
}

