/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.ddlgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.eclipse.persistence.dynamic.DynamicClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    protected EntityManagerFactory entityManagerFactory;
    private Map<String, Object> eclipseLinkProperties;
    private String eclipseLinkPropertiesPath;
    private boolean isDebugMode;

    public static void main(String[] args) {
        new Main().execute(args);
    }

    private Main() {
    }

    protected void execute(String[] args) {
        this.initializeWith(args);
        this.entityManagerFactory = this.buildEntityManagerFactory(this.getPUName(args), this.eclipseLinkProperties);
        this.generate();
        this.closeEntityManagerFactory();
        this.dispose();
    }

    private void generate() {
        this.entityManagerFactory.createEntityManager().close();
    }

    private EntityManagerFactory buildEntityManagerFactory(String puName, Map<String, Object> properties) {
        return Persistence.createEntityManagerFactory((String)puName, properties);
    }

    private void closeEntityManagerFactory() {
        this.entityManagerFactory.close();
    }

    private void initializeWith(String[] args) {
        this.eclipseLinkPropertiesPath = this.getEclipseLinkPropertiesPath(args);
        this.eclipseLinkProperties = this.getProperties(this.eclipseLinkPropertiesPath);
        this.setDynamicClassLoaderProperty(args);
        this.isDebugMode = this.getDebugMode(args);
    }

    private void setDynamicClassLoaderProperty(String[] args) {
        if (this.getEclipseLinkDynamic(args)) {
            this.eclipseLinkProperties.put("eclipselink.classloader", this.buildDynamicClassLoader());
        }
    }

    private ClassLoader buildDynamicClassLoader() {
        return new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void dispose() {
        if (!this.isDebugMode) {
            new File(this.eclipseLinkPropertiesPath).delete();
        }
    }

    private Map<String, Object> getProperties(String eclipseLinkPropertiesPath) {
        Set<Map.Entry<Object, Object>> propertiesSet = null;
        try {
            propertiesSet = this.loadEclipseLinkProperties(eclipseLinkPropertiesPath);
        }
        catch (IOException e) {
            this.logMessage(Level.SEVERE, "Missing: " + eclipseLinkPropertiesPath);
            e.printStackTrace();
            this.generationFailed();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> property : propertiesSet) {
            properties.put((String)property.getKey(), property.getValue());
        }
        return properties;
    }

    private Set<Map.Entry<Object, Object>> loadEclipseLinkProperties(String eclipseLinkPropertiesPath) throws IOException {
        FileInputStream stream = new FileInputStream(eclipseLinkPropertiesPath);
        Properties properties = new Properties();
        properties.load(stream);
        return properties.entrySet();
    }

    private void generationFailed() {
        System.exit(1);
    }

    private String getPUName(String[] args) {
        return this.getArgumentValue("-pu", args);
    }

    private String getEclipseLinkPropertiesPath(String[] args) {
        return this.getArgumentValue("-p", args);
    }

    private boolean getDebugMode(String[] args) {
        return this.argumentExists("-debug", args);
    }

    private boolean getEclipseLinkDynamic(String[] args) {
        return this.argumentExists("-dynamic", args);
    }

    private String getArgumentValue(String argument, String[] args) {
        int i = 0;
        while (i < args.length) {
            int j;
            String arg = args[i];
            if (arg.toLowerCase().equals(argument) && (j = i + 1) < args.length) {
                return args[j];
            }
            ++i;
        }
        return null;
    }

    private boolean argumentExists(String argument, String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.toLowerCase().equals(argument)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void logMessage(Level level, String message) {
        if (level == Level.SEVERE) {
            System.err.println(String.valueOf('\n') + message);
        } else {
            System.out.println(String.valueOf('\n') + message);
        }
    }
}

