/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cobol.debug.internal.core.model.COBOLVariableManager;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class COBOLWatchViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache = new HashMap(10);

    public Object[] getChildren(Object object) {
        if (object != null) {
            Object[] objectArray = null;
            try {
                if (object instanceof COBOLVariableManager) {
                    objectArray = ((COBOLVariableManager)object).getVariables();
                } else if (object instanceof IVariable && object != null && ((IVariable)object).getValue() != null) {
                    objectArray = ((IVariable)object).getValue().getVariables();
                }
                if (objectArray != null) {
                    this.cache(object, objectArray);
                    return objectArray;
                }
            }
            catch (DebugException debugException) {
                COBOLDebugUIPlugin.logError(debugException);
            }
        }
        return new Object[0];
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    protected void cache(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.fParentCache.put(objectArray[n], object);
            ++n;
        }
    }

    public Object getParent(Object object) {
        return this.fParentCache.get(object);
    }

    public void dispose() {
        this.fParentCache = null;
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    protected void removeCache(Object[] objectArray) {
        if (this.fParentCache == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.fParentCache.remove(objectArray[n]);
            ++n;
        }
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.clearCache();
    }

    protected List getCachedDecendants(Object object) {
        Iterator iterator = this.fParentCache.keySet().iterator();
        ArrayList arrayList = new ArrayList(10);
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this.isCachedDecendant(k, object)) continue;
            arrayList.add(k);
        }
        return arrayList;
    }

    protected boolean isCachedDecendant(Object object, Object object2) {
        Object object3 = this.getParent(object);
        while (object3 != null) {
            if (object3.equals(object2)) {
                return true;
            }
            object3 = this.getParent(object3);
        }
        return false;
    }
}

