/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.views;

import com.unisys.os2200.i18nSupport.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.actions.AddVariableFromWatchAction;
import org.eclipse.cobol.debug.ui.actions.COBOLDebugTargetStatus;
import org.eclipse.cobol.debug.ui.actions.RemoveAllVariablesAction;
import org.eclipse.cobol.debug.ui.views.COBOLWatchViewContentProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.actions.variables.ShowTypesAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class COBOLWatchView
extends VariablesView {
    private IStructuredSelection fSelection;
    private Action fAddVariableFromWatchAction = null;
    private Action fRemoveAllVariablesAction = null;
    protected CollapseAllAction collapseAllAction;

    public void collapseAll() {
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        Object object = treeViewer.getInput();
        if (object != null) {
            treeViewer.collapseToLevel(object, -1);
        }
    }

    protected IContentProvider createContentProvider() {
        return new COBOLWatchViewContentProvider();
    }

    public void setInitialContent() {
        try {
            this.getViewer().setInput((Object)COBOLDebugPlugin.getCOBOLVariableManager());
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    protected void createActions() {
        try {
            super.createActions();
            this.fAddVariableFromWatchAction = new AddVariableFromWatchAction((IViewPart)this);
            this.setAction("AddVariableToWatch", (IAction)this.fAddVariableFromWatchAction);
            this.getAction("ChangeVariableValue").setText(Messages.getString((String)"ChangeValueAction.label"));
            this.fRemoveAllVariablesAction = new RemoveAllVariablesAction();
            this.setAction("RemoveAllVariable", (IAction)this.fRemoveAllVariablesAction);
            this.collapseAllAction = new CollapseAllAction(ResourceNavigatorMessages.CollapseAllAction_title);
            this.collapseAllAction.setToolTipText(ResourceNavigatorMessages.CollapseAllAction_toolTip);
            this.collapseAllAction.setImageDescriptor(this.getPlatformImageDescriptor("elcl16/collapseall.gif"));
            ShowTypesAction showTypesAction = new ShowTypesAction((IDebugView)this);
            showTypesAction.setText(Messages.getString((String)"ShowDataTypeAction.label"));
            showTypesAction.setChecked(false);
            this.setAction("ShowTypeNames", (IAction)showTypesAction);
            this.getAction("AddVariableToWatch").setEnabled(false);
            this.getAction("RemoveAllVariable").setEnabled(false);
            this.getViewSite().getActionBars().updateActionBars();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    protected ImageDescriptor getPlatformImageDescriptor(String string) {
        String string2 = "icons/full/";
        try {
            AbstractUIPlugin abstractUIPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL uRL = abstractUIPlugin.getDescriptor().getInstallURL();
            URL uRL2 = new URL(uRL, String.valueOf(string2) + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator(((Object)((Object)this)).getClass().getName()));
        iToolBarManager.add((IContributionItem)new Separator("renderGroup"));
        try {
            iToolBarManager.add(this.getAction("ShowTypeNames"));
            iToolBarManager.add(this.getAction("AddVariableToWatch"));
            iToolBarManager.add((IContributionItem)new Separator("REMOVE_OPTION"));
            iToolBarManager.add(this.getAction("RemoveAllVariable"));
            iToolBarManager.add((IAction)this.collapseAllAction);
            this.getViewSite().getActionBars().updateActionBars();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
        boolean bl = this.isProgramSuspended();
        iMenuManager.add(this.getEnableStatus(this.getAction("AddVariableToWatch"), bl));
        iMenuManager.add(this.getEnableStatus(this.getAction("ChangeVariableValue"), bl && this.supportsValueModification() && !this.isSuspendSelected()));
        iMenuManager.add((IContributionItem)new ContributionItem("WATCHVIEW_OPTIONS"){

            public boolean isSeparator() {
                return false;
            }
        });
        iMenuManager.add((IContributionItem)new Separator("REMOVE_OPTION"));
        iMenuManager.add(this.getEnableStatus(this.getAction("RemoveAllVariable"), bl));
        iMenuManager.add((IContributionItem)new Separator("emptyRenderGroup"));
        iMenuManager.add((IContributionItem)new Separator("renderGroup"));
        iMenuManager.add((IContributionItem)new Separator("TOGGLE_VIEW"));
        iMenuManager.add(this.getAction("ShowTypeNames"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected void setViewerInput(IStructuredSelection iStructuredSelection) {
        try {
            this.getViewer().setInput((Object)COBOLDebugPlugin.getCOBOLVariableManager());
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    public void setFocus() {
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage("");
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (this.getViewer() instanceof StructuredViewer && ((StructuredViewer)this.getViewer()).getContentProvider() == null) {
            return;
        }
        try {
            this.getViewer().setInput((Object)COBOLDebugPlugin.getCOBOLVariableManager());
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        this.updateEnableStatus((IContributionManager)this.getViewSite().getActionBars().getToolBarManager());
        this.updateEnableStatus((IContributionManager)this.getViewSite().getActionBars().getMenuManager());
    }

    public void refresh() {
        this.getViewer().refresh();
    }

    protected void populateDetailPaneFromSelection(IStructuredSelection iStructuredSelection) {
        this.setSelection(iStructuredSelection);
        super.refreshDetailPaneContents();
    }

    public void refreshDetailPane(IStructuredSelection iStructuredSelection) {
        this.populateDetailPaneFromSelection(iStructuredSelection);
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public void dispose() {
        if (this.fSelection != null) {
            this.fSelection = null;
        }
        if (this.fAddVariableFromWatchAction != null) {
            ((AddVariableFromWatchAction)this.fAddVariableFromWatchAction).cleanup();
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)((AddVariableFromWatchAction)this.fAddVariableFromWatchAction));
            this.fAddVariableFromWatchAction = null;
        }
        if (this.fRemoveAllVariablesAction != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)((RemoveAllVariablesAction)this.fRemoveAllVariablesAction));
            this.fRemoveAllVariablesAction = null;
        }
        super.dispose();
    }

    private IAction getEnableStatus(IAction iAction, boolean bl) {
        iAction.setEnabled(bl);
        return iAction;
    }

    private boolean isProgramSuspended() {
        try {
            IDebugTarget iDebugTarget = COBOLDebugTargetStatus.getContext();
            return iDebugTarget != null && !iDebugTarget.isTerminated() && iDebugTarget.isSuspended();
        }
        catch (DebugException debugException) {
            COBOLDebugUIPlugin.logError(debugException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return false;
        }
    }

    private void updateEnableStatus(IContributionManager iContributionManager) {
        boolean bl = this.isProgramSuspended();
        IContributionItem[] iContributionItemArray = iContributionManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            ActionContributionItem actionContributionItem;
            IAction iAction;
            IContributionItem iContributionItem = iContributionItemArray[n];
            if (iContributionItem instanceof ActionContributionItem && ((iAction = (actionContributionItem = (ActionContributionItem)iContributionItem).getAction()) instanceof AddVariableFromWatchAction || iAction instanceof ChangeVariableValueAction || iAction instanceof RemoveAllVariablesAction)) {
                iAction.setEnabled(bl);
            }
            ++n;
        }
    }

    private boolean supportsValueModification() {
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        if (iStructuredSelection != null && (object = iStructuredSelection.getFirstElement()) instanceof IVariable) {
            return ((IVariable)object).supportsValueModification();
        }
        return false;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IAction iAction = this.getAction("Double_Click_ActionId");
        if (iAction instanceof ChangeVariableValueAction && (!this.isProgramSuspended() || this.isSuspendSelected())) {
            return;
        }
        super.doubleClick(doubleClickEvent);
    }

    public boolean isSuspendSelected() {
        return COBOLDebugUtil.isSuspendSelected();
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction(String string) {
            super(string);
            this.setEnabled(true);
        }

        public void run() {
            COBOLWatchView.this.collapseAll();
        }
    }
}

