/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.views;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.views.COBOLWatchView;
import org.eclipse.cobol.ui.ICOBOLHelpContextId;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class COBOLDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String HEXADECIMAL_PREFERENCE = "org.eclipse.cobol.debug.ui.hexadecimal";
    public static final String ASCII_PREFERENCE = "org.eclipse.cobol.debug.ui.ascii";
    public static final boolean DEFAULT_HEXADECIMAL = false;
    public static final boolean DEFAULT_ASCII = false;
    private BooleanFieldEditor fHexadecimal;
    private BooleanFieldEditor fAscii;
    private PropertyChangeListener fPropertyChangeListener;

    public COBOLDebugPreferencePage() {
        super(1);
        try {
            this.setPreferenceStore(COBOLDebugUIPlugin.getDefault().getPreferenceStore());
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IPreferenceStore iPreferenceStore = null;
        try {
            iPreferenceStore = COBOLDebugUIPlugin.getDefault().getPreferenceStore();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return iPreferenceStore;
    }

    public void createControl(Composite composite) {
        try {
            super.createControl(composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ICOBOLHelpContextId.COBOL_DEBUG_PREF_PAGE_CONTEXT_ID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            COBOLDebugUIPlugin.logError(illegalArgumentException);
        }
    }

    protected void createFieldEditors() {
        Label label = new Label(this.getFieldEditorParent(), 0);
        label.setFont(this.getFieldEditorParent().getFont());
        label.setText(Messages.getString((String)"WatchViewDisplayOptions.label"));
        this.fHexadecimal = new BooleanFieldEditor(HEXADECIMAL_PREFERENCE, Messages.getString((String)"Hexadecimal"), 0, this.getFieldEditorParent());
        this.fAscii = new BooleanFieldEditor(ASCII_PREFERENCE, Messages.getString((String)"Ascii"), 0, this.getFieldEditorParent());
        this.fHexadecimal.setPreferenceStore(this.getPreferenceStore());
        this.fAscii.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)this.fHexadecimal);
        this.addField((FieldEditor)this.fAscii);
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(HEXADECIMAL_PREFERENCE, false);
        iPreferenceStore.setDefault(ASCII_PREFERENCE, false);
    }

    public void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        COBOLDebugUIPlugin.getDefault().savePluginPreferences();
        return bl;
    }

    public void dispose() {
        try {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
            super.dispose();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new PropertyChangeListener();
        }
        return this.fPropertyChangeListener;
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private boolean fHasStateChanged = false;

        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals(COBOLDebugPreferencePage.HEXADECIMAL_PREFERENCE)) {
                this.fHasStateChanged = true;
            } else if (propertyChangeEvent.getProperty().equals(COBOLDebugPreferencePage.ASCII_PREFERENCE)) {
                this.fHasStateChanged = true;
            }
            BusyIndicator.showWhile((Display)COBOLDebugPreferencePage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow[] iWorkbenchWindowArray = COBOLDebugUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                    IWorkbenchPage iWorkbenchPage = null;
                    int n = 0;
                    while (n < iWorkbenchWindowArray.length) {
                        iWorkbenchPage = iWorkbenchWindowArray[n].getActivePage();
                        PropertyChangeListener.this.refreshViews(iWorkbenchPage, "org.eclipse.cobol.debug.ui.COBOLWatchView");
                        ++n;
                    }
                }
            });
        }

        private void refreshViews(IWorkbenchPage iWorkbenchPage, String string) {
            Viewer viewer;
            IDebugView iDebugView;
            IViewPart iViewPart = iWorkbenchPage.findView(string);
            if (iViewPart != null && (iDebugView = (IDebugView)iViewPart.getAdapter(IDebugView.class)) != null && (viewer = iDebugView.getViewer()) instanceof StructuredViewer) {
                ((StructuredViewer)viewer).refresh();
                ((COBOLWatchView)iDebugView).setInitialContent();
            }
        }

        public boolean hasStateChanged() {
            return this.fHasStateChanged;
        }
    }
}

