/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher.internal.core;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.ui.common.StatusDialog;
import org.eclipse.cobol.core.ui.common.StatusInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class COBOLTargetSelectionDialog
extends StatusDialog {
    private Text fInvocationTargetText = null;
    private String fInvocationTarget = null;
    private Shell fShell = null;
    private Button fBrowseButton = null;
    private static final int TEXT_WIDTH = 200;
    private StatusInfo fStatusInfo = null;
    private IProject fProject = null;

    public COBOLTargetSelectionDialog(Shell shell, IProject iProject) {
        super(shell);
        this.fShell = shell;
        this.fProject = iProject;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = null;
        this.setTitle(Messages.getString((String)"COBOLTargetSelectionDialog.title"));
        composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString((String)"COBOLTargetSelectionDialog.selection.message"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.createSpacer(composite2);
        Label label2 = new Label(composite2, 0);
        label2.setText(Messages.getString((String)"COBOLTargetSelectionDialog.targettext.label"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.fInvocationTargetText = new Text(composite2, 2048);
        this.fInvocationTargetText.setText("");
        gridData = new GridData(768);
        gridData.widthHint = 200;
        gridData.horizontalSpan = 1;
        this.fInvocationTargetText.setLayoutData((Object)gridData);
        this.fBrowseButton = new Button(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fBrowseButton.setLayoutData((Object)gridData);
        this.fBrowseButton.setText(Messages.getString((String)"COBOLTargetSelectionDialog.button.label"));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLTargetSelectionDialog.this.handleBrowseOperation();
            }
        });
        this.fInvocationTargetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                COBOLTargetSelectionDialog.this.updateOK();
            }
        });
        this.fStatusInfo = new StatusInfo();
        this.updateOK();
        return composite;
    }

    private void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void handleBrowseOperation() {
        String string;
        FileDialog fileDialog = new FileDialog(this.fShell);
        fileDialog.setText(Messages.getString((String)"SelectFileTitle.label"));
        if (Platform.getOS().equalsIgnoreCase("win32")) {
            fileDialog.setFilterExtensions(new String[]{"*.exe"});
        } else {
            fileDialog.setFilterExtensions(new String[]{"*"});
        }
        if (this.fProject != null && this.fProject.isAccessible()) {
            fileDialog.setFilterPath(this.fProject.getLocation().toOSString());
        }
        if ((string = fileDialog.open()) != null) {
            this.fInvocationTargetText.setText(string);
        }
    }

    private void updateOK() {
        boolean bl;
        boolean bl2 = bl = this.fInvocationTargetText.getText().trim().length() != 0;
        if (bl) {
            this.fStatusInfo.setOK();
        } else {
            this.fStatusInfo.setError(Messages.getString((String)"COBOLTargetSelectionDialog.empty.message"));
        }
        this.updateStatus((IStatus)this.fStatusInfo);
    }

    protected void okPressed() {
        this.fInvocationTarget = this.fInvocationTargetText.getText().trim();
        super.okPressed();
    }

    public String getInvocationTarget() {
        return this.fInvocationTarget;
    }
}

