/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher.internal.core;

import java.io.IOException;
import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLLaunchStarter;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.core.ICOBOLDebugConstants;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;

public class COBOLRunStarter
implements ICOBOLLaunchStarter {
    private IProject fProject = null;
    private IProcess fProcess = null;
    private ILaunch fLaunch = null;

    public COBOLRunStarter(ILaunch iLaunch, IProject iProject) throws COBOLDebugException {
        this.fProject = iProject;
        this.fLaunch = iLaunch;
        this.doLaunch(iLaunch);
    }

    public void doLaunch(ILaunch iLaunch) throws COBOLDebugException {
        ICOBOLDebugModel iCOBOLDebugModel = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(this.fLaunch);
        String[] stringArray = COBOLDebugUtil.getProgramArgumentsAsArray((String)iCOBOLDebugModel.getRawProgramArguments());
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = iCOBOLDebugModel.getTargetFileName();
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        Process process = this.executeProcess(iLaunch, stringArray2);
        this.fProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)COBOLDebugUtil.renderProcessLabel((String)iCOBOLDebugModel.getTargetFileName()));
        String string = "";
        try {
            ILaunchConfiguration iLaunchConfiguration = ((Launch)iLaunch).getLaunchConfiguration();
            string = String.valueOf(iLaunchConfiguration.getAttribute("ExecutableName", "")) + " " + iLaunchConfiguration.getAttribute("CommandLineParameter", "");
        }
        catch (CoreException coreException) {
            COBOLDebugPlugin.logError((Exception)((Object)coreException));
        }
        this.fProcess.setAttribute(ICOBOLDebugConstants.ATTR_JDT_TARGET_PROPERTIES, string);
        iCOBOLDebugModel.setCOBOLProcess(this.fProcess);
    }

    protected Process executeProcess(ILaunch iLaunch, String[] stringArray) throws COBOLDebugException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray, null, COBOLDebugUtil.getWorkingDirectory((ILaunchConfiguration)iLaunch.getLaunchConfiguration()));
        }
        catch (IOException iOException) {
            throw COBOLDebugException.createCOBOLDebugException((Exception)iOException, (String)COBOLDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier());
        }
        return process;
    }
}

