/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher.internal.core;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLLaunchStarter;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class COBOLLauncherFactory {
    public static ICOBOLLaunchStarter create(ILaunch iLaunch, IProject iProject, IProgressMonitor iProgressMonitor) throws COBOLDebugException {
        ICOBOLDebugModel iCOBOLDebugModel = COBOLLauncherFactory.createContributorDebugModel(iLaunch, iProject, iProgressMonitor);
        ICOBOLLaunchStarter iCOBOLLaunchStarter = null;
        if (iCOBOLDebugModel == null) {
            throw COBOLDebugException.createCOBOLDebugException((Exception)new NullPointerException(Messages.getString((String)"Vendor.model.notfound.error")), (String)COBOLDebugUIPlugin.getPluginId());
        }
        if (iLaunch.getLaunchMode().equals("run")) {
            iCOBOLLaunchStarter = iCOBOLDebugModel.getCOBOLRunStarter(iLaunch, iProject);
        } else if (iLaunch.getLaunchMode().equals("debug")) {
            iCOBOLLaunchStarter = iCOBOLDebugModel.getCOBOLDebugStarter(iLaunch, iProject);
        }
        if (iCOBOLLaunchStarter == null) {
            throw COBOLDebugException.createCOBOLDebugException((Exception)new NullPointerException(Messages.getString((String)"Vendor.starter.notfound.error")), (String)COBOLDebugUIPlugin.getPluginId());
        }
        return iCOBOLLaunchStarter;
    }

    private static ICOBOLDebugModel createContributorDebugModel(ILaunch iLaunch, IProject iProject, IProgressMonitor iProgressMonitor) throws COBOLDebugException {
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        if (iCOBOLContributor == null) {
            return null;
        }
        ICOBOLDebugModel iCOBOLDebugModel = iCOBOLContributor.getCOBOLDebugModel(iLaunch);
        if (iCOBOLDebugModel != null) {
            COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().register(iLaunch, iProject, iCOBOLDebugModel);
            iCOBOLDebugModel.setProject(iProject);
            iCOBOLDebugModel.setMonitor(iProgressMonitor);
            iCOBOLDebugModel.setTargetFileName(COBOLDebugUtil.getTargetName((ILaunchConfiguration)iLaunch.getLaunchConfiguration()));
            iCOBOLDebugModel.setRawProgramArguments(COBOLDebugUtil.getProgramArguments((ILaunchConfiguration)iLaunch.getLaunchConfiguration()));
            iCOBOLDebugModel.setProgramArguments(iCOBOLDebugModel.getRawProgramArguments());
        }
        return iCOBOLDebugModel;
    }
}

