/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher.internal.core;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.COBOLProjectConfigurationDialog;
import org.eclipse.cobol.debug.ui.launcher.internal.core.COBOLTargetSelectionDialog;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class COBOLLaunchShortcut
implements ILaunchShortcut {
    protected int fStatus = 0;

    public void launch(ISelection iSelection, String string) {
        if (iSelection == null) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"COBOLLaunchShortcut.Failed.label"), (String)Messages.getString((String)"COBOLLaunchShortcut.Failed.text"));
            return;
        }
        IProject iProject = null;
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object == null) {
            this.fStatus = 0;
            iProject = this.chooseProjectDialog();
            if (this.fStatus == 1) {
                return;
            }
        }
        if (object instanceof IResource) {
            iProject = (IResource)object;
        } else if (object instanceof TreeElement) {
            iProject = (IResource)((TreeElement)object).getAdapter(IProject.class);
        } else if (object instanceof ILaunch) {
            iProject = this.getProject(((ILaunch)object).getLaunchConfiguration());
        } else if (object instanceof IDebugElement) {
            iProject = this.getProject(((IDebugElement)object).getLaunch().getLaunchConfiguration());
        } else if (object instanceof IProcess) {
            iProject = this.getProject(((IProcess)object).getLaunch().getLaunchConfiguration());
        }
        if (iProject == null) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"COBOLLaunchShortcut.Failed.label"), (String)Messages.getString((String)"COBOLLaunchShortcut.Failed.text"));
            return;
        }
        String string2 = iProject.getProject().getName();
        this.launch(string2, string);
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            try {
                IFile iFile = (IFile)((IFileEditorInput)iEditorInput).getAdapter(IFile.class);
                String string2 = iFile.getProject().getName();
                this.launch(string2, string);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugUIPlugin.logError(nullPointerException);
            }
        }
    }

    protected ILaunchConfiguration chooseConfiguration(List list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(new Shell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(Messages.getString((String)"COBOLLaunchShortcut.Launch_Configuration_Selection"));
        if (string.equals("debug")) {
            elementListSelectionDialog.setMessage(Messages.getString((String)"COBOLLaunchShortcut.Choose_a_launch_configuration_to_debug"));
        } else {
            elementListSelectionDialog.setMessage(Messages.getString((String)"COBOLLaunchShortcut.Choose_a_launch_configuration_to_run"));
        }
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected void launch(String string, String string2) {
        ILaunchConfiguration iLaunchConfiguration = this.findConfiguration(string, string2);
        if (iLaunchConfiguration != null) {
            try {
                iLaunchConfiguration = this.updateInvocationTarget(iLaunchConfiguration);
                if (iLaunchConfiguration != null) {
                    iLaunchConfiguration.launch(string2, null);
                }
            }
            catch (COBOLDebugException cOBOLDebugException) {
                MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"COBOLLaunchShortcut.Failed.label"), (String)cOBOLDebugException.getLocalizedMessage());
            }
            catch (CoreException coreException) {
                COBOLDebugUIPlugin.logError(coreException);
            }
        }
    }

    protected ILaunchConfiguration updateInvocationTarget(ILaunchConfiguration iLaunchConfiguration) throws COBOLDebugException {
        String string;
        int n = -1;
        IProject iProject = null;
        try {
            string = iLaunchConfiguration.getAttribute("ProjectName", null);
            if (string == null) {
                return iLaunchConfiguration;
            }
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            if (iProject == null || !iProject.isAccessible()) {
                throw new COBOLDebugException((IStatus)new Status(4, COBOLDebugUIPlugin.getPluginId(), 0, Messages.getString((String)"COBOLLaunchShortcut.projectnotfound.launch.cancel"), null));
            }
            n = COBOLDebugUtil.getProjectType((IProject)iProject);
        }
        catch (CoreException coreException) {
            return iLaunchConfiguration;
        }
        if (n == 1) {
            string = null;
            try {
                string = iLaunchConfiguration.getAttribute("ExecutableName", null);
            }
            catch (CoreException coreException) {}
            if (string == null || string.length() == 0) {
                String string2 = null;
                COBOLTargetSelectionDialog cOBOLTargetSelectionDialog = new COBOLTargetSelectionDialog(COBOLDebugUIPlugin.getActiveWorkbenchShell(), iProject);
                if (cOBOLTargetSelectionDialog.open() != 0) {
                    return null;
                }
                string2 = cOBOLTargetSelectionDialog.getInvocationTarget();
                if (string2 != null) {
                    try {
                        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
                        iLaunchConfigurationWorkingCopy.setAttribute("ExecutableName", string2);
                        ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfigurationWorkingCopy.doSave();
                        return iLaunchConfiguration2;
                    }
                    catch (CoreException coreException) {
                        COBOLDebugUIPlugin.logError(coreException);
                        return iLaunchConfiguration;
                    }
                }
            }
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfiguration findConfiguration(String string, String string2) {
        ILaunchConfiguration[] iLaunchConfigurationArray = null;
        try {
            try {
                iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getLaunchConfigurationType());
            }
            catch (CoreException coreException) {
                COBOLDebugUIPlugin.logError(coreException);
            }
            ArrayList<ILaunchConfiguration> arrayList = new ArrayList<ILaunchConfiguration>();
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                try {
                    if (iLaunchConfigurationArray[n].getAttribute("ProjectName", "").equals(string)) {
                        arrayList.add(iLaunchConfigurationArray[n]);
                    }
                }
                catch (CoreException coreException) {
                    COBOLDebugUIPlugin.logError(coreException);
                }
                ++n;
            }
            if (arrayList != null) {
                if (arrayList.size() == 0) {
                    return this.createConfiguration(string);
                }
                if (arrayList.size() == 1) {
                    return (ILaunchConfiguration)arrayList.get(0);
                }
                return this.chooseConfiguration(arrayList, string2);
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getLaunchConfigurationType();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(string));
            iLaunchConfigurationWorkingCopy.setAttribute("ProjectName", string);
            iLaunchConfigurationWorkingCopy.setAttribute("CommandLineParameter", "");
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            String string2 = "";
            String string3 = "";
            int n = COBOLDebugUtil.getProjectType((IProject)iProject);
            if (n == 0) {
                string2 = COBOLDebugUtil.getTargetFilePath((IProject)iProject);
            }
            if (iProject != null && iProject.isAccessible()) {
                string3 = iProject.getLocation().toOSString();
            }
            iLaunchConfigurationWorkingCopy.setAttribute("ExecutableName", string2);
            iLaunchConfigurationWorkingCopy.setAttribute("WorkFolder", string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string != null && string.length() > 0) {
                string = String.valueOf(string) + "*1";
                arrayList.add(string);
            }
            iLaunchConfigurationWorkingCopy.setAttribute("SourceLookupList", arrayList);
            iLaunchConfigurationWorkingCopy.setAttribute("VariablesList", new ArrayList());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.debug.ui.target_debug_perspective", "perspective_default");
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.debug.ui.target_run_perspective", "perspective_default");
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.cobol.debug.ui.launcher.COBOLLaunchConfigurationDelegate");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected IProject chooseProjectDialog() {
        COBOLProjectConfigurationDialog cOBOLProjectConfigurationDialog = null;
        try {
            cOBOLProjectConfigurationDialog = new COBOLProjectConfigurationDialog(COBOLDebugUIPlugin.getActiveWorkbenchShell());
            this.fStatus = cOBOLProjectConfigurationDialog.open();
            if (this.fStatus == 0) {
                return cOBOLProjectConfigurationDialog.getProject();
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    private IProject getProject(ILaunchConfiguration iLaunchConfiguration) {
        IProject iProject = null;
        try {
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iLaunchConfiguration.getAttribute("ProjectName", ""));
        }
        catch (CoreException coreException) {}
        return iProject;
    }
}

