/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher.internal.core;

import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLLaunchStarter;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.COBOLDebugUISourceLocator;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;

public class COBOLDebugStarter
implements ICOBOLLaunchStarter {
    private IProject fProject;
    private ILaunch fLaunch;

    public COBOLDebugStarter(ILaunch iLaunch, IProject iProject) throws COBOLDebugException {
        this.fProject = iProject;
        this.fLaunch = iLaunch;
        this.doLaunch(iLaunch);
    }

    public void doLaunch(ILaunch iLaunch) throws COBOLDebugException {
        ICOBOLDebugModel iCOBOLDebugModel = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(this.fLaunch);
        ICOBOLDebugTarget iCOBOLDebugTarget = iCOBOLDebugModel.getCOBOLDebugTarget();
        iCOBOLDebugTarget.initialize(this.fProject);
        IProcess iProcess = iCOBOLDebugTarget.getProcess();
        iCOBOLDebugModel.setCOBOLProcess(iProcess);
        ISourceLocator iSourceLocator = iCOBOLDebugModel.getCOBOLSourceLocator();
        try {
            if (iSourceLocator == null) {
                iSourceLocator = new COBOLDebugUISourceLocator(this.fProject, iLaunch.getLaunchConfiguration());
            }
        }
        catch (DebugException debugException) {
            throw COBOLDebugException.createCOBOLDebugException((Exception)((Object)debugException), (String)COBOLDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier());
        }
        iLaunch.setSourceLocator(iSourceLocator);
    }
}

