/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.core.ui.projectmanagement.COBOLProjectNature;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLProjectConfigurationDialog;
import org.eclipse.cobol.debug.ui.launcher.COBOLLaunchConfigurationTab;
import org.eclipse.cobol.debug.ui.launcher.COBOLSourceViewerContentProvider;
import org.eclipse.cobol.debug.ui.launcher.COBOLSourceViewerLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class COBOLSourceLookupBlock
extends COBOLLaunchConfigurationTab {
    protected TableViewer fTableViewer = null;
    private Button fUpButton = null;
    private Button fDownButton = null;
    private Button fAddProjButton = null;
    private Button fRemoveButton = null;
    private Button fAddExternalFolderButton = null;
    private ISelection fSelection;
    private String fDefaultProjectName = null;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(Messages.getString((String)"COBOLSourceLookupBlock.table.label"));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fTableViewer = new TableViewer(composite2);
        this.fTableViewer.getControl().setFont(composite2.getFont());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new COBOLSourceViewerLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new COBOLSourceViewerContentProvider());
        gridData = new GridData(1808);
        this.fTableViewer.getControl().setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        gridData = new GridData(258);
        composite3.setLayoutData((Object)gridData);
        this.fUpButton = this.createPushButton(composite3, Messages.getString((String)"COBOLSourceLookupBlock.button.Up.label"), null);
        this.fDownButton = this.createPushButton(composite3, Messages.getString((String)"COBOLSourceLookupBlock.button.Down.label"), null);
        this.fRemoveButton = this.createPushButton(composite3, Messages.getString((String)"COBOLSourceLookupBlock.button.Remove.label"), null);
        this.fAddProjButton = this.createPushButton(composite3, Messages.getString((String)"COBOLSourceLookupBlock.button.AddProj.label"), null);
        this.fAddExternalFolderButton = this.createPushButton(composite3, Messages.getString((String)"COBOLSourceLookupBlock.button.AddFolder.label"), null);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLSourceLookupBlock.this.moveEntriesUp();
                COBOLSourceLookupBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLSourceLookupBlock.this.moveEntriesDown();
                COBOLSourceLookupBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLSourceLookupBlock.this.removeSelectedEntries();
            }
        });
        this.fAddProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLSourceLookupBlock.this.addCOBOLProjects();
            }
        });
        this.fAddExternalFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLSourceLookupBlock.this.addExternalFolders();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                COBOLSourceLookupBlock.this.updateButtons();
                COBOLSourceLookupBlock.this.fSelection = COBOLSourceLookupBlock.this.fTableViewer.getSelection();
            }
        });
        this.updateButtons();
        this.setControl((Control)composite2);
    }

    private void updateButtons() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        int n = iStructuredSelection.size();
        int n2 = this.fTableViewer.getTable().getItemCount();
        int n3 = this.fTableViewer.getTable().getSelectionIndex();
        int[] nArray = this.fTableViewer.getTable().getSelectionIndices();
        boolean bl = false;
        boolean bl2 = false;
        if (nArray != null && nArray.length > 0) {
            if (nArray[0] == 0) {
                bl = true;
            }
            if (nArray[nArray.length - 1] == n2 - 1) {
                bl2 = true;
            }
        }
        this.fRemoveButton.setEnabled(n2 > 0 && n > 0 && !this.isDefaultProjectSelected(iStructuredSelection));
        this.fUpButton.setEnabled(!bl && n2 > 1 && n != 0 && n3 > 0);
        this.fDownButton.setEnabled(!bl2 && n2 > 1 && n != 0 && n3 != n2 - 1);
        this.fAddProjButton.setEnabled(this.anyProjectToBeAdded(this.getListFromTable()));
    }

    protected boolean isDefaultProjectSelected(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null || iStructuredSelection.isEmpty() || this.fDefaultProjectName == null || this.fDefaultProjectName.length() == 0) {
            return false;
        }
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof String && this.fDefaultProjectName.equalsIgnoreCase((String)objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ArrayList getListFromTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.fTableViewer.getTable().getItemCount();
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            string = (String)this.fTableViewer.getElementAt(n2);
            if (string != null) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList;
    }

    public ArrayList getSelectedItemsAsList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this.fTableViewer.getTable().getSelectionIndices();
        int n = 0;
        while (n < nArray.length) {
            arrayList.add(this.fTableViewer.getElementAt(nArray[n]));
            ++n;
        }
        return arrayList;
    }

    public void setTableEntries(ArrayList arrayList) {
        this.fTableViewer.getTable().removeAll();
        if (arrayList != null) {
            this.fTableViewer.setInput((Object)arrayList);
        }
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = null;
        try {
            this.fDefaultProjectName = string = iLaunchConfigurationWorkingCopy.getAttribute("ProjectName", "");
        }
        catch (CoreException coreException) {}
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            this.fDefaultProjectName = string = String.valueOf(string) + "*1";
            arrayList.add(string);
        }
        iLaunchConfigurationWorkingCopy.setAttribute("SourceLookupList", arrayList);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        ArrayList<String> arrayList = null;
        try {
            arrayList = (ArrayList<String>)iLaunchConfiguration.getAttribute("SourceLookupList", null);
        }
        catch (CoreException coreException) {}
        if (arrayList == null || arrayList.isEmpty()) {
            String string = null;
            try {
                this.fDefaultProjectName = string = iLaunchConfiguration.getAttribute("ProjectName", "");
            }
            catch (CoreException coreException) {}
            arrayList = new ArrayList<String>();
            if (string != null && string.length() > 0) {
                this.fDefaultProjectName = string = String.valueOf(string) + "*1";
                arrayList.add(string);
            }
            if (iLaunchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
                this.setDefaults((ILaunchConfigurationWorkingCopy)iLaunchConfiguration);
            } else {
                try {
                    iLaunchConfiguration.getWorkingCopy().setAttribute("SourceLookupList", arrayList);
                }
                catch (CoreException coreException) {}
            }
        }
        this.fTableViewer.getTable().removeAll();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                String string = (String)arrayList.get(n);
                if (COBOLDebugUtil.getProjectFromName((String)string) == null && COBOLDebugUtil.getExternalFolderFromName((String)string) == null) {
                    arrayList.remove(string);
                    --n;
                }
                ++n;
            }
            this.fTableViewer.setInput(arrayList);
        }
        this.fTableViewer.setSelection(this.fSelection);
        try {
            this.fDefaultProjectName = iLaunchConfiguration.getAttribute("ProjectName", "");
            if (this.fDefaultProjectName != null && this.fDefaultProjectName.length() > 0) {
                this.fDefaultProjectName = String.valueOf(this.fDefaultProjectName) + "*1";
            }
        }
        catch (CoreException coreException) {}
        this.updateButtons();
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        ArrayList arrayList = this.getListFromTable();
        iLaunchConfigurationWorkingCopy.setAttribute("SourceLookupList", (List)arrayList);
    }

    public String getName() {
        return Messages.getString((String)"COBOLSourceLookupBlock.tab.name");
    }

    protected void moveEntriesUp() {
        ArrayList arrayList = this.getSelectedItemsAsList();
        if (arrayList.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        ArrayList arrayList2 = this.getListFromTable();
        for (Object e : arrayList) {
            n2 = arrayList2.indexOf(e);
            if (n2 > n) {
                n = n2 - 1;
                Object e2 = arrayList2.get(n);
                arrayList2.set(n, e);
                arrayList2.set(n2, e2);
            }
            n = n2;
        }
        this.setTableEntries(arrayList2);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((List)arrayList));
    }

    protected void moveEntriesDown() {
        ArrayList arrayList = this.getSelectedItemsAsList();
        if (arrayList.isEmpty()) {
            return;
        }
        ArrayList arrayList2 = this.getListFromTable();
        int n = arrayList2.size() - 1;
        int n2 = 0;
        int n3 = arrayList.size() - 1;
        while (n3 >= 0) {
            Object e = arrayList.get(n3);
            n2 = arrayList2.indexOf(e);
            if (n2 < n) {
                n = n2 + 1;
                Object e2 = arrayList2.get(n);
                arrayList2.set(n, e);
                arrayList2.set(n2, e2);
            }
            n = n2;
            --n3;
        }
        this.setTableEntries(arrayList2);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((List)arrayList));
    }

    protected void removeSelectedEntries() {
        int[] nArray = this.fTableViewer.getTable().getSelectionIndices();
        if (nArray != null && nArray.length > 0) {
            int n = nArray[0];
            this.fTableViewer.getTable().remove(nArray);
            int n2 = this.fTableViewer.getTable().getItemCount();
            if (n2 > 0) {
                if (n == n2) {
                    this.fTableViewer.getTable().select(n - 1);
                } else {
                    this.fTableViewer.getTable().select(n);
                }
            }
            this.updateButtons();
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void addCOBOLProjects() {
        COBOLProjectConfigurationDialog cOBOLProjectConfigurationDialog = null;
        cOBOLProjectConfigurationDialog = new COBOLProjectConfigurationDialog(this.getShell(), true, this.getListFromTable());
        int n = cOBOLProjectConfigurationDialog.open();
        IProject[] iProjectArray = null;
        if (n == 0) {
            iProjectArray = cOBOLProjectConfigurationDialog.getSelectedProjects();
        }
        if (iProjectArray == null || iProjectArray.length == 0) {
            return;
        }
        String string = null;
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            string = String.valueOf(iProjectArray[n2].getName()) + "*1";
            if (!this.isEntryExisting(string)) {
                this.fTableViewer.add((Object)string);
            }
            ++n2;
        }
        this.updateLaunchConfigurationDialog();
        this.updateButtons();
    }

    protected void addExternalFolders() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 2);
        directoryDialog.setText(Messages.getString((String)"COBOLSourceLookupBlock.folder_selection_dialog.title"));
        String string = directoryDialog.open();
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.isEntryExisting(string = String.valueOf(string) + "*2")) {
            this.fTableViewer.add((Object)string);
            this.updateLaunchConfigurationDialog();
            this.updateButtons();
        }
    }

    public void removeDefaultProjectFromTable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.fTableViewer.remove((Object)(String.valueOf(string) + "*1"));
        this.fDefaultProjectName = null;
    }

    public void addDefaultProjectIntoTable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.isEntryExisting(string = String.valueOf(string) + "*1")) {
            this.fTableViewer.add((Object)string);
            this.fDefaultProjectName = string;
        }
    }

    public boolean isEntryExisting(String string) {
        int n = this.fTableViewer.getTable().getItemCount();
        if (string == null) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = (String)this.fTableViewer.getElementAt(n2);
            if (string2 != null && string2.equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private boolean anyProjectToBeAdded(ArrayList arrayList) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        String[] stringArray = null;
        int n = 0;
        while (n < iProjectArray.length) {
            block5: {
                try {
                    stringArray = iProjectArray[n].getDescription().getNatureIds();
                    if (stringArray == null || stringArray.length <= 0 || !(iProjectArray[n].getNature(stringArray[0]) instanceof COBOLProjectNature)) break block5;
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        if (!iProjectArray[n].equals((Object)COBOLDebugUtil.getProjectFromName((String)((String)arrayList.get(n2))))) {
                            ++n2;
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
                catch (CoreException coreException) {}
            }
            ++n;
        }
        return false;
    }
}

