/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugImages;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.COBOLProjectConfigurationDialog;
import org.eclipse.cobol.debug.ui.ICOBOLDebugHelpContextID;
import org.eclipse.cobol.debug.ui.launcher.COBOLLaunchConfigurationTab;
import org.eclipse.cobol.debug.ui.launcher.COBOLSourceTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class COBOLMainTab
extends COBOLLaunchConfigurationTab {
    private IProject fProject;
    private Text fProjectText;
    private Text fParameterText;
    private static final int TEXT_WIDTH = 150;
    private static final int BUTTON_WIDTH = 80;
    private Text fExecutableText = null;
    private Label fExecutableLabel = null;
    private Button fTargetBrowseButton = null;
    private Button fBrowseButton = null;
    private Text fWorkFolderText = null;
    private Button fFolderButton = null;

    public COBOLMainTab() {
        try {
            this.fProject = (IProject)this.getContext();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    public void createControl(Composite composite) {
        try {
            Control control = this.createContents(composite);
            this.setControl(control);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), ICOBOLDebugHelpContextID.LAUNCH_MAINTAB_CONTEXT_ID);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            COBOLDebugUIPlugin.logError(unsatisfiedLinkError);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            COBOLDebugUIPlugin.logError(illegalArgumentException);
        }
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setFont(composite2.getFont());
        label.setText(Messages.getString((String)"ProjectName"));
        this.fProjectText = new Text(composite2, 18432);
        this.fProjectText.setFont(composite2.getFont());
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        this.fProjectText.setLayoutData((Object)gridData);
        if (this.fProject != null) {
            this.fProjectText.setText(this.fProject.getName());
        }
        this.fProjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                COBOLMainTab.this.updateProjectRelatedControls(COBOLMainTab.this.fProjectText.getText());
                COBOLMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fBrowseButton = new Button(composite2, 0);
        this.fBrowseButton.setFont(composite2.getFont());
        GridData gridData2 = new GridData(128);
        PixelConverter pixelConverter = new PixelConverter((Control)this.fBrowseButton);
        gridData2.widthHint = pixelConverter.convertHorizontalDLUsToPixels(61);
        this.fBrowseButton.setLayoutData((Object)gridData2);
        this.fBrowseButton.setText(Messages.getString((String)"Browse"));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLMainTab.this.handleProjectBrowseButton();
            }
        });
        this.fExecutableLabel = new Label(composite2, 0);
        this.fExecutableLabel.setFont(composite2.getFont());
        this.fExecutableLabel.setText(Messages.getString((String)"COBOLMainTab.executable.text.label"));
        this.fExecutableText = new Text(composite2, 18432);
        this.fExecutableText.setFont(composite2.getFont());
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.fExecutableText.setLayoutData((Object)gridData);
        this.fExecutableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                COBOLMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fTargetBrowseButton = new Button(composite2, 0);
        this.fTargetBrowseButton.setFont(composite2.getFont());
        gridData2 = new GridData(128);
        pixelConverter = new PixelConverter((Control)this.fTargetBrowseButton);
        gridData2.widthHint = pixelConverter.convertHorizontalDLUsToPixels(61);
        this.fTargetBrowseButton.setLayoutData((Object)gridData2);
        this.fTargetBrowseButton.setText(Messages.getString((String)"COBOLMainTab.executable.button.text"));
        this.fTargetBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLMainTab.this.handleTargetBrowseOperation();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setFont(composite2.getFont());
        label2.setText(Messages.getString((String)"COBOLMainTab.folder.text.label"));
        this.fWorkFolderText = new Text(composite2, 18432);
        this.fWorkFolderText.setFont(composite2.getFont());
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.fWorkFolderText.setLayoutData((Object)gridData);
        this.fWorkFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                COBOLMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFolderButton = new Button(composite2, 0);
        this.fFolderButton.setFont(composite2.getFont());
        gridData2 = new GridData(128);
        pixelConverter = new PixelConverter((Control)this.fFolderButton);
        gridData2.widthHint = pixelConverter.convertHorizontalDLUsToPixels(61);
        this.fFolderButton.setLayoutData((Object)gridData2);
        this.fFolderButton.setText(Messages.getString((String)"COBOLMainTab.folder.button.text"));
        this.fFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLMainTab.this.handleFolderBrowseOperation();
            }
        });
        Label label3 = new Label(composite2, 0);
        label3.setFont(composite2.getFont());
        label3.setText(Messages.getString((String)"CommandLineParameter"));
        this.fParameterText = new Text(composite2, 18432);
        this.fParameterText.setFont(composite2.getFont());
        GridData gridData3 = new GridData(256);
        gridData3.horizontalSpan = 2;
        this.fParameterText.setLayoutData((Object)gridData3);
        this.fParameterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                COBOLMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.enableTargetControls(false);
        this.updateProjectRelatedControls(this.fProjectText.getText());
        return composite2;
    }

    protected void handleProjectBrowseButton() {
        COBOLProjectConfigurationDialog cOBOLProjectConfigurationDialog = null;
        Shell shell = this.getShell();
        try {
            if (shell != null) {
                cOBOLProjectConfigurationDialog = new COBOLProjectConfigurationDialog(shell);
            }
            if (cOBOLProjectConfigurationDialog.open() == 0) {
                this.fProjectText.setText(cOBOLProjectConfigurationDialog.getProject().getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    protected void handleTargetBrowseOperation() {
        String string;
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(Messages.getString((String)"SelectFileTitle.label"));
        if (Platform.getOS().equalsIgnoreCase("win32")) {
            fileDialog.setFilterExtensions(new String[]{"*.exe"});
        } else {
            fileDialog.setFilterExtensions(new String[]{"*"});
        }
        String string2 = this.fProjectText.getText().trim();
        if (string2.length() > 0 && (string = ResourcesPlugin.getWorkspace().getRoot().getProject(string2)) != null && string.isAccessible()) {
            fileDialog.setFilterPath(string.getLocation().toOSString());
        }
        if ((string = fileDialog.open()) != null) {
            this.fExecutableText.setText(string);
        }
    }

    protected void handleFolderBrowseOperation() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 2);
        directoryDialog.setText(Messages.getString((String)"COBOLMainTab.folder_selection_dialog.title"));
        String string = directoryDialog.open();
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.isFolderEntryExisting(string)) {
            this.fWorkFolderText.setText(string);
        }
    }

    protected boolean isFolderEntryExisting(String string) {
        String string2 = this.fWorkFolderText.getText();
        StringTokenizer stringTokenizer = null;
        if (string2.length() > 0) {
            stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                if (!string.equalsIgnoreCase(stringTokenizer.nextToken())) continue;
                return true;
            }
        }
        return false;
    }

    private void updateProjectRelatedControls(String string) {
        if (string == null || string.trim().length() == 0) {
            this.fExecutableText.setText("");
            return;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject == null || !iProject.isAccessible()) {
            return;
        }
        int n = COBOLDebugUtil.getProjectType((IProject)iProject);
        if (n == 1) {
            this.enableTargetControls(true);
            this.populateWorkFolder(iProject);
        } else if (n == 0) {
            this.enableTargetControls(false);
            this.fExecutableText.setText(COBOLDebugUtil.getTargetFilePath((IProject)iProject));
            this.populateWorkFolder(iProject);
        }
    }

    private void populateWorkFolder(IProject iProject) {
        if (iProject != null && this.fWorkFolderText.getText().trim().length() == 0) {
            this.fWorkFolderText.setText(iProject.getLocation().toOSString());
        }
    }

    private void enableTargetControls(boolean bl) {
        this.fExecutableLabel.setEnabled(bl);
        this.fExecutableText.setEditable(bl);
        this.fTargetBrowseButton.setEnabled(bl);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        Object object = this.getContext();
        IProject iProject = null;
        if (object != null) {
            iProject = (IProject)object;
            iLaunchConfigurationWorkingCopy.setAttribute("ProjectName", iProject.getName());
            String string = this.generateUniqueNameFrom(iProject.getName());
            iLaunchConfigurationWorkingCopy.rename(string);
            String string2 = "";
            int n = COBOLDebugUtil.getProjectType((IProject)iProject);
            if (n == 0) {
                string2 = COBOLDebugUtil.getTargetFilePath((IProject)iProject);
            }
            iLaunchConfigurationWorkingCopy.setAttribute("ExecutableName", string2);
            iLaunchConfigurationWorkingCopy.setAttribute("WorkFolder", iProject.getLocation().toOSString());
            iLaunchConfigurationWorkingCopy.setAttribute("CommandLineParameter", "");
            iLaunchConfigurationWorkingCopy.setAttribute("VariablesList", new ArrayList());
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            Object object = this.getContext();
            if (object != null && object instanceof IProject) {
                this.fProject = (IProject)object;
            }
            this.fProjectText.setText(iLaunchConfiguration.getAttribute("ProjectName", ""));
            this.fExecutableText.setText(iLaunchConfiguration.getAttribute("ExecutableName", ""));
            this.fWorkFolderText.setText(iLaunchConfiguration.getAttribute("WorkFolder", ""));
            this.fParameterText.setText(iLaunchConfiguration.getAttribute("CommandLineParameter", ""));
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.fProjectText.getText().trim();
        COBOLSourceTab cOBOLSourceTab = this.getCOBOLSourceTab();
        if (cOBOLSourceTab != null) {
            String string2 = null;
            try {
                string2 = iLaunchConfigurationWorkingCopy.getAttribute("ProjectName", "");
            }
            catch (CoreException coreException) {}
            cOBOLSourceTab.updateSourceLookupTable(string2, string, iLaunchConfigurationWorkingCopy);
        }
        iLaunchConfigurationWorkingCopy.setAttribute("ProjectName", string);
        iLaunchConfigurationWorkingCopy.setAttribute("CommandLineParameter", this.fParameterText.getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute("ExecutableName", this.fExecutableText.getText().trim());
        iLaunchConfigurationWorkingCopy.setAttribute("WorkFolder", this.fWorkFolderText.getText().trim());
    }

    private COBOLSourceTab getCOBOLSourceTab() {
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        if (iLaunchConfigurationTabArray != null) {
            int n = 0;
            while (n < iLaunchConfigurationTabArray.length) {
                if (iLaunchConfigurationTabArray[n] instanceof COBOLSourceTab) {
                    return (COBOLSourceTab)iLaunchConfigurationTabArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        Object object;
        File file;
        this.setErrorMessage(null);
        this.setMessage(null);
        String string = this.fProjectText.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage(Messages.getString((String)"COBOLMainTab.Specifyproject"));
            return false;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject == null || !iProject.isAccessible()) {
            this.setErrorMessage(Messages.getString((String)"COBOLMainTab.error.projectdoesnotexist"));
            return false;
        }
        String string2 = this.fExecutableText.getText().trim();
        if (string2.length() == 0) {
            this.setErrorMessage(Messages.getString((String)"COBOLMainTab.executable.empty.error"));
            return false;
        }
        if (!(COBOLDebugUtil.getProjectType((IProject)iProject) != 1 || (file = (object = new Path(string2)).toFile()) != null && file.exists())) {
            this.setErrorMessage(Messages.getString((String)"COBOLMainTab.executable.notfound.error"));
            return false;
        }
        object = this.fWorkFolderText.getText().trim();
        if (((String)object).length() == 0) {
            this.setErrorMessage(Messages.getString((String)"COBOLMainTab.workfolder.empty.error"));
            return false;
        }
        file = new Path((String)object);
        File file2 = file.toFile();
        if (file2 == null || !file2.isDirectory()) {
            this.setErrorMessage(Messages.getString((String)"COBOLMainTab.workfolder.notfound.error"));
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.getString((String)"COBOLMaintab.header");
    }

    public Image getImage() {
        return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_LAUNCHER_MAINTAB);
    }
}

