/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher;

import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.ui.views.common.TreeElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

public abstract class COBOLLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected Object getContext() {
        IProject iProject = null;
        IWorkbenchPage iWorkbenchPage = COBOLDebugUIPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            Object object;
            IStructuredSelection iStructuredSelection;
            ISelection iSelection = iWorkbenchPage.getSelection();
            if (iSelection instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)iSelection).isEmpty()) {
                object = iStructuredSelection.getFirstElement();
                if (object instanceof TreeElement) {
                    TreeElement treeElement = (TreeElement)object;
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(treeElement.getProject().getName());
                    return iProject;
                }
                if (object instanceof IAdaptable) {
                    try {
                        IResource iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                        iProject = iResource.getProject();
                        return iProject;
                    }
                    catch (NullPointerException nullPointerException) {
                        COBOLDebugUIPlugin.logError(nullPointerException);
                        return null;
                    }
                }
            }
            if ((iStructuredSelection = iWorkbenchPage.getActiveEditor()) != null) {
                try {
                    object = iStructuredSelection.getEditorInput();
                    IResource iResource = (IResource)object.getAdapter(IResource.class);
                    iProject = iResource.getProject();
                    return iProject;
                }
                catch (NullPointerException nullPointerException) {
                    COBOLDebugUIPlugin.logError(nullPointerException);
                }
            }
        }
        return null;
    }

    protected String generateUniqueNameFrom(String string) {
        if (string == null || string.length() == 0) {
            return "New_Configuration";
        }
        int n = 1;
        String string2 = string;
        String string3 = "";
        try {
            CharSequence charSequence;
            int n2 = string2.lastIndexOf(95);
            if (n2 > -1) {
                charSequence = string2.substring(n2 + 1);
                try {
                    n = Integer.parseInt((String)charSequence);
                    string2 = string.substring(0, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    COBOLDebugUIPlugin.logError(numberFormatException);
                }
            }
            string3 = string2;
            try {
                while (this.getLaunchManager().isExistingLaunchConfigurationName(string3)) {
                    charSequence = new StringBuffer(string2);
                    ((StringBuffer)charSequence).append('_');
                    ((StringBuffer)charSequence).append(String.valueOf(n));
                    ++n;
                    string3 = ((StringBuffer)charSequence).toString();
                }
            }
            catch (CoreException coreException) {
                COBOLDebugUIPlugin.logError(coreException);
            }
        }
        catch (Exception exception) {
            COBOLDebugUIPlugin.logError(exception);
        }
        return string3;
    }
}

