/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.launcher;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.cobol.core.debug.exceptions.COBOLDebugException;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLLaunchStarter;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.launcher.COBOLRunnableWithProgress;
import org.eclipse.cobol.debug.ui.launcher.internal.core.COBOLLauncherFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class COBOLLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected IProgressMonitor fMonitor = null;
    protected IProject fProject = null;
    private boolean fFlag = false;
    private boolean isTargetDebugMode = false;

    public void launch(final ILaunchConfiguration iLaunchConfiguration, final String string, final ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        this.isTargetDebugMode = false;
        try {
            if (iProgressMonitor == null) {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(COBOLDebugUIPlugin.getActiveWorkbenchWindow().getShell());
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            COBOLLaunchConfigurationDelegate.this.launch(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
                            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                                COBOLLaunchConfigurationDelegate.this.removeLauncher(iLaunch);
                            }
                        }
                        catch (CoreException coreException) {
                            COBOLDebugUIPlugin.logError(coreException);
                        }
                    }
                };
                try {
                    progressMonitorDialog.run(true, true, iRunnableWithProgress);
                }
                catch (InvocationTargetException invocationTargetException) {
                    COBOLDebugUIPlugin.logError(invocationTargetException);
                    this.removeLauncher(iLaunch);
                }
                catch (InterruptedException interruptedException) {
                    COBOLDebugUIPlugin.logError(interruptedException);
                    this.removeLauncher(iLaunch);
                }
                catch (NullPointerException nullPointerException) {
                    COBOLDebugUIPlugin.logError(nullPointerException);
                    this.removeLauncher(iLaunch);
                }
                return;
            }
            this.fMonitor = iProgressMonitor;
            if (!this.isRelaunchRequired(string)) {
                this.removeLauncher(iLaunch);
                return;
            }
            this.fProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iLaunchConfiguration.getAttribute("ProjectName", ""));
            if (this.fProject == null) {
                this.showDialog(Messages.getString((String)"Project_Selection_Error_8"), Messages.getString((String)"Select_a_project_9"));
                this.removeLauncher(iLaunch);
                return;
            }
            if (!this.fProject.isAccessible()) {
                this.showDialog(Messages.getString((String)"Project_Selection_Error_8"), MessageFormat.format(Messages.getString((String)"COBOLLaunchConfigurationDelegate.project.error"), this.fProject.getName()));
                this.removeLauncher(iLaunch);
                return;
            }
            this.isTargetDebugMode = new Boolean(this.fProject.getPersistentProperty(COBOLDebugPlugin.DEBUG_RELEASE_MODE));
        }
        catch (CoreException coreException) {
            this.showDialog(Messages.getString((String)"Common.error.dialog.title"), coreException.getLocalizedMessage());
            this.removeLauncher(iLaunch);
            return;
        }
        if (!this.isTargetDebugMode && string.equals("debug")) {
            boolean bl = this.showConfirmMessageDialog(Messages.getString((String)"ReleaseModeConfirm.label"), Messages.getString((String)"ReleaseModeConfirm.text"));
            if (bl) {
                this.removeLauncher(iLaunch);
                iLaunchConfiguration.launch("run", iProgressMonitor);
                return;
            }
            this.removeLauncher(iLaunch);
            return;
        }
        String string2 = COBOLDebugUtil.getTargetName((ILaunchConfiguration)iLaunchConfiguration);
        final File file = new File(string2);
        COBOLRunnableWithProgress cOBOLRunnableWithProgress = new COBOLRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    boolean bl = false;
                    if (string.equals("debug")) {
                        boolean bl2 = COBOLLaunchConfigurationDelegate.this.isSVDFoundInProject(COBOLLaunchConfigurationDelegate.this.fProject);
                        if (bl2) {
                            if (!COBOLLaunchConfigurationDelegate.this.isTargetDebugMode) {
                                bl = true;
                            }
                        } else if (COBOLLaunchConfigurationDelegate.this.isTargetDebugMode) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        COBOLLaunchConfigurationDelegate.this.fProject.build(6, iProgressMonitor);
                    } else {
                        COBOLLaunchConfigurationDelegate.this.fProject.build(10, iProgressMonitor);
                    }
                    if (!file.exists()) {
                        this.setErrorInProcessing(true);
                        COBOLLaunchConfigurationDelegate.this.showView("org.eclipse.ui.views.ProblemView");
                    }
                }
                catch (CoreException coreException) {
                    COBOLDebugUIPlugin.logError(coreException);
                }
            }
        };
        this.runWithProgressDialog(cOBOLRunnableWithProgress);
        if (cOBOLRunnableWithProgress.isErrorInProcessing()) {
            this.showDialog(Messages.getString((String)"BuildFailure.label"), Messages.getString((String)"BuildFailure.text"));
            this.removeLauncher(iLaunch);
            return;
        }
        try {
            ICOBOLLaunchStarter iCOBOLLaunchStarter = COBOLLauncherFactory.create(iLaunch, this.fProject, iProgressMonitor);
            if (iCOBOLLaunchStarter == null) {
                this.removeLauncher(iLaunch);
                return;
            }
            if (this.fMonitor != null) {
                this.fMonitor.done();
            }
        }
        catch (COBOLDebugException cOBOLDebugException) {
            this.showDialog(Messages.getString((String)"Common.error.dialog.title"), cOBOLDebugException.getLocalizedMessage());
            this.removeLauncher(iLaunch);
            return;
        }
        if (!iLaunch.hasChildren()) {
            this.removeLauncher(iLaunch);
        }
        COBOLDebugUIPlugin.getDefault().getLaunchViewListener().removeSelectionListener();
        COBOLDebugUIPlugin.getDefault().getLaunchViewListener().addSelectionListener();
    }

    protected boolean isRelaunchRequired(final String string) {
        COBOLRunnableWithProgress cOBOLRunnableWithProgress = new COBOLRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor iProgressMonitor) {
                ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                if (iLaunchArray != null && string.equals("debug")) {
                    int n = 0;
                    while (n < iLaunchArray.length) {
                        if (!iLaunchArray[n].isTerminated() && !iLaunchArray[n].getLaunchMode().equals("run")) {
                            try {
                                if (iLaunchArray[n].getDebugTarget() != null && iLaunchArray[n].getDebugTarget() instanceof ICOBOLDebugTarget) {
                                    boolean bl = COBOLLaunchConfigurationDelegate.this.showConfirmMessageDialog(Messages.getString((String)"COBOLLaunchConfigurationDelegate.confirm.dialog.title"), Messages.getString((String)"COBOLLaunchConfigurationDelegate.launch.terminate.confirm"));
                                    if (!bl) {
                                        this.setErrorInProcessing(true);
                                        return;
                                    }
                                    iLaunchArray[n].terminate();
                                }
                            }
                            catch (DebugException debugException) {}
                        }
                        ++n;
                    }
                }
            }
        };
        this.runWithProgressDialog(cOBOLRunnableWithProgress);
        return !cOBOLRunnableWithProgress.isErrorInProcessing();
    }

    protected void showDialog(final String string, final String string2) {
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = COBOLDebugUIPlugin.getActiveWorkbenchShell();
                    if (shell == null) {
                        shell = Display.getDefault().getActiveShell();
                    }
                    if (shell != null) {
                        try {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                }
            });
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected boolean showConfirmMessageDialog(final String string, final String string2) {
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow iWorkbenchWindow = COBOLDebugUIPlugin.getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null) {
                        Shell shell = iWorkbenchWindow.getShell();
                        if (shell == null) {
                            shell = Display.getDefault().getActiveShell();
                        }
                        if (shell != null) {
                            try {
                                COBOLLaunchConfigurationDelegate.this.fFlag = MessageDialog.openConfirm((Shell)shell, (String)string, (String)string2);
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    }
                }
            });
        }
        catch (Exception exception) {}
        return this.fFlag;
    }

    protected void showView(final String string) {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = COBOLDebugUIPlugin.getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                        try {
                            IViewPart iViewPart = iWorkbenchPage.findView(string);
                            if (iViewPart == null) {
                                IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                                iWorkbenchPage.showView(string);
                                iWorkbenchPage.activate(iWorkbenchPart);
                            } else {
                                iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
                            }
                        }
                        catch (PartInitException partInitException) {
                            COBOLDebugUIPlugin.logError(partInitException);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    protected void removeLauncher(ILaunch iLaunch) {
        try {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            if (this.fMonitor != null && !this.fMonitor.isCanceled()) {
                this.fMonitor.setCanceled(true);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected void runWithProgressDialog(final COBOLRunnableWithProgress cOBOLRunnableWithProgress) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = COBOLDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    Shell shell = iWorkbenchWindow.getShell();
                    if (shell == null) {
                        shell = Display.getDefault().getActiveShell();
                    }
                    if (shell != null) {
                        try {
                            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                            progressMonitorDialog.run(true, true, (IRunnableWithProgress)cOBOLRunnableWithProgress);
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            COBOLDebugUIPlugin.logError(invocationTargetException);
                        }
                        catch (InterruptedException interruptedException) {
                            COBOLDebugUIPlugin.logError(interruptedException);
                        }
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSVDFoundInProject(IProject iProject) {
        if (iProject == null) return false;
        if (!iProject.exists()) {
            return false;
        }
        try {
            IResource[] iResourceArray = iProject.members(1);
            if (iResourceArray == null) return false;
            String string = null;
            int n = 0;
            while (true) {
                if (n >= iResourceArray.length) {
                    return false;
                }
                if (iResourceArray[n] instanceof IFile && ((IFile)iResourceArray[n]).isAccessible() && (string = ((IFile)iResourceArray[n]).getFileExtension()) != null && string.equalsIgnoreCase("svd")) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

