/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import org.eclipse.cobol.core.debug.model.ICOBOLVariable;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.actions.COBOLDebugTargetStatus;
import org.eclipse.cobol.debug.ui.views.COBOLWatchView;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SetDataInterrruptionAction
implements IObjectActionDelegate {
    ICOBOLVariable fVariable = null;
    IWorkbenchPart targetPart;
    IStructuredSelection selection;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        this.fVariable.setAsInterrupteable(iAction.isChecked());
        if (COBOLDebugPlugin.getDefault() != null && COBOLDebugPlugin.getCOBOLVariableManager() != null) {
            COBOLDebugPlugin.getCOBOLVariableManager().SetDataInterruption(this.getVariable());
        }
        if (this.targetPart != null && this.targetPart instanceof COBOLWatchView && this.selection != null) {
            ((COBOLWatchView)this.targetPart).refreshDetailPane(this.selection);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            if (iStructuredSelection.isEmpty() || iStructuredSelection.size() > 1) {
                return;
            }
            this.selection = iStructuredSelection;
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ICOBOLVariable) {
                this.setVariable((ICOBOLVariable)object);
                iAction.setChecked(((ICOBOLVariable)object).isInterrupteable());
            }
        }
        iAction.setEnabled(this.enableMenu());
    }

    public void setVariable(ICOBOLVariable iCOBOLVariable) {
        this.fVariable = iCOBOLVariable;
    }

    public ICOBOLVariable getVariable() {
        return this.fVariable;
    }

    private boolean enableMenu() {
        try {
            IDebugTarget iDebugTarget = COBOLDebugTargetStatus.getContext();
            return iDebugTarget != null && !iDebugTarget.isTerminated() && iDebugTarget.isSuspended();
        }
        catch (DebugException debugException) {
            COBOLDebugUIPlugin.logError(debugException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return false;
        }
    }
}

