/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.actions.AbstractBreakpointRulerAction;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction() {
    }

    public EnableDisableBreakpointRulerAction(ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        this.setInfo(iVerticalRulerInfo);
        this.setTextEditor((ITextEditor)((COBOLEditor)iTextEditor));
        this.setText(Messages.getString((String)"EnableBreakpoint.label"));
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException coreException) {
                ErrorDialog.openError((Shell)this.getTextEditor().getEditorSite().getShell(), (String)Messages.getString((String)"Enabling/disabling_breakpoints_2"), (String)Messages.getString((String)"Exceptions_occurred_enabling_disabling_the_breakpoint._3"), (IStatus)coreException.getStatus());
            }
        }
    }

    public void update() {
        try {
            this.setBreakpoint(this.determineBreakpoint());
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean bl = this.getBreakpoint().isEnabled();
            this.setText(bl ? Messages.getString((String)"DisableBreakpoint.label") : Messages.getString((String)"EnableBreakpoint.label"));
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
    }
}

