/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;

public class COBOLDebugTargetStatus {
    public static IDebugTarget getContext() throws DebugException {
        IDebugTarget iDebugTarget = null;
        try {
            iDebugTarget = COBOLDebugTargetStatus.getContextFromUI();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        if (iDebugTarget == null) {
            try {
                iDebugTarget = COBOLDebugTargetStatus.getContextFromModel();
                return iDebugTarget;
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugUIPlugin.logError(nullPointerException);
            }
        }
        return iDebugTarget;
    }

    private static IDebugTarget getContextFromModel() throws DebugException {
        IDebugTarget[] iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = 0;
        while (n < iDebugTargetArray.length) {
            IDebugTarget iDebugTarget = iDebugTargetArray[n];
            if (COBOLDebugTargetStatus.getContextFromDebugTarget(iDebugTarget) != null) {
                return iDebugTarget;
            }
            ++n;
        }
        return null;
    }

    private static IDebugTarget getContextFromThread(IThread iThread) throws DebugException {
        if (iThread != null) {
            return iThread.getDebugTarget();
        }
        return null;
    }

    private static IDebugTarget getContextFromUI() throws DebugException {
        IAdaptable iAdaptable = null;
        try {
            iAdaptable = DebugUITools.getDebugContext();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        if (iAdaptable != null) {
            if (iAdaptable instanceof IThread) {
                return COBOLDebugTargetStatus.getContextFromThread((IThread)iAdaptable);
            }
            if (iAdaptable instanceof IDebugElement) {
                return ((IDebugElement)iAdaptable).getDebugTarget();
            }
        }
        return null;
    }

    private static IDebugTarget getContextFromDebugTarget(IDebugTarget iDebugTarget) throws DebugException {
        if (iDebugTarget.isTerminated()) {
            return null;
        }
        return iDebugTarget;
    }
}

