/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.actions.COBOLDebugTargetStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class COBOLChangeExecutionpointAction
extends TextEditorAction
implements IEditorActionDelegate {
    private IAction fAction = null;

    public COBOLChangeExecutionpointAction() {
        super(Messages.getResourceBundle(), "COBOLChangeExecutionpointAction.", null);
        this.update();
    }

    public void run(IAction iAction) {
        this.setPluginAction(iAction);
        this.run();
    }

    public void run() {
        try {
            if (this.getTextEditor() != null) {
                ITextSelection iTextSelection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
                IResource iResource = (IResource)this.getTextEditor().getEditorInput().getAdapter(IResource.class);
                StringBuffer stringBuffer = new StringBuffer();
                int n = iTextSelection.getStartLine() + 1;
                if (iResource instanceof IFile) {
                    stringBuffer.append(((IFile)iResource).getProjectRelativePath().toOSString());
                }
                COBOLDebugPlugin.getCOBOLDebugEventManager().changeExecutionpoint(stringBuffer.toString(), n);
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    protected IAction getPluginAction() {
        return this.fAction;
    }

    protected void setPluginAction(IAction iAction) {
        this.fAction = iAction;
    }

    public void update() {
        IAction iAction = this.getPluginAction();
        if (iAction != null) {
            try {
                IDebugTarget iDebugTarget = COBOLDebugTargetStatus.getContext();
                iAction.setEnabled(iDebugTarget != null && !iDebugTarget.isTerminated() && iDebugTarget.isSuspended());
            }
            catch (DebugException debugException) {
                iAction.setEnabled(false);
                COBOLDebugUIPlugin.logError(debugException);
            }
            catch (NullPointerException nullPointerException) {
                iAction.setEnabled(false);
                COBOLDebugUIPlugin.logError(nullPointerException);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setPluginAction(iAction);
        this.update();
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditor) {
            this.setEditor((ITextEditor)iEditorPart);
        }
        this.setPluginAction(iAction);
        this.update();
    }
}

