/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.internal.core.model.COBOLBreakpointManager;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerRulerAction;

public class COBOLBreakpointRulerAction
extends MarkerRulerAction {
    private static final String COBOL_LINE_BREAKPOINT = "org.eclipse.cobol.debug.cobolLineBreakpointMarker";
    private int fLine = 0;
    private int fStartChar = -1;
    private int fEndChar = -1;
    private IResource fResource = null;
    private IProject fProjectResource = null;
    private String fFileName = "";

    public COBOLBreakpointRulerAction(IVerticalRulerInfo iVerticalRulerInfo, ITextEditor iTextEditor) {
        super(Messages.getResourceBundle(), "ManageCobolBreakpoints.", iTextEditor, iVerticalRulerInfo, IBreakpoint.BREAKPOINT_MARKER, false);
    }

    protected boolean breakpointElementInEditor(IBreakpointManager iBreakpointManager, IMarker iMarker) {
        return true;
    }

    protected List getMarkers() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        IResource iResource = this.getResource();
        IDocument iDocument = this.getDocument();
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel != null) {
            try {
                IWorkspaceRoot iWorkspaceRoot;
                IMarker[] iMarkerArray = null;
                if (iResource instanceof IFile) {
                    this.fFileName = iResource.getFullPath().toOSString();
                    iMarkerArray = iResource.findMarkers(COBOL_LINE_BREAKPOINT, true, 2);
                } else {
                    iWorkspaceRoot = COBOLDebugUIPlugin.getWorkspace().getRoot();
                    iMarkerArray = iWorkspaceRoot.findMarkers(COBOL_LINE_BREAKPOINT, true, 2);
                }
                if (iMarkerArray != null) {
                    iWorkspaceRoot = DebugPlugin.getDefault().getBreakpointManager();
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IBreakpoint iBreakpoint = iWorkspaceRoot.getBreakpoint(iMarkerArray[n]);
                        if (iBreakpoint != null && iWorkspaceRoot.isRegistered(iBreakpoint) && this.breakpointElementInEditor((IBreakpointManager)iWorkspaceRoot, iMarkerArray[n]) && this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument)) {
                            arrayList.add(iMarkerArray[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                COBOLDebugUIPlugin.logError(coreException);
            }
        }
        return arrayList;
    }

    protected void addMarker() {
        IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
        if (this.getDocument() == null) {
            return;
        }
        int n = ((Document)this.getDocument()).getNumberOfLines();
        this.fLine = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
        if (this.fLine > n) {
            return;
        }
        try {
            this.fStartChar = this.getDocument().getLineOffset(this.fLine);
            int n2 = 0;
            n2 = this.getDocument().getLineLength(this.fLine);
            this.fEndChar = this.fStartChar + n2;
            if (this.getDocument().getNumberOfLines() != n && n2 != 1 && n2 != 0) {
                this.fEndChar -= 2;
            }
            ++this.fLine;
        }
        catch (BadLocationException badLocationException) {
            COBOLDebugUIPlugin.logError(badLocationException);
            return;
        }
        if (iEditorInput instanceof IFileEditorInput) {
            Object object;
            if (this.getTextEditor().isDirty()) {
                try {
                    AbstractMarkerAnnotationModel abstractMarkerAnnotationModel;
                    Position position;
                    AbstractMarkerAnnotationModel abstractMarkerAnnotationModel2 = this.getAnnotationModel();
                    object = COBOLDebugUtil.lineBreakpointMarkerExists((String)this.fFileName, (int)this.fLine);
                    if (abstractMarkerAnnotationModel2 != null && object != null && abstractMarkerAnnotationModel2 instanceof AbstractMarkerAnnotationModel && (position = (abstractMarkerAnnotationModel = abstractMarkerAnnotationModel2).getMarkerPosition(object)) != null && !position.isDeleted()) {
                        int n3 = position.getOffset();
                        int n4 = this.fLine;
                        try {
                            this.fLine = this.getDocument().getLineOfOffset(n3) + 1;
                        }
                        catch (BadLocationException badLocationException) {
                            this.fLine = n4;
                        }
                    }
                }
                catch (CoreException coreException) {
                    COBOLDebugUIPlugin.logError(coreException);
                }
            }
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            this.fFileName = iFile.getFullPath().toOSString();
            if (iFile != null) {
                this.fResource = iFile;
                this.fProjectResource = this.fResource.getProject();
                object = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        try {
                            if (!COBOLDebugUtil.lineBreakpointExists((String)COBOLBreakpointRulerAction.this.fFileName, (int)COBOLBreakpointRulerAction.this.fLine)) {
                                HashMap hashMap = new HashMap(10);
                                COBOLDebugUtil.createLineBreakpoint((IResource)COBOLBreakpointRulerAction.this.fResource, (String)COBOLBreakpointRulerAction.this.fFileName, (int)COBOLBreakpointRulerAction.this.fLine, (int)COBOLBreakpointRulerAction.this.fStartChar, (int)COBOLBreakpointRulerAction.this.fEndChar, (boolean)true, hashMap);
                            }
                        }
                        catch (CoreException coreException) {
                            COBOLDebugUIPlugin.logError(coreException);
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)object, null);
                }
                catch (CoreException coreException) {
                    COBOLDebugUIPlugin.logError(coreException);
                }
            }
        }
    }

    protected void removeMarkers(List list) {
        if (COBOLDebugPlugin.getDefault() != null && DebugPlugin.getDefault() != null) {
            COBOLBreakpointManager cOBOLBreakpointManager = COBOLDebugPlugin.getDefault().getBreakpointManager();
            IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            if (iBreakpointManager != null && cOBOLBreakpointManager != null) {
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint((IMarker)iterator.next());
                        cOBOLBreakpointManager.removeBreakpoint(iBreakpoint, true);
                    }
                }
                catch (CoreException coreException) {
                    Shell shell = this.getTextEditor().getSite().getShell();
                    ErrorDialog.openError((Shell)shell, (String)Messages.getString((String)"ManageBreakpoints.error.removing.title1"), (String)Messages.getString((String)"ManageBreakpoints.error.removing.message1"), (IStatus)coreException.getStatus());
                }
            }
        }
    }

    protected void setLine(int n) {
        this.fLine = n;
    }

    protected int getLine() {
        return this.fLine;
    }
}

