/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLHitCountBreakpoint;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.ICOBOLDebugHelpContextID;
import org.eclipse.cobol.debug.ui.actions.COBOLBreakpointPreferencePage;
import org.eclipse.cobol.debug.ui.actions.COBOLBreakpointPreferenceStore;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class COBOLBreakpointPropertiesDialog
extends Dialog
implements IPreferencePageContainer {
    private Composite fTitleArea;
    private Label fTitleImage;
    private CLabel fMessageLabel;
    private String fMessage;
    private Color fNormalMsgAreaBackground;
    private Image fErrorMsgImage;
    private Button fOkButton;
    private COBOLBreakpointPreferencePage fPage;
    protected static final String PREF_DLG_TITLE_IMG = "breakpoint_preference_dialog_title_image";
    protected static final String PREF_DLG_IMG_TITLE_ERROR = "breakpoint_preference_dialog_title_error_image";
    private Composite fPageContainer;
    private Point fMinimumPageSize = new Point(180, 180);
    private ICOBOLBreakpoint fBreakpoint;
    private COBOLBreakpointPreferenceStore fCOBOLBreakpointPreferenceStore;

    static {
        ImageRegistry imageRegistry = COBOLDebugUIPlugin.getDefault().getImageRegistry();
        imageRegistry.put(PREF_DLG_TITLE_IMG, ImageDescriptor.createFromFile(PreferenceDialog.class, (String)"images/pref_dialog_title.gif"));
        imageRegistry.put(PREF_DLG_IMG_TITLE_ERROR, ImageDescriptor.createFromFile(Dialog.class, (String)"images/message_error.gif"));
    }

    protected COBOLBreakpointPropertiesDialog(Shell shell, ICOBOLBreakpoint iCOBOLBreakpoint) {
        super(shell);
        this.setBreakpoint(iCOBOLBreakpoint);
        this.fCOBOLBreakpointPreferenceStore = new COBOLBreakpointPreferenceStore();
    }

    protected void okPressed() {
        final ArrayList arrayList = new ArrayList(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                arrayList.add(propertyChangeEvent.getProperty());
            }
        });
        this.fPage.performOk();
        this.setBreakpointProperties(arrayList);
        super.okPressed();
    }

    protected void setBreakpointProperties(final List list) {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                boolean bl = false;
                ICOBOLBreakpoint iCOBOLBreakpoint = COBOLBreakpointPropertiesDialog.this.getBreakpoint();
                for (String string : list) {
                    switch (string.charAt(0)) {
                        case 'E': {
                            bl = true;
                            break;
                        }
                        case 'H': {
                            if (string.charAt(string.length() - 1) == 'T') {
                                ((ICOBOLHitCountBreakpoint)iCOBOLBreakpoint).setHitCount(COBOLBreakpointPropertiesDialog.this.getPreferenceStore().getInt("HIT_COUNT"));
                                break;
                            }
                            if (COBOLBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("HIT_COUNT_ENABLED")) {
                                if (list.contains("HIT_COUNT")) break;
                                ((ICOBOLHitCountBreakpoint)iCOBOLBreakpoint).setHitCount(COBOLBreakpointPropertiesDialog.this.getPreferenceStore().getInt("HIT_COUNT"));
                                break;
                            }
                            ((ICOBOLHitCountBreakpoint)iCOBOLBreakpoint).setHitCount(0);
                        }
                    }
                }
                if (bl) {
                    iCOBOLBreakpoint.setEnabled(COBOLBreakpointPropertiesDialog.this.getPreferenceStore().getBoolean("ENABLED"));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
    }

    public void setTitle(String string) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(string);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        ((GridLayout)composite2.getLayout()).numColumns = 1;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        this.createTitleArea(composite3);
        Label label = new Label(composite3, 258);
        label.setFont(composite3.getFont());
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.fPageContainer = this.createPageContainer(composite2);
        this.fPageContainer.setLayoutData((Object)new GridData(1808));
        this.fPageContainer.setFont(composite.getFont());
        this.fPage = new COBOLBreakpointPreferencePage(this.getBreakpoint());
        this.fPage.setContainer(this);
        this.fPage.createControl(this.fPageContainer);
        Label label2 = new Label(composite2, 258);
        label2.setFont(composite2.getFont());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ICOBOLDebugHelpContextID.BREAKPOINT_PROPERTIES_DIALOG_CONTEXT_ID);
        return composite2;
    }

    private Composite createTitleArea(Composite composite) {
        this.fTitleArea = new Composite(composite, 0);
        this.fTitleArea.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        Display display = composite.getDisplay();
        Color color = JFaceColors.getBannerBackground((Display)display);
        Color color2 = JFaceColors.getBannerForeground((Display)display);
        GridData gridData = new GridData(1808);
        this.fTitleArea.setLayout((Layout)gridLayout);
        this.fTitleArea.setLayoutData((Object)gridData);
        this.fTitleArea.setBackground(color);
        this.fMessageLabel = new CLabel(this.fTitleArea, 16384);
        this.fMessageLabel.setFont(this.fTitleArea.getFont());
        this.fMessageLabel.setBackground(color);
        this.fMessageLabel.setForeground(color2);
        this.fMessageLabel.setText(" ");
        this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.eclipse.jface.bannerfont".equals(propertyChangeEvent.getProperty()) || "org.eclipse.jface.dialogfont".equals(propertyChangeEvent.getProperty())) {
                    COBOLBreakpointPropertiesDialog.this.updateMessage();
                }
            }
        };
        this.fMessageLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        GridData gridData2 = new GridData(1808);
        this.fMessageLabel.setLayoutData((Object)gridData2);
        this.fTitleImage = new Label(this.fTitleArea, 16384);
        this.fTitleImage.setFont(this.fTitleArea.getFont());
        this.fTitleImage.setBackground(color);
        this.fTitleImage.setImage(COBOLDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_TITLE_IMG));
        gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        this.fTitleImage.setLayoutData((Object)gridData2);
        return this.fTitleArea;
    }

    private Composite createPageContainer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new PageLayout());
        return composite2;
    }

    public void setMinimumPageSize(Point point) {
        this.fMinimumPageSize.x = point.x;
        this.fMinimumPageSize.y = point.y;
    }

    public void setErrorMessage(String string) {
        if (string == null) {
            if (this.fMessageLabel.getImage() != null) {
                this.fMessageLabel.setBackground(this.fNormalMsgAreaBackground);
                this.fMessageLabel.setImage(null);
                this.fTitleImage.setImage(COBOLDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_TITLE_IMG));
                this.fTitleArea.layout(true);
            }
            this.setMessage(this.fMessage);
        } else {
            this.fMessageLabel.setText(string);
            if (this.fMessageLabel.getImage() == null) {
                if (this.fErrorMsgImage == null) {
                    this.fErrorMsgImage = COBOLDebugUIPlugin.getDefault().getImageRegistry().get(PREF_DLG_IMG_TITLE_ERROR);
                }
                this.fNormalMsgAreaBackground = this.fMessageLabel.getBackground();
                this.fMessageLabel.setBackground(JFaceColors.getErrorBackground((Display)this.fMessageLabel.getDisplay()));
                this.fMessageLabel.setImage(this.fErrorMsgImage);
                this.fTitleImage.setImage(null);
                this.fTitleArea.layout(true);
            }
        }
    }

    public void setMessage(String string) {
        this.fMessage = string;
        if (this.fMessage == null) {
            this.fMessage = "";
        }
        if (this.fMessageLabel.getImage() == null) {
            this.fMessageLabel.setText(this.fMessage);
        }
    }

    public void updateMessage() {
        String string = this.fPage.getMessage();
        String string2 = this.fPage.getErrorMessage();
        if (string == null && string2 == null) {
            this.fMessageLabel.setFont(JFaceResources.getBannerFont());
        } else {
            this.fMessageLabel.setFont(JFaceResources.getDialogFont());
        }
        if (string == null) {
            this.setMessage(this.fPage.getTitle());
        } else {
            this.setMessage(string);
        }
        this.setErrorMessage(string2);
    }

    protected ICOBOLBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(ICOBOLBreakpoint iCOBOLBreakpoint) {
        this.fBreakpoint = iCOBOLBreakpoint;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fCOBOLBreakpointPreferenceStore;
    }

    public void updateButtons() {
        if (this.fOkButton != null) {
            this.fOkButton.setEnabled(this.fPage.isValid());
        }
    }

    public void updateTitle() {
        this.setTitle(this.fPage.getTitle());
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fOkButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private class PageLayout
    extends Layout {
        private PageLayout() {
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setSize(rectangle.width, rectangle.height);
                ++n;
            }
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            int n3 = ((COBOLBreakpointPropertiesDialog)COBOLBreakpointPropertiesDialog.this).fMinimumPageSize.x;
            int n4 = ((COBOLBreakpointPropertiesDialog)COBOLBreakpointPropertiesDialog.this).fMinimumPageSize.y;
            Control[] controlArray = composite.getChildren();
            int n5 = 0;
            while (n5 < controlArray.length) {
                Point point = controlArray[n5].computeSize(-1, -1, bl);
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
                ++n5;
            }
            if (n != -1) {
                n3 = n;
            }
            if (n2 != -1) {
                n4 = n2;
            }
            return new Point(n3, n4);
        }
    }
}

