/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public class COBOLBreakpointPreferenceStore
implements IPreferenceStore {
    protected static final String ENABLED = "ENABLED";
    protected static final String HIT_COUNT = "HIT_COUNT";
    protected static final String HIT_COUNT_ENABLED = "HIT_COUNT_ENABLED";
    protected HashMap fProperties = new HashMap(9);
    private boolean fIsDirty = false;
    private ListenerList fListeners = new ListenerList();

    protected COBOLBreakpointPreferenceStore() {
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.add((Object)iPropertyChangeListener);
    }

    public boolean contains(String string) {
        return this.fProperties.containsKey(string);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.fListeners.getListeners();
        if (!(objectArray.length <= 0 || object != null && object.equals(object2))) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
            int n = 0;
            while (n < objectArray.length) {
                IPropertyChangeListener iPropertyChangeListener = (IPropertyChangeListener)objectArray[n];
                iPropertyChangeListener.propertyChange(propertyChangeEvent);
                ++n;
            }
        }
    }

    public boolean getBoolean(String string) {
        Object v = this.fProperties.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return false;
    }

    public boolean getDefaultBoolean(String string) {
        return false;
    }

    public double getDefaultDouble(String string) {
        return 0.0;
    }

    public float getDefaultFloat(String string) {
        return 0.0f;
    }

    public int getDefaultInt(String string) {
        return 0;
    }

    public long getDefaultLong(String string) {
        return 0L;
    }

    public String getDefaultString(String string) {
        return null;
    }

    public double getDouble(String string) {
        return 0.0;
    }

    public float getFloat(String string) {
        return 0.0f;
    }

    public int getInt(String string) {
        Object v = this.fProperties.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return 1;
    }

    public long getLong(String string) {
        return 0L;
    }

    public String getString(String string) {
        Object v = this.fProperties.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public boolean isDefault(String string) {
        return false;
    }

    public boolean needsSaving() {
        return this.fIsDirty;
    }

    public void putValue(String string, String string2) {
        Object v = this.fProperties.get(string);
        if (v == null || !v.equals(string2)) {
            this.fProperties.put(string, string2);
            this.setDirty(true);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.remove((Object)iPropertyChangeListener);
    }

    public void setDefault(String string, boolean bl) {
    }

    public void setDefault(String string, double d) {
    }

    public void setDefault(String string, float f) {
    }

    public void setDefault(String string, int n) {
    }

    public void setDefault(String string, long l) {
    }

    public void setDefault(String string, String string2) {
    }

    public void setToDefault(String string) {
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl2 != bl) {
            this.fProperties.put(string, new Boolean(bl));
            this.setDirty(true);
            this.firePropertyChangeEvent(string, new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setValue(String string, double d) {
    }

    public void setValue(String string, float f) {
    }

    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n2 != n) {
            this.fProperties.put(string, new Integer(n));
            this.setDirty(true);
            this.firePropertyChangeEvent(string, new Integer(n2), new Integer(n));
        }
    }

    public void setValue(String string, long l) {
    }

    public void setValue(String string, String string2) {
        Object v = this.fProperties.get(string);
        if (v == null || !v.equals(string2)) {
            this.fProperties.put(string, string2);
            this.setDirty(true);
            this.firePropertyChangeEvent(string, v, string2);
        }
    }

    protected void setDirty(boolean bl) {
        this.fIsDirty = bl;
    }
}

