/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLHitCountBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.actions.BreakpointLabelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class COBOLBreakpointPreferencePage
extends FieldEditorPreferencePage {
    private Text fHitCountTextControl;
    private BooleanFieldEditor fHitCountEnabler;
    private BreakpointIntegerFieldEditor fHitCount;
    private ICOBOLBreakpoint fBreakpoint;
    protected BreakpointLabelProvider fCOBOLLabelProvider = new BreakpointLabelProvider();

    protected COBOLBreakpointPreferencePage(ICOBOLBreakpoint iCOBOLBreakpoint) {
        super(1);
        this.setBreakpoint(iCOBOLBreakpoint);
    }

    protected void initialize() {
        super.initialize();
        this.fHitCountEnabler.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = COBOLBreakpointPreferencePage.this.fHitCountEnabler.getBooleanValue();
                COBOLBreakpointPreferencePage.this.fHitCountTextControl.setEnabled(bl);
                COBOLBreakpointPreferencePage.this.fHitCount.refreshValidState();
                COBOLBreakpointPreferencePage.this.checkState();
            }
        });
    }

    protected void createFieldEditors() {
        ILineBreakpoint iLineBreakpoint;
        ICOBOLBreakpoint iCOBOLBreakpoint = this.getBreakpoint();
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), " ", " "));
        try {
            this.createTypeSpecificLabelFieldEditors(iCOBOLBreakpoint);
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
        if (iCOBOLBreakpoint instanceof ILineBreakpoint) {
            iLineBreakpoint = (ILineBreakpoint)iCOBOLBreakpoint;
            StringBuffer stringBuffer = new StringBuffer(4);
            try {
                int n = iLineBreakpoint.getLineNumber();
                if (n > 0) {
                    stringBuffer.append(n);
                }
            }
            catch (CoreException coreException) {
                COBOLDebugUIPlugin.logError(coreException);
            }
            if (stringBuffer.length() > 0) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), " ", " "));
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.getString((String)"COBOLBreakpointPreferencePage.Line_Number"), stringBuffer.toString()));
            }
        }
        iLineBreakpoint = this.getPreferenceStore();
        try {
            iLineBreakpoint.setValue("ENABLED", iCOBOLBreakpoint.isEnabled());
            int n = 1;
            if (iCOBOLBreakpoint instanceof ICOBOLHitCountBreakpoint) {
                n = ((ICOBOLHitCountBreakpoint)iCOBOLBreakpoint).getHitCount();
            }
            if (n > 0) {
                iLineBreakpoint.setValue("HIT_COUNT", n);
                iLineBreakpoint.setValue("HIT_COUNT_ENABLED", true);
            } else {
                iLineBreakpoint.setValue("HIT_COUNT_ENABLED", false);
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), " ", " "));
            this.addField(this.createEnabledEditor(this.getFieldEditorParent()));
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), " ", " "));
            this.createHitCountEditor(this.getFieldEditorParent());
            this.createTypeSpecificFieldEditors();
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
    }

    protected void createTypeSpecificLabelFieldEditors(ICOBOLBreakpoint iCOBOLBreakpoint) throws CoreException {
        if (iCOBOLBreakpoint instanceof ICOBOLLineBreakpoint) {
            String string = Messages.getString((String)"COBOLBreakpointPreferencePage.File_Path");
            String string2 = this.fCOBOLLabelProvider.getText(iCOBOLBreakpoint);
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), string, string2));
        }
    }

    protected void createTypeSpecificFieldEditors() throws CoreException {
        ICOBOLBreakpoint iCOBOLBreakpoint = this.getBreakpoint();
        if (iCOBOLBreakpoint instanceof ICOBOLLineBreakpoint) {
            this.setTitle(Messages.getString((String)"COBOLBreakpointPreferencePage.COBOL_Line_Breakpoint_Properties"));
        }
    }

    public void createControl(Composite composite) {
        super.createContents(composite);
        this.setControl((Control)this.getFieldEditorParent());
    }

    protected void createHitCountEditor(Composite composite) {
        this.fHitCountEnabler = new BooleanFieldEditor("HIT_COUNT_ENABLED", Messages.getString((String)"BreakpointHitCountAction.Enable_Hit_Count_1"), composite);
        this.addField((FieldEditor)this.fHitCountEnabler);
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), " ", " "));
        this.fHitCount = new BreakpointIntegerFieldEditor("HIT_COUNT", Messages.getString((String)"COBOLBreakpointPreferencePage.Hit_Count"), composite);
        this.fHitCount.setValidRange(1, Integer.MAX_VALUE);
        this.fHitCountTextControl = this.fHitCount.getTextControl(composite);
        try {
            ICOBOLBreakpoint iCOBOLBreakpoint = this.getBreakpoint();
            if (iCOBOLBreakpoint instanceof ICOBOLHitCountBreakpoint) {
                this.fHitCountTextControl.setEnabled(((ICOBOLHitCountBreakpoint)iCOBOLBreakpoint).getHitCount() > 0);
            }
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
        this.addField((FieldEditor)this.fHitCount);
    }

    protected FieldEditor createLabelEditor(Composite composite, String string, String string2) {
        return new LabelFieldEditor(composite, string, string2);
    }

    protected ICOBOLBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(ICOBOLBreakpoint iCOBOLBreakpoint) {
        this.fBreakpoint = iCOBOLBreakpoint;
    }

    protected FieldEditor createEnabledEditor(Composite composite) {
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor("ENABLED", Messages.getString((String)"COBOLBreakpointPreferencePage.Enabled"), composite);
        return booleanFieldEditor;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                if (this.fHitCount != null && propertyChangeEvent.getSource() != this.fHitCount) {
                    this.fHitCount.refreshValidState();
                }
                this.checkState();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
            this.setErrorMessage(Messages.getString((String)"BreakpointHitCountAction.Value_must_be_positive_integer"));
        }

        protected boolean checkState() {
            Text text = this.getTextControl();
            if (!text.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String string = this.getPreferencePage().getErrorMessage();
                if (string != null) {
                    if (this.getErrorMessage().equals(string)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
        }

        protected boolean checkState() {
            Text text = this.getTextControl();
            if (!text.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPreferencePage() != null) {
                String string = this.getPreferencePage().getErrorMessage();
                if (string != null) {
                    if (this.getErrorMessage().equals(string)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private Label fTitleLabel;
        private Label fValueLabel;
        private Composite fBasicComposite;
        private String fValue;
        private String fTitle;

        public LabelFieldEditor(Composite composite, String string, String string2) {
            this.fValue = string2;
            this.fTitle = string;
            this.createControl(composite);
        }

        protected void adjustForNumColumns(int n) {
            ((GridData)this.fBasicComposite.getLayoutData()).horizontalSpan = n;
        }

        protected void doFillIntoGrid(Composite composite, int n) {
            this.fBasicComposite = new Composite(composite, 0);
            this.fBasicComposite.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.numColumns = 2;
            this.fBasicComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.horizontalAlignment = 4;
            this.fBasicComposite.setLayoutData((Object)gridData);
            this.fTitleLabel = new Label(this.fBasicComposite, 0);
            this.fTitleLabel.setFont(this.fBasicComposite.getFont());
            this.fTitleLabel.setText(this.fTitle);
            GridData gridData2 = new GridData();
            gridData2.verticalAlignment = 128;
            this.fTitleLabel.setLayoutData((Object)gridData2);
            this.fValueLabel = new Label(this.fBasicComposite, 64);
            this.fValueLabel.setFont(this.fBasicComposite.getFont());
            this.fValueLabel.setText(this.fValue);
            gridData2 = new GridData();
            this.fValueLabel.setLayoutData((Object)gridData2);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

