/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.Iterator;
import org.eclipse.cobol.core.debug.model.ICOBOLHitCountBreakpoint;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.ICOBOLDebugHelpContextID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class COBOLBreakpointHitCountAction
implements IObjectActionDelegate {
    private static final String INITIAL_VALUE = "1";

    public void run(IAction iAction) {
        IStructuredSelection iStructuredSelection = this.getCurrentSelection();
        if (iStructuredSelection == null) {
            return;
        }
        Iterator iterator = iStructuredSelection.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ICOBOLHitCountBreakpoint iCOBOLHitCountBreakpoint = null;
        while (iterator.hasNext()) {
            iCOBOLHitCountBreakpoint = (ICOBOLHitCountBreakpoint)iterator.next();
            if (iCOBOLHitCountBreakpoint == null) continue;
            try {
                int n = iCOBOLHitCountBreakpoint.getHitCount();
                int n2 = this.hitCountDialog(iCOBOLHitCountBreakpoint);
                if (n2 == -1) continue;
                if (n == n2 && n2 == 0) {
                    return;
                }
                iCOBOLHitCountBreakpoint.setHitCount(n2);
            }
            catch (CoreException coreException) {
                MessageDialog.openError((Shell)new Shell(), (String)Messages.getString((String)"BreakpointHitCountError.label"), (String)Messages.getString((String)"BreakpointHitCountAction.Exception_occurred_attempting_to_set_hit_count"));
            }
        }
    }

    protected int hitCountDialog(ICOBOLHitCountBreakpoint iCOBOLHitCountBreakpoint) {
        String string = Messages.getString((String)"BreakpointHitCountAction.Set_Breakpoint_Hit_Count_2");
        String string2 = Messages.getString((String)"BreakpointHitCountAction.Enter_the_new_hit_count_for_the_breakpoint__3");
        IInputValidator iInputValidator = new IInputValidator(){
            int hitCount = -1;

            public String isValid(String string) {
                try {
                    this.hitCount = Integer.valueOf(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.hitCount = -1;
                }
                if (this.hitCount < 1) {
                    return Messages.getString((String)"BreakpointHitCountAction.Value_must_be_positive_integer");
                }
                return null;
            }
        };
        int n = 0;
        try {
            n = iCOBOLHitCountBreakpoint.getHitCount();
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
        String string3 = n > 0 ? Integer.toString(n) : INITIAL_VALUE;
        Shell shell = COBOLDebugUIPlugin.getActiveWorkbenchShell();
        HitCountDialog hitCountDialog = new HitCountDialog(shell, string, string2, string3, iInputValidator);
        if (hitCountDialog.open() != 0) {
            return -1;
        }
        if (hitCountDialog.isHitCountEnabled()) {
            return Integer.parseInt(hitCountDialog.getValue().trim());
        }
        return 0;
    }

    protected boolean isEnabledFor(Object object) {
        return object instanceof ICOBOLHitCountBreakpoint;
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.update(iAction, iWorkbenchPart);
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    protected void update(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        ISelection iSelection;
        ISelectionProvider iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider();
        boolean bl = false;
        if (iSelectionProvider != null && (iSelection = iSelectionProvider.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            bl = iStructuredSelection.size() == 1 && this.isEnabledFor(iStructuredSelection.getFirstElement());
        }
        iAction.setEnabled(bl);
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection iSelection;
        IWorkbenchPage iWorkbenchPage = COBOLDebugUIPlugin.getActivePage();
        if (iWorkbenchPage != null && (iSelection = iWorkbenchPage.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return null;
    }

    class HitCountDialog
    extends InputDialog {
        private Button fEnabledButton;
        private boolean fHitCountEnabled;

        protected HitCountDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
            super(shell, string, string2, string3, iInputValidator);
        }

        public boolean close() {
            this.setHitCountEnabled(this.getEnabledButton().getSelection());
            return super.close();
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Button button = new Button(composite2, 32);
            GridData gridData = new GridData(768);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            button.setLayoutData((Object)gridData);
            button.setFont(composite.getFont());
            button.setText(Messages.getString((String)"BreakpointHitCountAction.Enable_Hit_Count_1"));
            button.setSelection(true);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = HitCountDialog.this.getEnabledButton().getSelection();
                    HitCountDialog.this.getText().setEnabled(bl);
                    if (bl) {
                        HitCountDialog.this.validateInput();
                    } else {
                        HitCountDialog.this.getOkButton().setEnabled(true);
                        HitCountDialog.this.getErrorMessageLabel().setText("");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            this.setEnabledButton(button);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, ICOBOLDebugHelpContextID.HITCOUNT_DIALOG_CONTEXT_ID);
            return composite2;
        }

        protected Button getEnabledButton() {
            return this.fEnabledButton;
        }

        protected void setEnabledButton(Button button) {
            this.fEnabledButton = button;
        }

        protected boolean isHitCountEnabled() {
            return this.fHitCountEnabled;
        }

        protected void setHitCountEnabled(boolean bl) {
            this.fHitCountEnabled = bl;
        }
    }
}

