/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.ui.COBOLDebugImages;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.actions.COBOLDebugTargetStatus;
import org.eclipse.cobol.ui.editor.COBOLEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AddVariableAction
extends TextEditorAction
implements IEditorActionDelegate {
    private IAction fAction = null;

    public AddVariableAction() {
        super(Messages.getResourceBundle(), "AddVariableAction.", null);
        this.setImageDescriptor(COBOLDebugImages.DESC_OBJS_ADDWATCH_VAR);
        this.update();
    }

    public void run(IAction iAction) {
        this.setPluginAction(iAction);
        this.run();
    }

    public void run() {
        try {
            if (this.getTextEditor() != null) {
                IDocument iDocument;
                String string = null;
                ITextSelection iTextSelection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
                if (iTextSelection.getLength() != 0) {
                    string = iTextSelection.getText().trim();
                } else {
                    iDocument = ((COBOLEditor)this.getTextEditor()).getCurrentSourceViewer().getDocument();
                    int n = iTextSelection.getOffset();
                    string = this.getIdentifierText(iDocument, n);
                }
                iDocument = (IResource)this.getTextEditor().getEditorInput().getAdapter(IResource.class);
                StringBuffer stringBuffer = new StringBuffer();
                int n = iTextSelection.getStartLine();
                if (iDocument instanceof IFile) {
                    stringBuffer.append(((IFile)iDocument).getProjectRelativePath().toOSString());
                }
                COBOLDebugPlugin.getCOBOLVariableManager().addVariable(string, stringBuffer.toString(), n, false);
                this.addWatchExpression(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        catch (BadLocationException badLocationException) {}
    }

    protected IAction getPluginAction() {
        return this.fAction;
    }

    protected void setPluginAction(IAction iAction) {
        this.fAction = iAction;
    }

    public void update() {
        IAction iAction = this.getPluginAction();
        if (iAction != null) {
            try {
                IDebugTarget iDebugTarget = COBOLDebugTargetStatus.getContext();
                iAction.setEnabled(iDebugTarget != null && !iDebugTarget.isTerminated() && iDebugTarget.isSuspended());
            }
            catch (DebugException debugException) {
                iAction.setEnabled(false);
                COBOLDebugUIPlugin.logError(debugException);
            }
            catch (NullPointerException nullPointerException) {
                iAction.setEnabled(false);
                COBOLDebugUIPlugin.logError(nullPointerException);
            }
        }
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditor) {
            this.setEditor((ITextEditor)iEditorPart);
        }
        this.setPluginAction(iAction);
        this.update();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setPluginAction(iAction);
        this.update();
    }

    public void showView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage iWorkbenchPage;
                IWorkbenchWindow iWorkbenchWindow = COBOLDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                    try {
                        IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.cobol.debug.ui.COBOLWatchView");
                        if (iViewPart == null) {
                            IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                            iWorkbenchPage.showView("org.eclipse.cobol.debug.ui.COBOLWatchView");
                            iWorkbenchPage.activate(iWorkbenchPart);
                        } else {
                            iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
                        }
                    }
                    catch (PartInitException partInitException) {
                        COBOLDebugUIPlugin.logError(partInitException);
                    }
                }
            }
        });
    }

    private String getIdentifierText(IDocument iDocument, int n) throws BadLocationException {
        String string = null;
        String string2 = Messages.getString((String)"COBOL_identifier_delimiters");
        int n2 = 0;
        int n3 = n;
        while (string2.indexOf(iDocument.getChar(n3)) == -1) {
            --n3;
            ++n2;
        }
        while (string2.indexOf(iDocument.getChar(n)) == -1) {
            ++n;
            ++n2;
        }
        string = iDocument.get(n3 + 1, n2 - 1).trim();
        return string;
    }

    public void addWatchExpression(String string) {
        IWatchExpression iWatchExpression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(string);
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)iWatchExpression);
        IDebugElement iDebugElement = null;
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable instanceof IDebugElement) {
            iDebugElement = (IDebugElement)iAdaptable;
        } else if (iAdaptable instanceof ILaunch) {
            iDebugElement = ((ILaunch)iAdaptable).getDebugTarget();
        }
        iWatchExpression.setExpressionContext(iDebugElement);
        this.showExpressionsView();
    }

    private void showExpressionsView() {
        IWorkbenchPage iWorkbenchPage = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.debug.ui.ExpressionView");
        if (iViewPart == null) {
            try {
                iWorkbenchPage.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        } else {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
        }
    }
}

