/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui.actions;

import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IBreakpoint fBreakpoint;

    protected IBreakpoint determineBreakpoint() {
        IBreakpointManager iBreakpointManager = null;
        IBreakpoint[] iBreakpointArray = null;
        try {
            iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            iBreakpointArray = iBreakpointManager.getBreakpoints();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return null;
        }
        int n = 0;
        while (n < iBreakpointArray.length) {
            block7: {
                IBreakpoint iBreakpoint = iBreakpointArray[n];
                if (iBreakpoint instanceof ICOBOLLineBreakpoint) {
                    IResource iResource;
                    IResource iResource2;
                    ICOBOLLineBreakpoint iCOBOLLineBreakpoint = (ICOBOLLineBreakpoint)iBreakpoint;
                    boolean bl = false;
                    try {
                        bl = this.breakpointAtRulerLine(iCOBOLLineBreakpoint);
                    }
                    catch (CoreException coreException) {
                        COBOLDebugUIPlugin.logError(coreException);
                        break block7;
                    }
                    if (bl && (iResource2 = iCOBOLLineBreakpoint.getMarker().getResource()).equals((Object)(iResource = this.getResource()))) {
                        return iBreakpoint;
                    }
                }
            }
            ++n;
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo iVerticalRulerInfo) {
        this.fInfo = iVerticalRulerInfo;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
    }

    protected IResource getResource() {
        try {
            IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
            IResource iResource = (IResource)iEditorInput.getAdapter(IFile.class);
            if (iResource == null) {
                iResource = (IResource)iEditorInput.getAdapter(IResource.class);
            }
            return iResource;
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return null;
        }
    }

    protected boolean breakpointAtRulerLine(ICOBOLLineBreakpoint iCOBOLLineBreakpoint) throws CoreException {
        int n;
        int n2;
        IDocumentProvider iDocumentProvider;
        IDocument iDocument;
        IAnnotationModel iAnnotationModel;
        int n3 = 0;
        try {
            n3 = iCOBOLLineBreakpoint.getLineNumber();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return false;
        }
        if (this.fTextEditor.isDirty() && (iAnnotationModel = this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)this.fTextEditor.getEditorInput())) != null && iAnnotationModel instanceof AbstractMarkerAnnotationModel && (iDocument = (iDocumentProvider = (AbstractMarkerAnnotationModel)iAnnotationModel).getMarkerPosition(iCOBOLLineBreakpoint.getMarker())) != null && !iDocument.isDeleted()) {
            int n4 = iDocument.getOffset();
            int n5 = n3;
            IDocument iDocument2 = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
            try {
                n3 = iDocument2.getLineOfOffset(n4) + 1;
            }
            catch (BadLocationException badLocationException) {
                n3 = n5;
            }
        }
        if (n3 == -1 && (n2 = iCOBOLLineBreakpoint.getCharStart()) != -1) {
            iDocumentProvider = this.fTextEditor.getDocumentProvider();
            iDocument = iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
            try {
                n3 = iDocument.getLineOfOffset(iCOBOLLineBreakpoint.getCharStart()) + 1;
            }
            catch (BadLocationException badLocationException) {
                COBOLDebugUIPlugin.logError(badLocationException);
            }
        }
        return (n = this.getInfo().getLineOfLastMouseButtonActivity()) + 1 == n3;
    }

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint iBreakpoint) {
        this.fBreakpoint = iBreakpoint;
    }
}

