/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cobol.core.ui.projectmanagement.COBOLProjectNature;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class COBOLProjectConfigurationDialog
extends Dialog {
    private final int LAYOUT_COLUMNS = 2;
    protected TableViewer fElementsList;
    protected Text fPatternText;
    protected Object[] fFilteredElements;
    protected IProject fProject;
    protected IProject[] fSelProjects = new IProject[0];
    protected boolean fAllowMultipleSelection = false;
    protected ArrayList fAlreadyAddedProjects = new ArrayList();

    public COBOLProjectConfigurationDialog(Shell shell) {
        this(shell, false);
    }

    public COBOLProjectConfigurationDialog(Shell shell, boolean bl) {
        super(shell);
        this.fAllowMultipleSelection = bl;
    }

    public COBOLProjectConfigurationDialog(Shell shell, boolean bl, ArrayList arrayList) {
        super(shell);
        this.fAllowMultipleSelection = bl;
        this.fAlreadyAddedProjects = arrayList;
    }

    public Control createDialogArea(Composite composite) {
        Composite composite2 = null;
        try {
            this.getShell().setText(Messages.getString((String)"ProjectSelection"));
            composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 10;
            gridLayout.marginHeight = 10;
            composite2.setLayoutData((Object)new GridData(768));
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setFont(composite2.getFont());
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(Messages.getString((String)"ChooseAProject"));
            this.fPatternText = new Text(composite2, 2048);
            this.fPatternText.setFont(composite2.getFont());
            GridData gridData2 = new GridData(768);
            gridData2.horizontalSpan = 2;
            gridData2.grabExcessHorizontalSpace = true;
            this.fPatternText.setLayoutData((Object)gridData2);
            int n = -1;
            n = this.fAllowMultipleSelection ? 2818 : 2820;
            this.fElementsList = new TableViewer(composite2, n);
            this.fElementsList.getControl().setFont(composite2.getFont());
            Table table = this.fElementsList.getTable();
            GridData gridData3 = new GridData(272);
            gridData3.heightHint = 200;
            gridData3.widthHint = 250;
            gridData3.grabExcessVerticalSpace = true;
            gridData3.grabExcessHorizontalSpace = true;
            gridData3.horizontalSpan = 2;
            table.setLayoutData((Object)gridData3);
            this.fElementsList.setContentProvider((IContentProvider)new ElementsContentProvider());
            this.fElementsList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.fElementsList.setSorter((ViewerSorter)new SimpleSorter());
            final PatternFilter patternFilter = new PatternFilter();
            this.fElementsList.addFilter((ViewerFilter)patternFilter);
            this.fPatternText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    patternFilter.setPattern(((Text)modifyEvent.widget).getText());
                    COBOLProjectConfigurationDialog.this.fElementsList.refresh();
                    if (COBOLProjectConfigurationDialog.this.fFilteredElements.length >= 1) {
                        COBOLProjectConfigurationDialog.this.fElementsList.setSelection((ISelection)new StructuredSelection(COBOLProjectConfigurationDialog.this.fFilteredElements[0]), true);
                    }
                    COBOLProjectConfigurationDialog.this.updateOKbuttonStatus();
                }
            });
            this.fElementsList.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent doubleClickEvent) {
                    COBOLProjectConfigurationDialog.this.buttonPressed(0);
                }
            });
            this.fElementsList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    IStructuredSelection iStructuredSelection = null;
                    if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                        iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    }
                    if (iStructuredSelection != null && COBOLProjectConfigurationDialog.this.fAllowMultipleSelection) {
                        List list = iStructuredSelection.toList();
                        COBOLProjectConfigurationDialog.this.fSelProjects = list.toArray(new IProject[list.size()]);
                    } else if (iStructuredSelection != null) {
                        COBOLProjectConfigurationDialog.this.fProject = (IProject)iStructuredSelection.getFirstElement();
                    } else {
                        COBOLProjectConfigurationDialog.this.fProject = null;
                        COBOLProjectConfigurationDialog.this.fSelProjects = new IProject[0];
                    }
                    COBOLProjectConfigurationDialog.this.updateOKbuttonStatus();
                }
            });
            this.fElementsList.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            if (this.fElementsList.getTable().getItemCount() > 0) {
                this.fElementsList.getTable().select(0);
                ISelection iSelection = this.fElementsList.getSelection();
                if (iSelection != null && iSelection instanceof IStructuredSelection) {
                    if (this.fAllowMultipleSelection) {
                        List list = ((IStructuredSelection)iSelection).toList();
                        this.fSelProjects = list.toArray(new IProject[list.size()]);
                    } else {
                        this.fProject = (IProject)((IStructuredSelection)iSelection).getFirstElement();
                    }
                }
            }
            this.updateOKbuttonStatus();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return composite2;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void updateOKbuttonStatus() {
        ISelection iSelection = this.fElementsList.getSelection();
        if (this.fElementsList.getTable().getItemCount() == 0 || iSelection != null && iSelection.isEmpty()) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IProject[] getSelectedProjects() {
        if (this.fSelProjects == null) {
            return new IProject[0];
        }
        return this.fSelProjects;
    }

    private class ElementsContentProvider
    implements IStructuredContentProvider {
        protected IWorkspaceRoot fWorkspaceRoot;

        private ElementsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.fWorkspaceRoot = (IWorkspaceRoot)object2;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (this.fWorkspaceRoot != null) {
                IProject[] iProjectArray = this.fWorkspaceRoot.getProjects();
                ArrayList<IProject> arrayList = new ArrayList<IProject>();
                String[] stringArray = null;
                int n = 0;
                while (n < iProjectArray.length) {
                    block6: {
                        try {
                            stringArray = iProjectArray[n].getDescription().getNatureIds();
                            if (stringArray == null || stringArray.length <= 0 || !(iProjectArray[n].getNature(stringArray[0]) instanceof COBOLProjectNature)) break block6;
                            int n2 = 0;
                            while (n2 < COBOLProjectConfigurationDialog.this.fAlreadyAddedProjects.size()) {
                                if (!iProjectArray[n].equals((Object)COBOLDebugUtil.getProjectFromName((String)((String)COBOLProjectConfigurationDialog.this.fAlreadyAddedProjects.get(n2))))) {
                                    ++n2;
                                    continue;
                                }
                                break block6;
                            }
                            arrayList.add(iProjectArray[n]);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n;
                }
                arrayList.trimToSize();
                return arrayList.toArray(new IProject[arrayList.size()]);
            }
            return new Object[0];
        }
    }

    private class PatternFilter
    extends ViewerFilter {
        protected StringMatcher fMatcher = null;

        private PatternFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (this.fMatcher == null) {
                return true;
            }
            ILabelProvider iLabelProvider = (ILabelProvider)COBOLProjectConfigurationDialog.this.fElementsList.getLabelProvider();
            return this.fMatcher.match(iLabelProvider.getText(object2));
        }

        public void setPattern(String string) {
            this.fMatcher = new StringMatcher(String.valueOf(string) + "*", true, false);
        }

        public Object[] filter(Viewer viewer, Object object, Object[] objectArray) {
            COBOLProjectConfigurationDialog.this.fFilteredElements = super.filter(viewer, object, objectArray);
            return COBOLProjectConfigurationDialog.this.fFilteredElements;
        }
    }

    private class SimpleSorter
    extends ViewerSorter {
        private SimpleSorter() {
        }

        public boolean isSorterProperty(Object object, Object object2) {
            return true;
        }
    }
}

