/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import org.eclipse.cobol.core.common.ICOBOLDebugModel;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugElement;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLStackframe;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class COBOLLaunchViewSelectionListener
implements ISelectionListener {
    private static COBOLLaunchViewSelectionListener fCOBOLLaunchViewSelectionListener;

    public COBOLLaunchViewSelectionListener() {
        fCOBOLLaunchViewSelectionListener = this;
        this.addSelectionListener();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.setActiveDebugElements((IStructuredSelection)iSelection);
        }
    }

    public void addSelectionListener() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart iViewPart;
                IWorkbenchPage iWorkbenchPage;
                IWorkbenchWindow iWorkbenchWindow;
                if (DebugUIPlugin.getDefault() != null && (iWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow()) != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.debug.ui.DebugView")) != null && iViewPart.getSite() != null && iViewPart.getSite().getPage() != null) {
                    iViewPart.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)fCOBOLLaunchViewSelectionListener);
                }
            }
        });
    }

    protected void setActiveDebugElements(IStructuredSelection iStructuredSelection) {
        ICOBOLStackframe iCOBOLStackframe = null;
        ICOBOLThread iCOBOLThread = null;
        ICOBOLDebugTarget iCOBOLDebugTarget = null;
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ICOBOLDebugElement) {
                if (object instanceof ICOBOLStackframe) {
                    iCOBOLStackframe = (ICOBOLStackframe)object;
                    iCOBOLDebugTarget = iCOBOLStackframe.getCOBOLDebugTarget();
                    iCOBOLThread = iCOBOLStackframe.getCOBOLThread();
                    this.setDebugModelElements(iCOBOLDebugTarget, iCOBOLThread, iCOBOLStackframe);
                    return;
                }
                if (object instanceof ICOBOLThread) {
                    iCOBOLThread = (ICOBOLThread)object;
                    iCOBOLDebugTarget = (ICOBOLDebugTarget)iCOBOLThread.getDebugTarget();
                    try {
                        iCOBOLStackframe = (ICOBOLStackframe)iCOBOLThread.getTopStackFrame();
                    }
                    catch (DebugException debugException) {
                        iCOBOLStackframe = null;
                    }
                    this.setDebugModelElements(iCOBOLDebugTarget, iCOBOLThread, iCOBOLStackframe);
                    return;
                }
                if (object instanceof ICOBOLDebugTarget) {
                    this.setDebugModelElements((ICOBOLDebugTarget)object, null, null);
                    return;
                }
            }
            this.setDebugModelElements(null, null, null);
        }
    }

    protected void setDebugModelElements(ICOBOLDebugTarget iCOBOLDebugTarget, ICOBOLThread iCOBOLThread, ICOBOLStackframe iCOBOLStackframe) {
        ICOBOLDebugModel iCOBOLDebugModel;
        if (iCOBOLDebugTarget != null && (iCOBOLDebugModel = COBOLDebugPlugin.getDefault().getCOBOLLaunchManager().getDebugModel(iCOBOLDebugTarget.getLaunch())) != null) {
            iCOBOLDebugModel.setActiveDebugTarget((IDebugTarget)iCOBOLDebugTarget);
            iCOBOLDebugModel.setActiveThread((IThread)iCOBOLThread);
            iCOBOLDebugModel.setActiveStackframe((IStackFrame)iCOBOLStackframe);
        }
    }

    public COBOLLaunchViewSelectionListener getLaunchViewSelectorListener() {
        return fCOBOLLaunchViewSelectionListener;
    }

    public void shutdown() {
        this.removeSelectionListener();
        fCOBOLLaunchViewSelectionListener = null;
    }

    public void removeSelectionListener() {
        if (COBOLDebugUIPlugin.getDefault() != null) {
            IViewPart iViewPart;
            IWorkbenchPage iWorkbenchPage;
            if (COBOLDebugUIPlugin.getDefault().getWorkbench().isClosing()) {
                return;
            }
            IWorkbenchWindow iWorkbenchWindow = COBOLDebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iViewPart = iWorkbenchPage.findView("org.eclipse.debug.ui.DebugView")) != null && iViewPart.getSite() != null && iViewPart.getSite().getPage() != null) {
                iViewPart.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            }
        }
    }
}

