/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.cobol.core.ui.common.StatusDialog;
import org.eclipse.cobol.core.ui.common.StatusInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class COBOLFileSelectionDialog
extends StatusDialog {
    private ArrayList fInputList;
    private List fElementList;
    private Label fLabel;
    private Object fSelectedFile;
    private StatusInfo fStatusInfo = null;

    public COBOLFileSelectionDialog(Shell shell) {
        super(shell);
    }

    public COBOLFileSelectionDialog(Shell shell, String string, ArrayList arrayList) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fInputList = arrayList;
        this.setTitle(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.fLabel = new Label(composite2, 0);
        this.fLabel.setText(Messages.getString((String)"COBOLFileSelectionDialog.message.label"));
        this.fElementList = new List(composite2, 2820);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 150;
        this.fElementList.setLayoutData((Object)gridData);
        if (this.fInputList != null && this.fInputList.size() > 0) {
            this.populateFileNamesIntoList(this.fInputList);
            if (this.fElementList.getItemCount() > 0) {
                this.fElementList.setSelection(0);
            }
        }
        this.fElementList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                COBOLFileSelectionDialog.this.updateOK();
            }
        });
        this.fStatusInfo = new StatusInfo();
        this.updateOK();
        return composite2;
    }

    private void populateFileNamesIntoList(ArrayList arrayList) {
        Object var2_2 = null;
        int n = arrayList.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            var2_2 = arrayList.get(n2);
            if (var2_2 instanceof File) {
                stringArray[n2] = ((File)var2_2).getAbsolutePath();
            } else if (var2_2 instanceof IFile) {
                stringArray[n2] = ((IFile)var2_2).getLocation().toOSString();
            }
            this.fElementList.add(stringArray[n2]);
            ++n2;
        }
    }

    private void updateOK() {
        if (this.fElementList.getSelectionCount() == 1) {
            this.fStatusInfo.setOK();
        } else {
            this.fStatusInfo.setError("");
        }
        this.updateStatus((IStatus)this.fStatusInfo);
    }

    protected void okPressed() {
        this.fSelectedFile = this.fInputList.get(this.fElementList.getSelectionIndex());
        super.okPressed();
    }

    public Object getSelectedFile() {
        return this.fSelectedFile;
    }

    protected void setInputList(ArrayList arrayList) {
        this.fInputList = arrayList;
    }
}

