/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLEvent;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.internal.core.events.COBOLBreakpointEvent;
import org.eclipse.cobol.debug.internal.core.model.CBDIDebugTarget;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.launcher.COBOLSourceLookupBlock;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.RemoteFileEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class COBOLDebugUISourceLocator
implements ISourceLocator {
    private static final int INTERNAL_ERROR = 29;
    private IProject fDefaultProject;
    private IEditorPart fPrevOpenEditorPart = null;
    private ILaunchConfiguration fLaunchConfiguration = null;
    private ArrayList fSrcLookupList = null;

    public COBOLDebugUISourceLocator(IProject iProject) throws DebugException {
        if (iProject == null) {
            this.throwDebugException();
        }
        this.fDefaultProject = iProject;
    }

    public COBOLDebugUISourceLocator(IProject iProject, ILaunchConfiguration iLaunchConfiguration) throws DebugException {
        if (iLaunchConfiguration == null) {
            this.throwDebugException();
        }
        this.fLaunchConfiguration = iLaunchConfiguration;
        this.fDefaultProject = iProject;
        try {
            this.fSrcLookupList = (ArrayList)iLaunchConfiguration.getAttribute("SourceLookupList", null);
        }
        catch (CoreException coreException) {}
    }

    private void throwDebugException() throws DebugException {
        throw new DebugException((IStatus)new Status(4, COBOLDebugPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, "Internal Error in Cobol Debugger", (Throwable)new NullPointerException("NullPointerException in COBOLDebugUISourceLocator")));
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        Object object;
        block30: {
            IWorkbenchPage iWorkbenchPage;
            block29: {
                String string;
                block28: {
                    if (iStackFrame == null) {
                        return null;
                    }
                    string = null;
                    object = null;
                    string = iStackFrame.getName();
                    if (string != null && string.length() != 0) break block28;
                    return null;
                }
                IWorkbench iWorkbench = COBOLDebugPlugin.getDefault().getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                iWorkbenchPage = iWorkbenchWindow != null ? iWorkbenchWindow.getActivePage() : null;
                object = this.findSourceElement(string);
                if (object != null) break block29;
                this.showDebugSourceLookupDialog(iStackFrame);
                object = this.findSourceElement(string);
                if (object != null) break block29;
                IFile iFile = this.fDefaultProject.getFile(string);
                if (iWorkbenchPage != null) {
                    this.fPrevOpenEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), Messages.getString((String)"DEFAULT_EDITOR_ID"));
                }
                return null;
            }
            try {
                try {
                    RemoteFile remoteFile;
                    if (iWorkbenchPage == null) break block30;
                    IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                    IEditorPart iEditorPart = null;
                    FileEditorInput fileEditorInput = null;
                    IFile iFile = null;
                    if (iEditorReferenceArray != null && iEditorReferenceArray.length > 0) {
                        int n = 0;
                        while (n < iEditorReferenceArray.length) {
                            iEditorPart = iEditorReferenceArray[n].getEditor(false);
                            if (iEditorPart != null && (fileEditorInput = iEditorPart.getEditorInput()) != null) {
                                if (fileEditorInput instanceof IFileEditorInput) {
                                    iFile = ((IFileEditorInput)fileEditorInput).getFile();
                                } else if (fileEditorInput instanceof RemoteFileEditorInput) {
                                    iFile = ((RemoteFileEditorInput)fileEditorInput).getFile();
                                }
                                if (iFile != null) {
                                    if (object instanceof IFile && iFile.equals((Object)((IFile)object))) {
                                        iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                                        return (IFile)object;
                                    }
                                    if (object instanceof File && (remoteFile = iFile.getLocation()) != null && ((File)object).equals(remoteFile.toFile())) {
                                        iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                                        return (File)object;
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                    if (this.fPrevOpenEditorPart != null) {
                        iWorkbenchPage.closeEditor(this.fPrevOpenEditorPart, false);
                    }
                    if (object instanceof IFile) {
                        if (!((IFile)object).exists()) {
                            fileEditorInput = new FileEditorInput((IFile)object);
                            this.fPrevOpenEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, Messages.getString((String)"DEFAULT_EDITOR_ID"));
                        } else {
                            this.fPrevOpenEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput((IFile)object), Messages.getString((String)"COBOL_EDITOR_ID"));
                        }
                        break block30;
                    }
                    if (!(object instanceof File)) break block30;
                    File file = (File)object;
                    remoteFile = null;
                    try {
                        remoteFile = new RemoteFile(file.getAbsolutePath());
                        fileEditorInput = new RemoteFileEditorInput(remoteFile);
                        this.fPrevOpenEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, Messages.getString((String)"COBOL_EDITOR_ID"));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        IFile iFile2 = this.fDefaultProject.getFile(file.getName());
                        this.fPrevOpenEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile2), Messages.getString((String)"DEFAULT_EDITOR_ID"));
                    }
                    catch (IOException iOException) {
                        COBOLDebugPlugin.logError((Exception)iOException);
                    }
                }
                catch (PartInitException partInitException) {
                    this.fPrevOpenEditorPart = null;
                    COBOLDebugPlugin.logError((Exception)((Object)partInitException));
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (PartInitException partInitException) {
                this.fPrevOpenEditorPart = null;
                COBOLDebugPlugin.logError((Exception)((Object)partInitException));
            }
            catch (DebugException debugException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                COBOLDebugPlugin.logError((Exception)illegalArgumentException);
            }
            catch (NullPointerException nullPointerException) {}
        }
        return object;
    }

    private Object findSourceElement(String string) {
        IFile iFile = null;
        if (this.fDefaultProject != null) {
            iFile = this.fDefaultProject.getFile(string);
            if (iFile != null && iFile.isAccessible()) {
                return iFile;
            }
            iFile = null;
        }
        if (this.fSrcLookupList == null || this.fSrcLookupList.size() == 0) {
            return null;
        }
        int n = this.fSrcLookupList.size();
        String string2 = null;
        IProject iProject = null;
        File file = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = (String)this.fSrcLookupList.get(n2);
            if (string2.endsWith("*1")) {
                iProject = COBOLDebugUtil.getProjectFromName((String)string2);
                if (iProject != null) {
                    iFile = iProject.getFile(string);
                    if (iFile != null && iFile.isAccessible()) {
                        return iFile;
                    }
                    iFile = null;
                }
            } else if (string2.endsWith("*2") && (file = COBOLDebugUtil.getExternalFolderFromName((String)string2)) != null) {
                ArrayList arrayList = new ArrayList();
                this.findFiles(file, arrayList, string);
                if (arrayList.size() != 0) {
                    return (File)arrayList.get(0);
                }
            }
            ++n2;
        }
        return null;
    }

    private void findFiles(File file, ArrayList arrayList, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile() && fileArray[n].getName().equalsIgnoreCase(string)) {
                    arrayList.add(fileArray[n]);
                } else if (fileArray[n].isDirectory()) {
                    this.findFiles(fileArray[n], arrayList, string);
                }
                ++n;
            }
        }
    }

    private void showDebugSourceLookupDialog(IStackFrame iStackFrame) {
        COBOLSourceLookupDialog cOBOLSourceLookupDialog = null;
        try {
            ArrayList arrayList = (ArrayList)this.fLaunchConfiguration.getAttribute("SourceLookupList", null);
            cOBOLSourceLookupDialog = new COBOLSourceLookupDialog(COBOLDebugUIPlugin.getActiveWorkbenchShell(), iStackFrame.getName(), iStackFrame.getLaunch().getLaunchConfiguration(), this);
            int n = cOBOLSourceLookupDialog.open();
            if (n == 0) {
                this.fSrcLookupList = (ArrayList)this.fLaunchConfiguration.getAttribute("SourceLookupList", null);
                if (this.fSrcLookupList != null && !this.fSrcLookupList.isEmpty()) {
                    for (String string : this.fSrcLookupList) {
                        if (!string.endsWith("*1") || arrayList.contains(string)) continue;
                        IProject iProject = COBOLDebugUtil.getProjectFromName((String)string);
                        this.fireBreakpointEvent(iStackFrame, iProject);
                    }
                }
            }
        }
        catch (DebugException debugException) {
            COBOLDebugUIPlugin.logError(debugException);
        }
        catch (CoreException coreException) {
        }
        catch (Exception exception) {}
    }

    public void fireBreakpointEvent(IStackFrame iStackFrame, IProject iProject) {
        CBDIDebugTarget cBDIDebugTarget = (CBDIDebugTarget)iStackFrame.getDebugTarget();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(COBOLDebugUtil.getPluginIdentifier());
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof ICOBOLBreakpoint) {
                IProject iProject2 = iBreakpointArray[n].getMarker().getResource().getProject();
                if (iProject != null && iProject.equals((Object)iProject2)) {
                    cBDIDebugTarget.addBreakPoint(iBreakpointArray[n]);
                    ((ICOBOLBreakpoint)iBreakpointArray[n]).setValid(true);
                    COBOLBreakpointEvent cOBOLBreakpointEvent = new COBOLBreakpointEvent((Object)cBDIDebugTarget, false, 0, (ICOBOLBreakpoint)iBreakpointArray[n], cBDIDebugTarget.getCOBOLBreakpointEventHandler());
                    COBOLDebugPlugin.getEventDispatcher((ILaunch)iStackFrame.getLaunch()).fireEvent((ICOBOLEvent)cOBOLBreakpointEvent);
                }
            }
            ++n;
        }
    }

    private static class COBOLSourceLookupDialog
    extends Dialog {
        private COBOLSourceLookupBlock fSourceLookupBlock = new COBOLSourceLookupBlock();
        private COBOLDebugUISourceLocator fLocator;
        private ILaunchConfiguration fConfiguration;
        private String fTypeName;

        public COBOLSourceLookupDialog(Shell shell, String string, ILaunchConfiguration iLaunchConfiguration, COBOLDebugUISourceLocator cOBOLDebugUISourceLocator) {
            super(shell);
            this.fTypeName = string;
            this.fLocator = cOBOLDebugUISourceLocator;
            this.fConfiguration = iLaunchConfiguration;
        }

        protected Control createDialogArea(Composite composite) {
            this.getShell().setText(Messages.getString((String)"COBOLDebugUISourceLocator.lookupdialog.title"));
            Composite composite2 = (Composite)super.createDialogArea(composite);
            composite2.setLayout((Layout)new GridLayout());
            Label label = new Label(composite2, 16448);
            label.setText(Messages.getString((String)"COBOLDebugUISourceLocator.message.label"));
            GridData gridData = new GridData();
            gridData.widthHint = this.convertWidthInCharsToPixels((Control)label, 70);
            label.setLayoutData((Object)gridData);
            this.fSourceLookupBlock.createControl(composite2);
            Control control = this.fSourceLookupBlock.getControl();
            this.fSourceLookupBlock.initializeFrom(this.fConfiguration);
            control.setLayoutData((Object)new GridData(1808));
            return composite2;
        }

        protected int convertWidthInCharsToPixels(Control control, int n) {
            GC gC = new GC((Drawable)control);
            gC.setFont(control.getFont());
            FontMetrics fontMetrics = gC.getFontMetrics();
            gC.dispose();
            return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)n);
        }

        protected void okPressed() {
            try {
                ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = this.fConfiguration.getWorkingCopy();
                this.fSourceLookupBlock.performApply(iLaunchConfigurationWorkingCopy);
                if (!this.fConfiguration.contentsEqual((ILaunchConfiguration)iLaunchConfigurationWorkingCopy)) {
                    this.fConfiguration = iLaunchConfigurationWorkingCopy.doSave();
                }
            }
            catch (CoreException coreException) {
                COBOLDebugUIPlugin.logError(coreException);
            }
            super.okPressed();
        }
    }
}

