/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import java.net.URL;
import org.eclipse.cobol.debug.ui.COBOLLaunchViewSelectionListener;
import org.eclipse.cobol.debug.ui.views.COBOLDebugPreferencePage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class COBOLDebugUIPlugin
extends AbstractUIPlugin
implements IStartup {
    private static COBOLLaunchViewSelectionListener fCOBOLLaunchViewSelectionListener = null;
    private static COBOLDebugUIPlugin plugin = null;
    public static final int INTERNAL_ERROR = 29;
    private boolean fTrace = true;

    public void earlyStartup() {
    }

    public COBOLDebugUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        fCOBOLLaunchViewSelectionListener = new COBOLLaunchViewSelectionListener();
    }

    public static String getPluginId() {
        try {
            return COBOLDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return "";
        }
    }

    public static COBOLDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        try {
            return COBOLDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static IWorkbenchPage getActivePage() {
        try {
            return COBOLDebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = COBOLDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        Shell[] shellArray = iWorkbenchWindow.getShell().getShells();
        if (shellArray != null && shellArray.length > 0) {
            return shellArray[shellArray.length - 1];
        }
        return iWorkbenchWindow.getShell();
    }

    public static void logError(Throwable throwable) {
        try {
            if (COBOLDebugUIPlugin.getDefault().isDebugging()) {
                DebugException debugException;
                IStatus iStatus;
                Throwable throwable2 = throwable;
                if (throwable instanceof DebugException && (iStatus = (debugException = (DebugException)throwable).getStatus()).getException() != null) {
                    throwable2 = iStatus.getException();
                }
                COBOLDebugUIPlugin.log((IStatus)new Status(4, COBOLDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, "Internal error logged from  Cobol Debug: ", throwable2));
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public static void logError(Exception exception, String string) {
        try {
            DebugException debugException;
            IStatus iStatus;
            Throwable throwable = exception;
            if (exception instanceof DebugException && (iStatus = (debugException = (DebugException)((Object)exception)).getStatus()).getException() != null) {
                throwable = iStatus.getException();
            }
            COBOLDebugUIPlugin.log((IStatus)new Status(4, COBOLDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, string, throwable));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public static void log(IStatus iStatus) {
        try {
            COBOLDebugUIPlugin.getDefault().getLog().log(iStatus);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public static void logTraceMessage(String string) {
        try {
            if (COBOLDebugUIPlugin.getDefault().isTrace()) {
                Status status = new Status(1, COBOLDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 29, string, null);
                COBOLDebugUIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void setTrace(boolean bl) {
        this.fTrace = bl;
    }

    public boolean isTrace() {
        return this.fTrace;
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        super.initializeDefaultPreferences(iPreferenceStore);
        COBOLDebugPreferencePage.initDefaults(iPreferenceStore);
    }

    public void shutdown() {
        fCOBOLLaunchViewSelectionListener.shutdown();
        fCOBOLLaunchViewSelectionListener = null;
    }

    public void setLaunchListener(COBOLLaunchViewSelectionListener cOBOLLaunchViewSelectionListener) {
        fCOBOLLaunchViewSelectionListener = cOBOLLaunchViewSelectionListener;
    }

    public COBOLLaunchViewSelectionListener getLaunchViewListener() {
        return fCOBOLLaunchViewSelectionListener;
    }

    public static String getPluginLocation() {
        String string = null;
        try {
            string = Platform.resolve((URL)COBOLDebugUIPlugin.getDefault().getDescriptor().getInstallURL()).getPath();
            if (string.startsWith("/") && Platform.getOS().equals("win32")) {
                string = string.substring(1);
                string = string.replace('/', '\\');
            }
        }
        catch (Exception exception) {}
        return string;
    }
}

