/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.cobol.core.debug.model.ICOBOLBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLDebugTarget;
import org.eclipse.cobol.core.debug.model.ICOBOLHitCountBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLLineBreakpoint;
import org.eclipse.cobol.core.debug.model.ICOBOLStackframe;
import org.eclipse.cobol.core.debug.model.ICOBOLThread;
import org.eclipse.cobol.core.debug.model.ICOBOLType;
import org.eclipse.cobol.core.debug.model.ICOBOLValue;
import org.eclipse.cobol.core.debug.model.ICOBOLVariable;
import org.eclipse.cobol.debug.core.COBOLDebugPlugin;
import org.eclipse.cobol.debug.internal.core.COBOLDebugUtil;
import org.eclipse.cobol.debug.internal.core.breakpoints.COBOLLineBreakpoint;
import org.eclipse.cobol.debug.ui.COBOLDebugImages;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.cobol.debug.ui.views.COBOLWatchView;
import org.eclipse.cobol.ui.views.common.RemoteFile;
import org.eclipse.cobol.ui.views.common.RemoteFileEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class COBOLDebugModelPresentation
implements IDebugModelPresentation {
    private boolean fHexaDecimal;
    private boolean fAscii;
    private boolean fShowType = false;
    private int[] fStringDataTypes = null;

    public COBOLDebugModelPresentation() {
        try {
            this.fStringDataTypes = COBOLDebugPlugin.getDefault().getStringDataTypes();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        if (iValueDetailListener == null) {
            return;
        }
        if (iValue != null) {
            try {
                if (iValue.getValueString() != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(Messages.getString((String)"Program_Name"));
                    stringBuffer.append(" : ");
                    if (iValue instanceof ICOBOLValue && ((ICOBOLValue)iValue).getProgramName() != null) {
                        stringBuffer.append(((ICOBOLValue)iValue).getProgramName());
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(Messages.getString((String)"Data_Type"));
                    stringBuffer.append(" : ");
                    if (iValue.getReferenceTypeName() != null) {
                        stringBuffer.append(iValue.getReferenceTypeName());
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(Messages.getString((String)"Value"));
                    stringBuffer.append(" : ");
                    stringBuffer.append(this.getValueText(iValue));
                    stringBuffer.append("\n");
                    stringBuffer.append(Messages.getString((String)"Interrupt_Status"));
                    stringBuffer.append(" : ");
                    stringBuffer.append(this.getInterruptStatus(iValueDetailListener));
                    iValueDetailListener.detailComputed(iValue, stringBuffer.toString());
                    return;
                }
            }
            catch (DebugException debugException) {
                COBOLDebugUIPlugin.logError(debugException);
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugUIPlugin.logError(nullPointerException);
            }
        }
        iValueDetailListener.detailComputed(iValue, "null");
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        try {
            IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(iEditorInput.getName());
            if (iEditorDescriptor != null) {
                return iEditorDescriptor.getId();
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    public IEditorInput getEditorInput(Object object) {
        if (object instanceof ICOBOLBreakpoint) {
            ICOBOLBreakpoint iCOBOLBreakpoint = (ICOBOLBreakpoint)object;
            IResource iResource = iCOBOLBreakpoint.getMarker().getResource();
            return new FileEditorInput((IFile)iResource);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof File) {
            RemoteFileEditorInput remoteFileEditorInput = null;
            RemoteFile remoteFile = null;
            try {
                remoteFile = new RemoteFile(((File)object).getAbsolutePath());
                remoteFileEditorInput = new RemoteFileEditorInput(remoteFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                COBOLDebugUIPlugin.logError(iOException);
            }
            return remoteFileEditorInput;
        }
        return null;
    }

    public Image getImage(Object object) {
        try {
            IBreakpoint iBreakpoint;
            if (object instanceof IMarker && (iBreakpoint = this.getBreakpoint((IMarker)object)) != null && iBreakpoint instanceof IBreakpoint) {
                return this.getBreakpointImage(iBreakpoint);
            }
            if (object instanceof IBreakpoint) {
                return this.getBreakpointImage((IBreakpoint)object);
            }
            if (object instanceof IVariable) {
                return this.getVariableImage((IVariable)object);
            }
            if (object instanceof ICOBOLDebugTarget) {
                return this.getCobolDebugTargetImage((ICOBOLDebugTarget)object);
            }
            if (object instanceof ICOBOLThread) {
                return this.getCobolThreadImage((ICOBOLThread)object);
            }
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
        }
        return null;
    }

    protected Image getBreakpointImage(IBreakpoint iBreakpoint) throws CoreException {
        try {
            if (iBreakpoint instanceof ICOBOLLineBreakpoint) {
                return this.getCobolBreakpointImage((IBreakpoint)((ICOBOLLineBreakpoint)iBreakpoint));
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    protected Image getCobolDebugTargetImage(ICOBOLDebugTarget iCOBOLDebugTarget) throws CoreException {
        try {
            if (!iCOBOLDebugTarget.isSuspended()) {
                return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_DEBUG_TARGET_SUSPEND);
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    protected Image getCobolThreadImage(ICOBOLThread iCOBOLThread) throws CoreException {
        try {
            if (iCOBOLThread.isCurrentThread()) {
                if (iCOBOLThread.isSuspended()) {
                    return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_DEFAULT_THREAD_SUSPEND);
                }
                if (iCOBOLThread.getThreadStatus() > 1) {
                    return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_DEFAULT_THREAD_TERMINATE);
                }
                if (!iCOBOLThread.isSuspended()) {
                    return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_DEFAULT_THREAD_RESUME);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    protected Image getCobolBreakpointImage(IBreakpoint iBreakpoint) throws CoreException {
        try {
            if (!iBreakpoint.isEnabled()) {
                return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_BREAKPOINT_DISABLED);
            }
            return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_BREAKPOINT_INSTALLED);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return null;
        }
    }

    public String getText(Object object) {
        block10: {
            this.fHexaDecimal = COBOLDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.cobol.debug.ui.hexadecimal");
            this.fAscii = COBOLDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.cobol.debug.ui.ascii");
            if (!(object instanceof IMarker)) break block10;
            IBreakpoint iBreakpoint = this.getBreakpoint((IMarker)object);
            if (iBreakpoint != null) {
                return this.getBreakpointText(iBreakpoint);
            }
            return null;
        }
        try {
            if (object instanceof IBreakpoint) {
                return this.getBreakpointText((IBreakpoint)object);
            }
            if (object instanceof ICOBOLVariable) {
                return this.getVariableText((IVariable)object);
            }
            if (object instanceof ICOBOLValue) {
                return this.getValueText((IValue)object);
            }
            if (object instanceof IStackFrame) {
                return this.getStackFrameText((IStackFrame)object);
            }
            if (object instanceof IThread) {
                return this.getThreadText((IThread)object);
            }
        }
        catch (CoreException coreException) {
            COBOLDebugUIPlugin.logError(coreException);
            return "";
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return "";
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        try {
            if (string.equals("org.eclipse.debug.ui.displayVariableTypeNames")) {
                this.fShowType = (Boolean)object;
            }
        }
        catch (ClassCastException classCastException) {
            COBOLDebugUIPlugin.logError(classCastException);
        }
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
        if (this.fStringDataTypes != null) {
            this.fStringDataTypes = null;
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    protected IBreakpoint getBreakpoint(IMarker iMarker) {
        try {
            return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(iMarker);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return null;
        }
    }

    protected String getBreakpointText(IBreakpoint iBreakpoint) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        if (iBreakpoint instanceof ICOBOLBreakpoint) {
            if (iBreakpoint instanceof ICOBOLLineBreakpoint) {
                stringBuffer.append(this.getLineBreakpointText((ICOBOLLineBreakpoint)iBreakpoint));
            }
            if (iBreakpoint instanceof ICOBOLHitCountBreakpoint) {
                stringBuffer.append(this.getHitCountString((ICOBOLHitCountBreakpoint)iBreakpoint));
            }
        }
        return stringBuffer.toString();
    }

    protected String getLineBreakpointText(ICOBOLLineBreakpoint iCOBOLLineBreakpoint) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        if (iCOBOLLineBreakpoint instanceof COBOLLineBreakpoint) {
            try {
                int n;
                String string = ((COBOLLineBreakpoint)iCOBOLLineBreakpoint).getMarker().getResource().getFullPath().toOSString();
                if (string != null) {
                    stringBuffer.append(string);
                }
                if ((n = ((COBOLLineBreakpoint)iCOBOLLineBreakpoint).getLineNumber()) > 0) {
                    stringBuffer.append(" [");
                    stringBuffer.append(Messages.getString((String)"line"));
                    stringBuffer.append(":");
                    stringBuffer.append(' ');
                    stringBuffer.append(n);
                    stringBuffer.append(']');
                }
            }
            catch (NullPointerException nullPointerException) {
                COBOLDebugUIPlugin.logError(nullPointerException);
            }
        }
        return stringBuffer.toString();
    }

    private Image getVariableImage(IVariable iVariable) {
        try {
            if (iVariable instanceof ICOBOLVariable) {
                return COBOLDebugImages.get(COBOLDebugImages.IMG_OBJS_VARIABLE);
            }
        }
        catch (ClassCastException classCastException) {
            COBOLDebugUIPlugin.logError(classCastException);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return null;
    }

    private String getValueText(IValue iValue) {
        String string = "";
        if (iValue != null) {
            block14: {
                try {
                    if (!(iValue instanceof ICOBOLValue) || iValue.getVariables() == null || iValue.getVariables().length <= 0) break block14;
                    try {
                        if (((ICOBOLValue)iValue).getCOBOLType().getTypeID() == 39321) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("OCCURS(");
                            if (iValue.getVariables() != null) {
                                int n = 0;
                                if (((ICOBOLValue)iValue).isSplited()) {
                                    int n2 = iValue.getVariables().length;
                                    n = 100 * (n2 - 1) + iValue.getVariables()[n2 - 1].getValue().getVariables().length;
                                } else {
                                    n = iValue.getVariables().length;
                                }
                                stringBuffer.append(n);
                            } else {
                                stringBuffer.append("0");
                            }
                            stringBuffer.append(")");
                            return stringBuffer.toString();
                        }
                    }
                    catch (DebugException debugException) {
                        COBOLDebugUIPlugin.logError(debugException);
                    }
                    if (iValue.getValueString() != null && !iValue.getValueString().equals("")) {
                        string = this.getTextValueString(iValue);
                    }
                    return string;
                }
                catch (DebugException debugException) {
                    COBOLDebugUIPlugin.logError(debugException);
                }
            }
            try {
                if (iValue.getValueString() != null) {
                    string = this.getTextValueString(iValue);
                    return string;
                }
            }
            catch (DebugException debugException) {
                COBOLDebugUIPlugin.logError(debugException);
            }
        }
        return "null";
    }

    private String getVariableText(IVariable iVariable) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (iVariable != null) {
                if (this.fShowType) {
                    stringBuffer.append(iVariable.getReferenceTypeName());
                    stringBuffer.append(" ");
                }
                stringBuffer.append(iVariable.getName());
                if (iVariable instanceof ICOBOLVariable) {
                    stringBuffer.append(" = ");
                    stringBuffer.append(this.getValueText(iVariable.getValue()));
                }
            }
        }
        catch (DebugException debugException) {
            COBOLDebugUIPlugin.logError(debugException);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return stringBuffer.toString();
    }

    private String getTextValueString(IValue iValue) {
        StringBuffer stringBuffer;
        block14: {
            if (iValue == null) {
                return "";
            }
            stringBuffer = new StringBuffer();
            if (iValue instanceof ICOBOLValue) {
                block13: {
                    try {
                        int n = stringBuffer.toString().length();
                        stringBuffer.append(iValue.getValueString());
                        if (this.isStringDataType(((ICOBOLValue)iValue).getCOBOLType())) {
                            stringBuffer.insert(n, '\"');
                            stringBuffer.append("\"");
                        }
                    }
                    catch (DebugException debugException) {
                        COBOLDebugUIPlugin.logError(debugException);
                    }
                    try {
                        if (!this.fHexaDecimal || ((ICOBOLValue)iValue).getHexaValueString() == null || ((ICOBOLValue)iValue).getHexaValueString().trim().equals("")) break block13;
                        stringBuffer.append(" [0x");
                        try {
                            stringBuffer.append(((ICOBOLValue)iValue).getHexaValueString());
                        }
                        catch (DebugException debugException) {
                            COBOLDebugUIPlugin.logError(debugException);
                        }
                        stringBuffer.append("]");
                    }
                    catch (DebugException debugException) {
                        COBOLDebugUIPlugin.logError(debugException);
                    }
                }
                try {
                    if (!this.fAscii || ((ICOBOLValue)iValue).getCharValueString() == null || ((ICOBOLValue)iValue).getCharValueString().trim().equals("")) break block14;
                    stringBuffer.append(" [");
                    try {
                        stringBuffer.append(((ICOBOLValue)iValue).getCharValueString());
                    }
                    catch (DebugException debugException) {
                        COBOLDebugUIPlugin.logError(debugException);
                    }
                    stringBuffer.append("]");
                }
                catch (DebugException debugException) {
                    COBOLDebugUIPlugin.logError(debugException);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getStackFrameText(IStackFrame iStackFrame) {
        if (iStackFrame == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (((ICOBOLStackframe)iStackFrame).getProgramName().trim().length() == 0) {
                stringBuffer.append(Messages.getString((String)"NotResponding"));
            } else {
                stringBuffer.append(((ICOBOLStackframe)iStackFrame).getProgramName());
                stringBuffer.append(" [");
                stringBuffer.append(Messages.getString((String)"line"));
                stringBuffer.append(": ");
                stringBuffer.append(iStackFrame.getLineNumber());
                stringBuffer.append("]");
            }
        }
        catch (DebugException debugException) {
            COBOLDebugUIPlugin.logError(debugException);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        return stringBuffer.toString();
    }

    String getThreadText(IThread iThread) {
        StringBuffer stringBuffer;
        block8: {
            stringBuffer = new StringBuffer();
            try {
                if (!(iThread instanceof ICOBOLThread)) break block8;
                ICOBOLThread iCOBOLThread = (ICOBOLThread)iThread;
                stringBuffer.append(Messages.getFormattedString((String)"Systemthread_ID", (Object)new Long(iCOBOLThread.getSystemThreadId())));
                stringBuffer.append(" ");
                stringBuffer.append(Messages.getFormattedString((String)"Thread_Priorty", (Object)new Integer(iCOBOLThread.getPriority())));
                if (iCOBOLThread.isSuspended()) {
                    try {
                        ICOBOLStackframe iCOBOLStackframe = (ICOBOLStackframe)iCOBOLThread.getTopStackFrame();
                        if (iCOBOLStackframe != null && COBOLDebugModelPresentation.breakpointExistsWhenSuspended(iCOBOLStackframe.getName(), iCOBOLStackframe.getLineNumber())) {
                            stringBuffer.append(" (" + Messages.getString((String)"suspendedThread.label") + " (" + MessageFormat.format(Messages.getString((String)"suspendedThread.label.breakpoint"), Integer.toString(iCOBOLStackframe.getLineNumber()), iCOBOLStackframe.getProgramName()) + "))");
                            break block8;
                        }
                        stringBuffer.append(" (" + Messages.getString((String)"suspendedThread.label") + ")");
                    }
                    catch (CoreException coreException) {}
                    break block8;
                }
                if (iCOBOLThread.isTerminated()) {
                    stringBuffer.append(" (" + Messages.getString((String)"TerminatedThread.label") + ")");
                } else {
                    stringBuffer.append(" (" + Messages.getString((String)"runningThread.label") + ")");
                }
            }
            catch (DebugException debugException) {}
        }
        return stringBuffer.toString();
    }

    public boolean isStringDataType(ICOBOLType iCOBOLType) {
        int n = -1;
        try {
            n = iCOBOLType.getTypeID() & 0xFFFF;
        }
        catch (DebugException debugException) {
            COBOLDebugUIPlugin.logError(debugException);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        boolean bl = false;
        if (this.fStringDataTypes != null) {
            int n2 = 0;
            while (n2 < this.fStringDataTypes.length) {
                if (this.fStringDataTypes[n2] == n) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    protected String getHitCountString(ICOBOLHitCountBreakpoint iCOBOLHitCountBreakpoint) {
        int n = 0;
        try {
            n = iCOBOLHitCountBreakpoint.getHitCount();
        }
        catch (CoreException coreException) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append(" [");
            stringBuffer.append(Messages.getString((String)"hitcount"));
            stringBuffer.append(": ");
            stringBuffer.append(n);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    protected String getInterruptStatus(IValueDetailListener iValueDetailListener) {
        Object object;
        IStructuredSelection iStructuredSelection;
        if (iValueDetailListener instanceof COBOLWatchView && !(iStructuredSelection = ((COBOLWatchView)iValueDetailListener).getSelection()).isEmpty() && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof ICOBOLVariable) {
            boolean bl = ((ICOBOLVariable)object).isInterrupteable();
            return bl ? Messages.getString((String)"Interrupt_Enabled") : Messages.getString((String)"Interrupt_Disabled");
        }
        return "";
    }

    protected static boolean breakpointExistsWhenSuspended(String string, int n) throws CoreException {
        String string2 = COBOLDebugUtil.getPluginIdentifier();
        String string3 = COBOLLineBreakpoint.getMarkerType();
        IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints(string2);
        int n2 = 0;
        while (n2 < iBreakpointArray.length) {
            if (iBreakpointArray[n2] instanceof ICOBOLLineBreakpoint) {
                ICOBOLLineBreakpoint iCOBOLLineBreakpoint = (ICOBOLLineBreakpoint)iBreakpointArray[n2];
                try {
                    String string4;
                    if (iCOBOLLineBreakpoint.getMarker().getType().equals(string3) && (string4 = iCOBOLLineBreakpoint.getSourceName()).indexOf(File.separator) != -1 && (string4 = string4.substring(string4.lastIndexOf(File.separator) + 1)).trim().equals(string.trim()) && iCOBOLLineBreakpoint.getLineNumber() == n) {
                        return true;
                    }
                }
                catch (CoreException coreException) {
                    COBOLDebugPlugin.logError((Exception)((Object)coreException));
                }
                catch (NullPointerException nullPointerException) {
                    COBOLDebugPlugin.logError((Exception)nullPointerException);
                }
            }
            ++n2;
        }
        return false;
    }
}

