/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.debug.ui;

import com.unisys.os2200.i18nSupport.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cobol.debug.ui.COBOLDebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class COBOLDebugImages {
    private static final String NAME_PREFIX = COBOLDebugUIPlugin.getPluginId();
    private static final int NAME_PREFIX_LENGTH = NAME_PREFIX.length();
    private static URL iconBaseURL = null;
    private static final String T_OBJ = "obj16";
    private static final ImageRegistry IMAGE_REGISTRY;
    public static final String IMG_OBJS_BREAKPOINT_INSTALLED;
    public static final String IMG_OBJS_BREAKPOINT_DISABLED;
    public static final String IMG_OBJS_VARIABLE;
    public static final String IMG_OBJS_REMOVEALL;
    public static final String IMG_OBJS_REMOVEALL_DISABLED;
    public static final String IMG_OBJS_REMOVE;
    public static final String IMG_OBJS_REMOVE_DISABLED;
    public static final String IMG_OBJS_ADDWATCH;
    public static final String IMG_OBJS_ADDWATCH_VAR;
    public static final String IMG_OBJS_ADDWATCH_DISABLED;
    public static final String IMG_OBJS_LAUNCHER_MAINTAB;
    public static final String IMG_OBJS_LAUNCHER_SRCTAB;
    public static final String IMG_OBJS_RUNTOLINE;
    public static final String IMG_OBJS_DEBUG_TARGET_SUSPEND;
    public static final String IMG_OBJS_DEFAULT_THREAD_SUSPEND;
    public static final String IMG_OBJS_DEFAULT_THREAD_RESUME;
    public static final String IMG_OBJS_DEFAULT_THREAD_TERMINATE;
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT_INSTALLED;
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_VARIABLE;
    public static final ImageDescriptor DESC_OBJS_REMOVEALL;
    public static final ImageDescriptor DESC_OBJS_REMOVEALL_DISABLED;
    public static final ImageDescriptor DESC_OBJS_REMOVE;
    public static final ImageDescriptor DESC_OBJS_REMOVE_DISABLED;
    public static final ImageDescriptor DESC_OBJS_ADDWATCH;
    public static final ImageDescriptor DESC_OBJS_ADDWATCH_VAR;
    public static final ImageDescriptor DESC_OBJS_ADDWATCH_DISABLED;
    public static final ImageDescriptor DESC_OBJS_RUNTOLINE;
    public static final ImageDescriptor DESC_OBJS_DEBUG_TARGET_SUSPEND;
    public static final ImageDescriptor DESC_OBJS_THREAD_SUSPEND;
    public static final ImageDescriptor DESC_OBJS_THREAD_RESUME;
    public static final ImageDescriptor DESC_OBJS_THREAD_TERMINATE;
    public static final ImageDescriptor DESC_OBJS_LAUNCHER_MAINTAB;
    public static final ImageDescriptor DESC_OBJS_LAUNCHER_SRCTAB;

    static {
        String string = "icons/basic/";
        Display display = Display.getCurrent();
        if (display != null && display.getIconDepth() > 4) {
            string = "icons/full/";
        }
        try {
            iconBaseURL = new URL(COBOLDebugUIPlugin.getDefault().getDescriptor().getInstallURL(), string);
        }
        catch (MalformedURLException malformedURLException) {
            COBOLDebugUIPlugin.logError(malformedURLException);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
        }
        IMAGE_REGISTRY = COBOLDebugImages.setRegistry();
        IMG_OBJS_BREAKPOINT_INSTALLED = String.valueOf(NAME_PREFIX) + Messages.getString((String)"breakpointEnabledImage");
        IMG_OBJS_BREAKPOINT_DISABLED = String.valueOf(NAME_PREFIX) + Messages.getString((String)"breakpointDisabledImage");
        IMG_OBJS_VARIABLE = String.valueOf(NAME_PREFIX) + Messages.getString((String)"variablesImage");
        IMG_OBJS_REMOVEALL = String.valueOf(NAME_PREFIX) + Messages.getString((String)"removeAllImage");
        IMG_OBJS_REMOVEALL_DISABLED = String.valueOf(NAME_PREFIX) + Messages.getString((String)"removeAllDisabledImage");
        IMG_OBJS_REMOVE = String.valueOf(NAME_PREFIX) + Messages.getString((String)"removeImage");
        IMG_OBJS_REMOVE_DISABLED = String.valueOf(NAME_PREFIX) + Messages.getString((String)"removeDisabledImage");
        IMG_OBJS_ADDWATCH = String.valueOf(NAME_PREFIX) + Messages.getString((String)"addWatchImage");
        IMG_OBJS_ADDWATCH_VAR = String.valueOf(NAME_PREFIX) + Messages.getString((String)"addVariablesImage");
        IMG_OBJS_ADDWATCH_DISABLED = String.valueOf(NAME_PREFIX) + Messages.getString((String)"addWatchDisabledImage");
        IMG_OBJS_LAUNCHER_MAINTAB = String.valueOf(NAME_PREFIX) + Messages.getString((String)"cobolMainTabImage");
        IMG_OBJS_LAUNCHER_SRCTAB = String.valueOf(NAME_PREFIX) + Messages.getString((String)"cobolSrcTabImage");
        IMG_OBJS_RUNTOLINE = String.valueOf(NAME_PREFIX) + Messages.getString((String)"runToLineImage");
        IMG_OBJS_DEBUG_TARGET_SUSPEND = String.valueOf(NAME_PREFIX) + Messages.getString((String)"cobolDebugTargetSuspendImage");
        IMG_OBJS_DEFAULT_THREAD_SUSPEND = String.valueOf(NAME_PREFIX) + Messages.getString((String)"cobolDefaultThreadSuspendImage");
        IMG_OBJS_DEFAULT_THREAD_RESUME = String.valueOf(NAME_PREFIX) + Messages.getString((String)"cobolDefaultThreadResumeImage");
        IMG_OBJS_DEFAULT_THREAD_TERMINATE = String.valueOf(NAME_PREFIX) + Messages.getString((String)"cobolDefaultThreadTerminateImage");
        DESC_OBJS_BREAKPOINT_INSTALLED = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_BREAKPOINT_INSTALLED);
        DESC_OBJS_BREAKPOINT_DISABLED = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_BREAKPOINT_DISABLED);
        DESC_OBJS_VARIABLE = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_VARIABLE);
        DESC_OBJS_REMOVEALL = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_REMOVEALL);
        DESC_OBJS_REMOVEALL_DISABLED = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_REMOVEALL_DISABLED);
        DESC_OBJS_REMOVE = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_REMOVE);
        DESC_OBJS_REMOVE_DISABLED = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_REMOVE_DISABLED);
        DESC_OBJS_ADDWATCH = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_ADDWATCH);
        DESC_OBJS_ADDWATCH_VAR = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_ADDWATCH_VAR);
        DESC_OBJS_ADDWATCH_DISABLED = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_ADDWATCH_DISABLED);
        DESC_OBJS_RUNTOLINE = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_RUNTOLINE);
        DESC_OBJS_DEBUG_TARGET_SUSPEND = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_DEBUG_TARGET_SUSPEND);
        DESC_OBJS_THREAD_SUSPEND = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_DEFAULT_THREAD_SUSPEND);
        DESC_OBJS_THREAD_RESUME = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_DEFAULT_THREAD_RESUME);
        DESC_OBJS_THREAD_TERMINATE = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_DEFAULT_THREAD_TERMINATE);
        DESC_OBJS_LAUNCHER_MAINTAB = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_LAUNCHER_MAINTAB);
        DESC_OBJS_LAUNCHER_SRCTAB = COBOLDebugImages.createManaged(T_OBJ, IMG_OBJS_LAUNCHER_SRCTAB);
    }

    public static final ImageRegistry setRegistry() {
        try {
            return new ImageRegistry();
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return null;
        }
    }

    public static Image get(String string) {
        try {
            return IMAGE_REGISTRY.get(string);
        }
        catch (NullPointerException nullPointerException) {
            COBOLDebugUIPlugin.logError(nullPointerException);
            return null;
        }
    }

    public static void setToolImageDescriptors(IAction iAction, String string) {
        COBOLDebugImages.setImageDescriptors(iAction, "tool16", string);
    }

    public static void setLocalImageDescriptors(IAction iAction, String string) {
        COBOLDebugImages.setImageDescriptors(iAction, "lcl16", string);
    }

    static ImageRegistry getImageRegistry() {
        return IMAGE_REGISTRY;
    }

    private static void setImageDescriptors(IAction iAction, String string, String string2) {
        ImageDescriptor imageDescriptor;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)COBOLDebugImages.makeIconFileURL("d" + string, string2));
            if (imageDescriptor != null) {
                iAction.setDisabledImageDescriptor(imageDescriptor);
            }
        }
        catch (MalformedURLException malformedURLException) {
            COBOLDebugUIPlugin.logError(malformedURLException);
        }
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)COBOLDebugImages.makeIconFileURL("c" + string, string2));
            if (imageDescriptor != null) {
                iAction.setHoverImageDescriptor(imageDescriptor);
            }
        }
        catch (MalformedURLException malformedURLException) {
            COBOLDebugUIPlugin.logError(malformedURLException);
        }
        iAction.setImageDescriptor(COBOLDebugImages.create("e" + string, string2));
    }

    private static ImageDescriptor createManaged(String string, String string2) {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)COBOLDebugImages.makeIconFileURL(string, string2.substring(NAME_PREFIX_LENGTH)));
            IMAGE_REGISTRY.put(string2, imageDescriptor);
            return imageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String string, String string2) {
        try {
            return ImageDescriptor.createFromURL((URL)COBOLDebugImages.makeIconFileURL(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String string, String string2) throws MalformedURLException {
        if (iconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('/');
        stringBuffer.append(string2);
        return new URL(iconBaseURL, stringBuffer.toString());
    }
}

