/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.charset;

import com.unisys.os2200.charset.CharMapping;
import com.unisys.os2200.charset.DynamicCharacterMapping;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public final class Provider
extends CharsetProvider {
    private static final String pkg = Provider.class.getPackage().getName();
    private static final ArrayList<String> classList = new ArrayList();
    private static final HashMap<String, NameSet> classMap = new HashMap();
    private static final HashMap<String, String> aliasMap = new HashMap();
    private static Map<String, ArrayList<CharMapping>> encodings;
    private static ResourceBundle resourceBundle;
    protected static final String PACKAGE_NAME = "com.unisys.os2200.charset";
    protected static final String MESSAGE_FILE_NAME = "ClientMessages";
    private HashMap<String, SoftReference<Charset>> csMap = new HashMap();

    @Override
    public Charset charsetForName(String string) {
        String string2 = aliasMap.get(string.toLowerCase());
        if (string2 == null) {
            return null;
        }
        return this.findCharset(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Charset findCharset(String string) {
        Charset charset;
        HashMap<String, SoftReference<Charset>> hashMap = this.csMap;
        synchronized (hashMap) {
            Class<?> clazz;
            SoftReference<Charset> softReference = this.csMap.get(string);
            if (softReference != null && (charset = softReference.get()) != null) {
                return charset;
            }
            try {
                clazz = Class.forName(pkg + '.' + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            try {
                charset = (Charset)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            softReference = new SoftReference<Charset>(charset);
            this.csMap.put(string, softReference);
        }
        return charset;
    }

    @Override
    public Iterator<Charset> charsets() {
        return new CsIterator();
    }

    static ArrayList<CharMapping> findEncodingData(String string) {
        ArrayList<CharMapping> arrayList = null;
        String[] stringArray = Provider.getNames((String)string).aliases;
        if (encodings != null) {
            for (int i = 0; i < stringArray.length && (arrayList = encodings.get(stringArray[i].toUpperCase())) == null; ++i) {
            }
        }
        return arrayList;
    }

    static NameSet getNames(String string) {
        return classMap.get(string);
    }

    private static void register(String string, String string2, String[] stringArray) {
        classList.add(string);
        classMap.put(string, new NameSet(string2, stringArray));
        aliasMap.put(string2.toLowerCase(), string);
        for (String string3 : stringArray) {
            aliasMap.put(string3.toLowerCase(), string);
        }
    }

    private static ResourceBundle initializeResourceBundle() {
        String string = "com.unisys.os2200.charset.ClientMessages";
        return ResourceBundle.getBundle(string, Locale.getDefault());
    }

    static String GetMessage(String string, Object ... objectArray) {
        String string2;
        try {
            string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Unable to retrieve error message text for error code: " + string;
        }
        return string2;
    }

    static {
        resourceBundle = Provider.initializeResourceBundle();
        Provider.register("ISO646CA", "x-ISO646-CA", new String[]{"iso646ca", "iso-646-ca"});
        Provider.register("ISO646CH", "x-ISO646-CH", new String[]{"iso646ch", "iso-646-ch"});
        Provider.register("ISO646DE", "x-ISO646-DE", new String[]{"iso646de", "iso-646-de"});
        Provider.register("ISO646ES", "x-ISO646-ES", new String[]{"iso646es", "iso-646-es"});
        Provider.register("ISO646FI", "x-ISO646-FI", new String[]{"iso646fi", "iso-646-fi"});
        Provider.register("ISO646FR", "x-ISO646-FR", new String[]{"iso646fr", "iso-646-fr"});
        Provider.register("ISO646GB", "x-ISO646-GB", new String[]{"iso646gb", "iso-646-gb"});
        Provider.register("ISO646IT", "x-ISO646-IT", new String[]{"iso646it", "iso-646-it"});
        Provider.register("ISO646NL", "x-ISO646-NL", new String[]{"iso646nl", "iso-646-nl"});
        Provider.register("ISO646NO", "x-ISO646-NO", new String[]{"iso646no", "iso-646-no"});
        Provider.register("ISO646PT", "x-ISO646-PT", new String[]{"iso646pt", "iso-646-pt"});
        Provider.register("ISO646SE", "x-ISO646-SE", new String[]{"iso646se", "iso-646-se"});
        Provider.register("LETSJ", "x-LETS-J", new String[]{"lets-j", "letsj"});
        Provider.register("LETSJKanji", "x-LETS-J-Kanji", new String[]{"lets-j-kanji", "letsj-kanji"});
        encodings = DynamicCharacterMapping.LoadMappingData();
    }

    static class NameSet {
        String canonical;
        String[] aliases;

        NameSet(String string, String[] stringArray) {
            this.canonical = string;
            this.aliases = stringArray;
        }
    }

    class CsIterator
    implements Iterator<Charset> {
        int index;

        CsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < classList.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Charset next() {
            int n;
            CsIterator csIterator = this;
            synchronized (csIterator) {
                if (this.index == classList.size()) {
                    throw new NoSuchElementException();
                }
                n = this.index++;
            }
            return Provider.this.findCharset((String)classList.get(n));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

