/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.charset;

import com.unisys.os2200.charset.LETSJ;
import com.unisys.os2200.charset.Provider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class LETSJKanji
extends LETSJ {
    private static final String className = LETSJKanji.class.getSimpleName();
    private static final Provider.NameSet names = Provider.getNames(className);

    public LETSJKanji() {
        super(LETSJKanji.names.canonical, LETSJKanji.names.aliases);
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof LETSJKanji;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        int overByte = -1;
        int overChar = -1;

        public Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f, new byte[]{95});
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.remaining();
            int n2 = byteBuffer.remaining();
            while (true) {
                int n3;
                if (this.overByte >= 0) {
                    if (n2 == 0) {
                        return CoderResult.OVERFLOW;
                    }
                    byteBuffer.put((byte)this.overByte);
                    --n2;
                    this.overByte = -1;
                }
                if (this.overChar >= 0) {
                    n3 = this.overChar;
                    this.overChar = -1;
                } else {
                    if (n == 0) {
                        return CoderResult.UNDERFLOW;
                    }
                    n3 = charBuffer.get();
                    --n;
                }
                if (n2 == 0) {
                    this.overChar = n3;
                    return CoderResult.OVERFLOW;
                }
                StringBuilder stringBuilder = LETSJ.letsjOut[n3 >> 8];
                int n4 = (n3 & 0xFF) * 2;
                char c = stringBuilder.charAt(n4);
                char c2 = stringBuilder.charAt(n4 + 1);
                if (c2 == '\u0100') {
                    return CoderResult.malformedForLength(2);
                }
                byteBuffer.put((byte)c);
                if (--n2 == 0) {
                    this.overByte = c2;
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)c2);
                --n2;
            }
        }

        @Override
        protected void implReset() {
            this.overByte = -1;
            this.overChar = -1;
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        int underByte = -1;

        public Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.remaining();
            int n2 = charBuffer.remaining();
            while (true) {
                if (this.underByte < 0) {
                    if (n == 0) {
                        return CoderResult.UNDERFLOW;
                    }
                    this.underByte = byteBuffer.get() & 0xFF;
                    --n;
                }
                if (n2 == 0) {
                    return CoderResult.OVERFLOW;
                }
                if (n == 0) {
                    return CoderResult.UNDERFLOW;
                }
                int n3 = byteBuffer.get() & 0xFF;
                --n;
                if (this.underByte == 147 && (n3 == 241 || n3 == 112)) {
                    return CoderResult.malformedForLength(2);
                }
                charBuffer.put(LETSJ.letsjKanjiIn[this.underByte].charAt(n3));
                --n2;
                this.underByte = -1;
            }
        }

        @Override
        protected void implReset() {
            this.underByte = -1;
        }
    }
}

