/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public abstract class ISO646Base
extends Charset {
    private final char[][] convertTable;

    public ISO646Base(String string, String[] stringArray, char[][] cArray) {
        super(string, stringArray);
        this.convertTable = cArray;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private class Encoder
    extends CharsetEncoder {
        public Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f, new byte[]{95});
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                byte by = (byte)c;
                for (int i = 0; i < ISO646Base.this.convertTable.length; ++i) {
                    if (c != ISO646Base.this.convertTable[i][1]) continue;
                    by = (byte)ISO646Base.this.convertTable[i][0];
                    break;
                }
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put(by);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private class Decoder
    extends CharsetDecoder {
        public Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                char c = (char)by;
                for (int i = 0; i < ISO646Base.this.convertTable.length; ++i) {
                    if (by != ISO646Base.this.convertTable[i][0]) continue;
                    c = ISO646Base.this.convertTable[i][1];
                    break;
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(c);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

