/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.os2200.charset;

import com.unisys.os2200.charset.CharMapping;
import com.unisys.os2200.charset.InvalidCharacterMappingException;
import com.unisys.os2200.charset.Provider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class DynamicCharacterMapping {
    private static final String CHAR_MAPPING_PROPERTY = "unisys.charset.mapping";
    private static final String TOKEN_DELIMTERS = "[:#]+";
    private static final String DEFAULT_FILE_NAME = "CharacterMappings.txt";
    private static final char UTF_8_BOM = '\ufeff';
    private static boolean overwriteAllowed = false;

    DynamicCharacterMapping() {
    }

    static boolean isOverwriteAllowed() {
        return overwriteAllowed;
    }

    static Map<String, ArrayList<CharMapping>> LoadMappingData() throws InvalidCharacterMappingException {
        File file;
        Map<String, ArrayList<CharMapping>> map = null;
        String string = System.getProperty(CHAR_MAPPING_PROPERTY);
        if (string == null) {
            string = System.getProperty("user.dir") + File.separatorChar + DEFAULT_FILE_NAME;
        }
        if ((file = new File(string)).exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                bufferedReader.mark(1);
                if (bufferedReader.read() != 65279) {
                    bufferedReader.reset();
                }
                map = DynamicCharacterMapping.ProcessMappingData(bufferedReader);
            }
            catch (Exception exception) {
                throw new InvalidCharacterMappingException(exception);
            }
        }
        return map;
    }

    static Map<String, ArrayList<CharMapping>> ProcessMappingData(BufferedReader bufferedReader) throws InvalidCharacterMappingException {
        HashMap<String, ArrayList<CharMapping>> hashMap = new HashMap<String, ArrayList<CharMapping>>();
        ArrayList<CharMapping> arrayList = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string2.startsWith("#") || string2.trim().isEmpty()) continue;
                if (string2.startsWith("OVERWRITE_ALLOWED:")) {
                    stringArray = string2.split(TOKEN_DELIMTERS);
                    overwriteAllowed = stringArray[1].trim().compareToIgnoreCase("TRUE") == 0;
                    continue;
                }
                if (string2.startsWith("BEGIN_MAPPING:")) {
                    arrayList = new ArrayList<CharMapping>();
                    stringArray = string2.split(TOKEN_DELIMTERS);
                    if (stringArray.length < 2) {
                        throw new InvalidCharacterMappingException(Provider.GetMessage("1000", new Object[0]));
                    }
                    string = stringArray[1].trim().toUpperCase();
                    bl = true;
                    continue;
                }
                if (string2.startsWith("END_MAPPING:")) {
                    hashMap.put(string, arrayList);
                    arrayList = null;
                    string = null;
                    bl = false;
                    continue;
                }
                if (bl) {
                    stringArray = DynamicCharacterMapping.ValidateMappingValues(string2);
                    int n = DynamicCharacterMapping.ValidateCharacterValue(stringArray[0]);
                    int[] nArray = DynamicCharacterMapping.ValidateEncodedBytes(stringArray[1]);
                    CharMapping charMapping = new CharMapping(n, nArray);
                    arrayList.add(charMapping);
                    continue;
                }
                if (string2.trim().length() == 0) continue;
                throw new InvalidCharacterMappingException(Provider.GetMessage("1001", string2));
            }
        }
        catch (IOException iOException) {
            throw new InvalidCharacterMappingException(iOException);
        }
        return hashMap;
    }

    private static String[] ValidateMappingValues(String string) throws InvalidCharacterMappingException {
        String[] stringArray = string.split(TOKEN_DELIMTERS);
        if (stringArray.length < 2) {
            throw new InvalidCharacterMappingException(Provider.GetMessage("1002", string));
        }
        if (stringArray[0].trim().length() != 4) {
            throw new InvalidCharacterMappingException(Provider.GetMessage("1003", stringArray[0].trim()));
        }
        if (stringArray[1].trim().length() != 4) {
            throw new InvalidCharacterMappingException(Provider.GetMessage("1003", stringArray[1].trim()));
        }
        return stringArray;
    }

    private static int ValidateCharacterValue(String string) throws InvalidCharacterMappingException {
        int n;
        try {
            n = Integer.valueOf(string.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidCharacterMappingException(Provider.GetMessage("1003", string.trim()), numberFormatException);
        }
        return n;
    }

    private static int[] ValidateEncodedBytes(String string) throws InvalidCharacterMappingException {
        int[] nArray = new int[]{0, 0, 0};
        try {
            nArray[1] = Integer.valueOf(string.trim().substring(0, 2), 16);
            if (nArray[1] == 0) {
                nArray[1] = Integer.valueOf(string.trim().substring(2, 4), 16);
                nArray[0] = 1;
            } else {
                nArray[2] = Integer.valueOf(string.trim().substring(2, 4), 16);
                nArray[0] = 2;
                if (nArray[1] == 32 && nArray[2] == 13) {
                    throw new InvalidCharacterMappingException(Provider.GetMessage("1005", new Object[0]));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidCharacterMappingException(Provider.GetMessage("1003", string.trim()), numberFormatException);
        }
        return nArray;
    }
}

