/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.build.ant;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Target;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ICommonConstants;
import org.eclipse.cobol.core.build.BuildHandler;
import org.eclipse.cobol.core.build.ProjectBuildToolsInteraction;
import org.eclipse.cobol.core.build.ant.BuildListenerMessages;
import org.eclipse.cobol.core.build.model.IBuildTool;
import org.eclipse.cobol.core.build.util.LogViewHelper;
import org.eclipse.cobol.core.build.util.TaskViewhelper;
import org.eclipse.cobol.core.registry.internal.IBuildToolDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Display;

public class CobolBuildLogger
implements BuildLogger {
    private IProject fProject = null;
    private IProgressMonitor fMonitor = null;
    private int fPriorityFilter = 2;
    private Hashtable fhBuildListeners = null;
    private BuildListener currentListener = null;
    private boolean fIsMessageLogged = false;
    private LogViewHelper logView = null;
    private ArrayList alLoggedMessages = null;
    private StringBuffer fsExceptionMessages = null;
    private boolean fbMarkersRemoved = false;
    boolean buildCancelled = false;

    public CobolBuildLogger() {
        if (CorePlugin.getDefault() != null) {
            this.fMonitor = CorePlugin.getDefault().getProgressMonitor();
            this.fProject = CorePlugin.getDefault().getCurrentProject();
        }
        this.fIsMessageLogged = false;
        this.alLoggedMessages = new ArrayList();
        this.fsExceptionMessages = new StringBuffer();
        this.logView = LogViewHelper.getDefault();
        this.collectBuildListener();
    }

    private void collectBuildListener() {
        this.fhBuildListeners = new Hashtable();
        ArrayList alBuildToolDescriptors = ProjectBuildToolsInteraction.getBuildDescriptors((IProject)this.fProject);
        int iBuildToolDescriptorsSize = alBuildToolDescriptors.size();
        for (int i = 0; i < iBuildToolDescriptorsSize; ++i) {
            try {
                IBuildToolDescriptor desc = (IBuildToolDescriptor)alBuildToolDescriptors.get(i);
                String sId = desc.getId();
                BuildListener bl = null;
                try {
                    IBuildTool bt = desc.createBuildTool();
                    bt.setProject(this.fProject);
                    String sClassName = bt.getBuildListenerClassName();
                    try {
                        bl = (BuildListener)Class.forName(sClassName).newInstance();
                    }
                    catch (InstantiationException e) {
                        CorePlugin.logError((Exception)e);
                    }
                    catch (IllegalAccessException e) {
                        CorePlugin.logError((Exception)e);
                    }
                    catch (ClassNotFoundException e) {
                        CorePlugin.logError((Exception)e);
                    }
                }
                catch (CoreException e) {
                    CorePlugin.logError((Exception)((Object)e));
                }
                this.fhBuildListeners.put(sId.replaceFirst("_buildtool", ""), bl);
                continue;
            }
            catch (Exception e) {
                CorePlugin.logError((Exception)e);
            }
        }
    }

    public void buildStarted(BuildEvent event) {
        if (this.logView != null) {
            this.logView.setErrorMessageDisplayed(false);
        }
        this.fbMarkersRemoved = true;
        if (this.fMonitor != null && BuildHandler.isBuildRunning()) {
            this.fMonitor.subTask(BuildListenerMessages.getString((String)"BuildLogger.Build_Started_2"));
        }
        Enumeration e = this.fhBuildListeners.elements();
        while (e.hasMoreElements()) {
            BuildListener element = (BuildListener)e.nextElement();
            try {
                element.buildStarted(event);
            }
            catch (Exception ex) {
                CorePlugin.logError((Exception)ex);
            }
        }
    }

    public void buildFinished(BuildEvent event) {
        Enumeration e = this.fhBuildListeners.elements();
        while (e.hasMoreElements()) {
            BuildListener element = (BuildListener)e.nextElement();
            try {
                element.buildFinished(event);
            }
            catch (Exception ex) {
                CorePlugin.logError((Exception)ex);
            }
        }
        String SMessageToLog = null;
        if (this.fsExceptionMessages != null) {
            SMessageToLog = this.fsExceptionMessages.toString();
        }
        if (SMessageToLog == null || SMessageToLog.length() > 0) {
            // empty if block
        }
        boolean bErrorMessageDisplayed = false;
        if (this.logView != null) {
            bErrorMessageDisplayed = this.logView.isErrorMessageDisplayed();
        }
        Throwable ex = event.getException();
        if (!this.buildCancelled && !bErrorMessageDisplayed && BuildHandler.isBuildRunning()) {
            if (this.logView != null) {
                this.logView.logMessageInLogConsole(BuildListenerMessages.getString((String)"BuildLogger.Build_Successful_4"), 2, this.fPriorityFilter);
            }
        } else if (this.buildCancelled) {
            event.setException((Throwable)new OperationCanceledException());
            ex = event.getException();
        }
        boolean bBuildExceptionThrown = false;
        if (ex != null) {
            String sMessage = ex.getMessage();
            String sMessageToBeDisplayed = null;
            if (sMessage != null && !sMessage.equals("java.lang.reflect.InvocationTargetException")) {
                sMessageToBeDisplayed = ex.toString();
            }
            if (ex instanceof OperationCanceledException) {
                if (this.logView != null && sMessage != null) {
                    this.logView.logMessageInLogConsole(sMessage, 2, this.fPriorityFilter);
                }
            } else if (ex instanceof BuildCanceledException) {
                if (this.logView != null && sMessageToBeDisplayed != null) {
                    this.logView.logMessageInLogConsole(sMessageToBeDisplayed, 2, this.fPriorityFilter);
                }
            } else {
                bBuildExceptionThrown = true;
                if (this.logView != null && sMessageToBeDisplayed != null) {
                    this.logView.logMessageInLogConsole(sMessageToBeDisplayed, 0, this.fPriorityFilter);
                }
            }
        }
        if ((bErrorMessageDisplayed || bBuildExceptionThrown) && BuildHandler.isBuildRunning()) {
            if (this.logView != null) {
                this.logView.logMessageInLogConsole(BuildListenerMessages.getString((String)"BuildLogger.Build_Failed_5"), 0, this.fPriorityFilter);
            }
            if (this.fbMarkersRemoved) {
                TaskViewhelper.getDefault().addProblemMarker("org.eclipse.cobol.core.problem", (IResource)this.fProject, BuildListenerMessages.getString((String)"BuildLogger.BuildFailed"), 2, 2, null, null, null);
                this.fbMarkersRemoved = false;
            }
        }
        this.logView.flush();
    }

    public void messageLogged(BuildEvent event) {
        String sMessage;
        if (this.logView.toConsolePriority(event.getPriority()) <= 2 && (sMessage = event.getMessage()) != null && sMessage.length() > 0) {
            if (sMessage.trim().startsWith("at ") && sMessage.trim().endsWith(")")) {
                this.fsExceptionMessages.append(sMessage);
                this.fsExceptionMessages.append(ICommonConstants.EOL);
            } else if (this.currentListener != null) {
                try {
                    this.currentListener.messageLogged(event);
                }
                catch (Exception ex) {
                    CorePlugin.logError((Exception)ex);
                }
            }
        }
    }

    public void targetStarted(BuildEvent event) {
        BuildListener bl;
        this.currentListener = bl = this.provideBuildListener(event);
        if (bl != null) {
            try {
                bl.targetStarted(event);
            }
            catch (Exception ex) {
                CorePlugin.logError((Exception)ex);
            }
        }
    }

    public void targetFinished(BuildEvent event) {
        BuildListener bl;
        if (this.fMonitor != null) {
            this.fMonitor.worked(1);
        }
        this.currentListener = bl = this.provideBuildListener(event);
        if (bl != null) {
            try {
                bl.targetFinished(event);
            }
            catch (Exception ex) {
                CorePlugin.logError((Exception)ex);
            }
        }
        if (this.logView != null) {
            this.logView.flush();
        }
    }

    public void taskStarted(BuildEvent event) {
        BuildListener bl;
        this.checkCanceled();
        Target t = event.getTarget();
        String sDesc = t.getDescription();
        if (sDesc != null && this.fMonitor != null) {
            this.fMonitor.subTask(sDesc);
        }
        String sUniqueMessageName = t.getName() + sDesc;
        if (sDesc != null && sDesc.length() > 0 && !this.alLoggedMessages.contains(sUniqueMessageName) && this.logView != null) {
            this.logView.logMessageInLogConsole(sDesc, 2, this.fPriorityFilter);
            this.alLoggedMessages.add(sUniqueMessageName);
        }
        this.currentListener = bl = this.provideBuildListener(event);
        if (bl != null) {
            try {
                bl.taskStarted(event);
            }
            catch (Exception ex) {
                CorePlugin.logError((Exception)ex);
            }
        }
    }

    public void taskFinished(BuildEvent event) {
        BuildListener bl;
        this.checkCanceled();
        this.currentListener = bl = this.provideBuildListener(event);
        if (bl != null) {
            try {
                bl.taskFinished(event);
            }
            catch (Exception ex) {
                CorePlugin.logError((Exception)ex);
            }
        }
    }

    private void checkCanceled() {
        if (CorePlugin.getDefault().isAutoBuildRunning()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CobolBuildLogger.this.isCanceled();
                }
            });
        } else {
            this.isCanceled();
        }
    }

    public void isCanceled() throws BuildCanceledException {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            this.buildCancelled = true;
            throw new BuildCanceledException(BuildListenerMessages.getString((String)"BuildLogger.BuildCanceled"));
        }
    }

    private BuildListener provideBuildListener(BuildEvent event) {
        BuildListener bl = null;
        try {
            int iHiphenPos;
            if (event != null && event.getTarget() != null && event.getTarget().getName() != null && (iHiphenPos = event.getTarget().getName().indexOf("-")) >= 0) {
                String sBuildToolId = event.getTarget().getName().substring(0, iHiphenPos).trim();
                bl = (BuildListener)this.fhBuildListeners.get(sBuildToolId);
            }
        }
        catch (NullPointerException e) {
            CorePlugin.logError((Exception)e);
        }
        catch (Exception e) {
            CorePlugin.logError((Exception)e);
        }
        return bl;
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    public void setMessageOutputLevel(int level) {
        this.fPriorityFilter = this.logView.toConsolePriority(level);
    }

    public void setOutputPrintStream(PrintStream output) {
    }

    class BuildCanceledException
    extends BuildException {
        private static final long serialVersionUID = 1L;

        public BuildCanceledException() {
        }

        public BuildCanceledException(String msg) {
            super(msg);
        }
    }
}

