/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import org.eclipse.cdt.dsf.debug.service.AbstractDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_4;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_6;
import org.eclipse.cdt.dsf.gdb.service.GDBBreakpoints_7_7;
import org.eclipse.cdt.dsf.gdb.service.GDBDisassembly_7_3;
import org.eclipse.cdt.dsf.gdb.service.GDBHardwareAndOS;
import org.eclipse.cdt.dsf.gdb.service.GDBHardwareAndOS_7_5;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory_7_6;
import org.eclipse.cdt.dsf.gdb.service.GDBPatternMatchingExpressions;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_1;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_2_1;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_4;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_0;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_6;
import org.eclipse.cdt.dsf.gdb.service.GDBTraceControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBTraceControl_7_4;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.command.CommandFactory_6_8;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_0;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_4;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl_7_7;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.MIBreakpoints;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsSynchronizer;
import org.eclipse.cdt.dsf.mi.service.MIDisassembly;
import org.eclipse.cdt.dsf.mi.service.MIExpressions;
import org.eclipse.cdt.dsf.mi.service.MIModules;
import org.eclipse.cdt.dsf.mi.service.MIRegisters;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GdbDebugServicesFactory
extends AbstractDsfDebugServicesFactory {
    public static final String GDB_6_8_VERSION = "6.8";
    public static final String GDB_7_0_VERSION = "7.0";
    public static final String GDB_7_1_VERSION = "7.1";
    public static final String GDB_7_2_VERSION = "7.2";
    public static final String GDB_7_2_1_VERSION = "7.2.1";
    public static final String GDB_7_3_VERSION = "7.3";
    public static final String GDB_7_4_VERSION = "7.4";
    public static final String GDB_7_5_VERSION = "7.5";
    public static final String GDB_7_6_VERSION = "7.5.50";
    public static final String GDB_7_7_VERSION = "7.7";
    private final String fVersion;

    public GdbDebugServicesFactory(String version) {
        this.fVersion = version;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public <V> V createService(Class<V> clazz, DsfSession session, Object ... optionalArguments) {
        if (MIBreakpointsManager.class.isAssignableFrom(clazz)) {
            return (V)((Object)this.createBreakpointManagerService(session));
        }
        if (ICommandControl.class.isAssignableFrom(clazz)) {
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createCommandControl(session, (ILaunchConfiguration)arg);
                }
                ++n2;
            }
        } else if (IMIBackend.class.isAssignableFrom(clazz)) {
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n3 = 0;
            while (n3 < n) {
                Object arg = objectArray[n3];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createBackendGDBService(session, (ILaunchConfiguration)arg);
                }
                ++n3;
            }
        } else if (IGDBTraceControl.class.isAssignableFrom(clazz)) {
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n4 = 0;
            while (n4 < n) {
                Object arg = objectArray[n4];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createTraceControlService(session, (ILaunchConfiguration)arg);
                }
                ++n4;
            }
        } else if (IGDBHardwareAndOS.class.isAssignableFrom(clazz)) {
            Object[] objectArray = optionalArguments;
            int n = optionalArguments.length;
            int n5 = 0;
            while (n5 < n) {
                Object arg = objectArray[n5];
                if (arg instanceof ILaunchConfiguration) {
                    return (V)this.createHardwareAndOSService(session, (ILaunchConfiguration)arg);
                }
                ++n5;
            }
        } else if (MIBreakpointsSynchronizer.class.isAssignableFrom(clazz)) {
            return (V)this.createBreakpointsSynchronizerService(session);
        }
        return (V)super.createService(clazz, session, optionalArguments);
    }

    protected MIBreakpointsManager createBreakpointManagerService(DsfSession session) {
        return new MIBreakpointsManager(session, "org.eclipse.cdt.debug.core");
    }

    protected IBreakpoints createBreakpointService(DsfSession session) {
        if (GDB_7_7_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBBreakpoints_7_7(session);
        }
        if (GDB_7_6_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBBreakpoints_7_6(session);
        }
        if (GDB_7_4_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBBreakpoints_7_4(session);
        }
        if (GDB_7_2_VERSION.compareTo(this.fVersion) <= 0 || "6.8.50.20090414".equals(this.fVersion)) {
            return new GDBBreakpoints_7_2(session);
        }
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBBreakpoints_7_0(session);
        }
        return new MIBreakpoints(session);
    }

    protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
        if (GDB_7_7_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBControl_7_7(session, config, (CommandFactory)new CommandFactory_6_8());
        }
        if (GDB_7_4_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBControl_7_4(session, config, (CommandFactory)new CommandFactory_6_8());
        }
        if (GDB_7_2_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBControl_7_2(session, config, (CommandFactory)new CommandFactory_6_8());
        }
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBControl_7_0(session, config, (CommandFactory)new CommandFactory_6_8());
        }
        if (GDB_6_8_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBControl(session, config, (CommandFactory)new CommandFactory_6_8());
        }
        return new GDBControl(session, config, new CommandFactory());
    }

    protected IMIBackend createBackendGDBService(DsfSession session, ILaunchConfiguration lc) {
        return new GDBBackend(session, lc);
    }

    protected IDisassembly createDisassemblyService(DsfSession session) {
        if (GDB_7_3_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBDisassembly_7_3(session);
        }
        return new MIDisassembly(session);
    }

    protected IExpressions createExpressionService(DsfSession session) {
        MIExpressions originialExpressionService = new MIExpressions(session);
        return new GDBPatternMatchingExpressions(session, originialExpressionService);
    }

    protected IMemory createMemoryService(DsfSession session) {
        if (GDB_7_6_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBMemory_7_6(session);
        }
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBMemory_7_0(session);
        }
        return new GDBMemory(session);
    }

    protected IModules createModulesService(DsfSession session) {
        return new MIModules(session);
    }

    protected IProcesses createProcessesService(DsfSession session) {
        if (GDB_7_4_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBProcesses_7_4(session);
        }
        if (GDB_7_2_1_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBProcesses_7_2_1(session);
        }
        if (GDB_7_2_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBProcesses_7_2(session);
        }
        if (GDB_7_1_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBProcesses_7_1(session);
        }
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBProcesses_7_0(session);
        }
        return new GDBProcesses(session);
    }

    protected IRegisters createRegistersService(DsfSession session) {
        return new MIRegisters(session);
    }

    protected IRunControl createRunControlService(DsfSession session) {
        if (GDB_7_6_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBRunControl_7_6(session);
        }
        if (GDB_7_0_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBRunControl_7_0(session);
        }
        return new GDBRunControl(session);
    }

    protected ISourceLookup createSourceLookupService(DsfSession session) {
        return new CSourceLookup(session);
    }

    protected IStack createStackService(DsfSession session) {
        return new MIStack(session);
    }

    protected IGDBTraceControl createTraceControlService(DsfSession session, ILaunchConfiguration config) {
        if (GDB_7_4_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBTraceControl_7_4(session, config);
        }
        if (GDB_7_2_VERSION.compareTo(this.fVersion) <= 0 || "6.8.50.20090414".equals(this.fVersion)) {
            return new GDBTraceControl_7_2(session, config);
        }
        return null;
    }

    protected IGDBHardwareAndOS createHardwareAndOSService(DsfSession session, ILaunchConfiguration config) {
        if (GDB_7_5_VERSION.compareTo(this.fVersion) <= 0) {
            return new GDBHardwareAndOS_7_5(session);
        }
        return new GDBHardwareAndOS(session);
    }

    protected MIBreakpointsSynchronizer createBreakpointsSynchronizerService(DsfSession session) {
        return new MIBreakpointsSynchronizer(session);
    }
}

