/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.templates;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.photran.internal.cdtinterface.templates.PhotranBaseProcessRunner;

public class AddFortranErrorParsersProcessRunner
extends PhotranBaseProcessRunner {
    private static final String ERROR_PARSERS_EXTENSION_POINT = "org.eclipse.cdt.core.ErrorParser";
    private static final String DEFAULT_ERROR_PARSERS = "org.eclipse.cdt.core.MakeErrorParser;org.eclipse.photran.core.GFortranErrorParser;org.eclipse.cdt.core.GCCErrorParser;org.eclipse.cdt.core.GLDErrorParser;org.eclipse.cdt.core.GASErrorParser";

    @Override
    protected void modify(IProject proj, IConfiguration cf) {
        if (!this.containsAtLeastOnePhotranErrorParser(cf)) {
            this.addAllPhotranErrorParsersTo(cf);
        }
    }

    private boolean containsAtLeastOnePhotranErrorParser(IConfiguration cf) {
        return cf.getErrorParserIds().contains("org.eclipse.photran");
    }

    private void addAllPhotranErrorParsersTo(IConfiguration cf) {
        StringBuilder sb = new StringBuilder(DEFAULT_ERROR_PARSERS);
        IExtension[] iExtensionArray = this.errorParsersExtPt().getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            if (ext.getLabel().contains("Photran")) {
                sb.append(';');
                sb.append(ext.getNamespaceIdentifier());
                sb.append('.');
                sb.append(ext.getSimpleIdentifier());
            }
            ++n2;
        }
        cf.setErrorParserIds(sb.toString());
    }

    private IExtensionPoint errorParsersExtPt() {
        return Platform.getExtensionRegistry().getExtensionPoint(ERROR_PARSERS_EXTENSION_POINT);
    }
}

